/*
 * Decompiled with CFR 0.152.
 */
package jirasync.org.apache.http.impl.client;

import java.net.ProxySelector;
import jirasync.org.apache.http.ConnectionReuseStrategy;
import jirasync.org.apache.http.annotation.ThreadSafe;
import jirasync.org.apache.http.conn.ClientConnectionManager;
import jirasync.org.apache.http.conn.routing.HttpRoutePlanner;
import jirasync.org.apache.http.impl.DefaultConnectionReuseStrategy;
import jirasync.org.apache.http.impl.NoConnectionReuseStrategy;
import jirasync.org.apache.http.impl.client.DefaultHttpClient;
import jirasync.org.apache.http.impl.conn.PoolingClientConnectionManager;
import jirasync.org.apache.http.impl.conn.ProxySelectorRoutePlanner;
import jirasync.org.apache.http.impl.conn.SchemeRegistryFactory;
import jirasync.org.apache.http.params.HttpParams;

@ThreadSafe
public class SystemDefaultHttpClient
extends DefaultHttpClient {
    public SystemDefaultHttpClient(HttpParams params) {
        super(null, params);
    }

    public SystemDefaultHttpClient() {
        super(null, null);
    }

    protected ClientConnectionManager createClientConnectionManager() {
        PoolingClientConnectionManager connmgr = new PoolingClientConnectionManager(SchemeRegistryFactory.createSystemDefault());
        String s = System.getProperty("http.keepAlive");
        if ("true".equalsIgnoreCase(s)) {
            s = System.getProperty("http.maxConnections", "5");
            int max = Integer.parseInt(s);
            connmgr.setDefaultMaxPerRoute(max);
            connmgr.setMaxTotal(2 * max);
        }
        return connmgr;
    }

    protected HttpRoutePlanner createHttpRoutePlanner() {
        return new ProxySelectorRoutePlanner(this.getConnectionManager().getSchemeRegistry(), ProxySelector.getDefault());
    }

    protected ConnectionReuseStrategy createConnectionReuseStrategy() {
        String s = System.getProperty("http.keepAlive");
        if ("true".equalsIgnoreCase(s)) {
            return new DefaultConnectionReuseStrategy();
        }
        return new NoConnectionReuseStrategy();
    }
}

