/*
 * Decompiled with CFR 0.152.
 */
package jirasync.org.apache.http.impl.client;

import java.security.Principal;
import javax.net.ssl.SSLSession;
import jirasync.org.apache.http.annotation.Immutable;
import jirasync.org.apache.http.auth.AuthScheme;
import jirasync.org.apache.http.auth.AuthState;
import jirasync.org.apache.http.auth.Credentials;
import jirasync.org.apache.http.client.UserTokenHandler;
import jirasync.org.apache.http.conn.HttpRoutedConnection;
import jirasync.org.apache.http.protocol.HttpContext;

@Immutable
public class DefaultUserTokenHandler
implements UserTokenHandler {
    public Object getUserToken(HttpContext context) {
        SSLSession sslsession;
        HttpRoutedConnection conn;
        Principal userPrincipal = null;
        AuthState targetAuthState = (AuthState)context.getAttribute("http.auth.target-scope");
        if (targetAuthState != null && (userPrincipal = DefaultUserTokenHandler.getAuthPrincipal(targetAuthState)) == null) {
            AuthState proxyAuthState = (AuthState)context.getAttribute("http.auth.proxy-scope");
            userPrincipal = DefaultUserTokenHandler.getAuthPrincipal(proxyAuthState);
        }
        if (userPrincipal == null && (conn = (HttpRoutedConnection)context.getAttribute("http.connection")).isOpen() && (sslsession = conn.getSSLSession()) != null) {
            userPrincipal = sslsession.getLocalPrincipal();
        }
        return userPrincipal;
    }

    private static Principal getAuthPrincipal(AuthState authState) {
        Credentials creds;
        AuthScheme scheme = authState.getAuthScheme();
        if (scheme != null && scheme.isComplete() && scheme.isConnectionBased() && (creds = authState.getCredentials()) != null) {
            return creds.getUserPrincipal();
        }
        return null;
    }
}

