/*
 * Decompiled with CFR 0.152.
 */
package jirasync.org.apache.http.impl.client;

import jirasync.org.apache.http.HeaderElement;
import jirasync.org.apache.http.HttpResponse;
import jirasync.org.apache.http.annotation.Immutable;
import jirasync.org.apache.http.conn.ConnectionKeepAliveStrategy;
import jirasync.org.apache.http.message.BasicHeaderElementIterator;
import jirasync.org.apache.http.protocol.HttpContext;

@Immutable
public class DefaultConnectionKeepAliveStrategy
implements ConnectionKeepAliveStrategy {
    public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
        if (response == null) {
            throw new IllegalArgumentException("HTTP response may not be null");
        }
        BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
        while (it.hasNext()) {
            HeaderElement he = it.nextElement();
            String param = he.getName();
            String value = he.getValue();
            if (value == null || !param.equalsIgnoreCase("timeout")) continue;
            try {
                return Long.parseLong(value) * 1000L;
            }
            catch (NumberFormatException ignore) {
            }
        }
        return -1L;
    }
}

