/*
 * Decompiled with CFR 0.152.
 */
package jirasync.org.apache.http.client.protocol;

import java.io.IOException;
import java.util.Collection;
import jirasync.org.apache.http.Header;
import jirasync.org.apache.http.HttpException;
import jirasync.org.apache.http.HttpRequest;
import jirasync.org.apache.http.HttpRequestInterceptor;
import jirasync.org.apache.http.annotation.Immutable;
import jirasync.org.apache.http.protocol.HttpContext;

@Immutable
public class RequestDefaultHeaders
implements HttpRequestInterceptor {
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        Collection defHeaders = (Collection)request.getParams().getParameter("http.default-headers");
        if (defHeaders != null) {
            for (Header defHeader : defHeaders) {
                request.addHeader(defHeader);
            }
        }
    }
}

