/*
 * Decompiled with CFR 0.152.
 */
package jirasync.org.apache.http.client.protocol;

import java.io.IOException;
import jirasync.org.apache.commons.logging.Log;
import jirasync.org.apache.commons.logging.LogFactory;
import jirasync.org.apache.http.HttpException;
import jirasync.org.apache.http.HttpRequest;
import jirasync.org.apache.http.HttpRequestInterceptor;
import jirasync.org.apache.http.annotation.Immutable;
import jirasync.org.apache.http.conn.HttpRoutedConnection;
import jirasync.org.apache.http.conn.routing.HttpRoute;
import jirasync.org.apache.http.protocol.HttpContext;

@Immutable
public class RequestClientConnControl
implements HttpRequestInterceptor {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String PROXY_CONN_DIRECTIVE = "Proxy-Connection";

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            request.setHeader(PROXY_CONN_DIRECTIVE, "Keep-Alive");
            return;
        }
        HttpRoutedConnection conn = (HttpRoutedConnection)context.getAttribute("http.connection");
        if (conn == null) {
            this.log.debug("HTTP connection not set in the context");
            return;
        }
        HttpRoute route = conn.getRoute();
        if ((route.getHopCount() == 1 || route.isTunnelled()) && !request.containsHeader("Connection")) {
            request.addHeader("Connection", "Keep-Alive");
        }
        if (route.getHopCount() == 2 && !route.isTunnelled() && !request.containsHeader(PROXY_CONN_DIRECTIVE)) {
            request.addHeader(PROXY_CONN_DIRECTIVE, "Keep-Alive");
        }
    }
}

