/*
 * Decompiled with CFR 0.152.
 */
package jirasync.com.sun.jersey.json.impl.writer;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import jirasync.org.codehaus.jackson.Base64Variant;
import jirasync.org.codehaus.jackson.JsonGenerationException;
import jirasync.org.codehaus.jackson.JsonGenerator;
import jirasync.org.codehaus.jackson.JsonNode;
import jirasync.org.codehaus.jackson.JsonParser;
import jirasync.org.codehaus.jackson.JsonProcessingException;
import jirasync.org.codehaus.jackson.JsonStreamContext;
import jirasync.org.codehaus.jackson.JsonToken;
import jirasync.org.codehaus.jackson.ObjectCodec;

public class JacksonArrayWrapperGenerator
extends JsonGenerator {
    State state = State.START;
    int depth = 0;
    final JsonGenerator generator;
    private boolean isClosed = false;
    final int arrayDepth;

    private JacksonArrayWrapperGenerator() {
        this(null, 0);
    }

    private JacksonArrayWrapperGenerator(JsonGenerator generator) {
        this(generator, 0);
    }

    private JacksonArrayWrapperGenerator(JsonGenerator generator, int arrayDepth) {
        this.generator = generator;
        this.arrayDepth = arrayDepth;
    }

    public static JsonGenerator createArrayWrapperGenerator(JsonGenerator g) {
        return new JacksonArrayWrapperGenerator(g);
    }

    public static JsonGenerator createArrayWrapperGenerator(JsonGenerator g, int arrayDepth) {
        return new JacksonArrayWrapperGenerator(g, arrayDepth);
    }

    private void aboutToWriteANonNull() throws IOException {
        if (this.depth == this.arrayDepth) {
            if (this.state == State.START) {
                this.generator.writeStartArray();
                this.state = State.IN_THE_MIDDLE;
            } else if (this.state == State.AFTER_NULL) {
                this.generator.writeStartArray();
                this.generator.writeNull();
                this.state = State.IN_THE_MIDDLE;
            }
        }
    }

    @Override
    @Deprecated
    public void enableFeature(JsonGenerator.Feature feature) {
        this.generator.enableFeature(feature);
    }

    @Override
    public JsonGenerator enable(JsonGenerator.Feature feature) {
        return this.generator.enable(feature);
    }

    @Override
    @Deprecated
    public void disableFeature(JsonGenerator.Feature feature) {
        this.generator.disableFeature(feature);
    }

    @Override
    public JsonGenerator disable(JsonGenerator.Feature feature) {
        return this.generator.disable(feature);
    }

    @Override
    public void setFeature(JsonGenerator.Feature feature, boolean enabled) {
        this.generator.setFeature(feature, enabled);
    }

    @Override
    @Deprecated
    public boolean isFeatureEnabled(JsonGenerator.Feature feature) {
        return this.generator.isFeatureEnabled(feature);
    }

    @Override
    public boolean isEnabled(JsonGenerator.Feature f) {
        return this.generator.isEnabled(f);
    }

    @Override
    public JsonGenerator useDefaultPrettyPrinter() {
        return this.generator.useDefaultPrettyPrinter();
    }

    @Override
    public JsonGenerator setCodec(ObjectCodec codec) {
        return this.generator.setCodec(codec);
    }

    @Override
    public ObjectCodec getCodec() {
        return this.generator.getCodec();
    }

    @Override
    public void writeRawValue(String rawString) throws IOException, JsonGenerationException {
        this.aboutToWriteANonNull();
        this.generator.writeRawValue(rawString);
    }

    @Override
    public void writeRawValue(String rawString, int startIndex, int length) throws IOException, JsonGenerationException {
        this.aboutToWriteANonNull();
        this.generator.writeRawValue(rawString, startIndex, length);
    }

    @Override
    public void writeRawValue(char[] rawChars, int startIndex, int length) throws IOException, JsonGenerationException {
        this.aboutToWriteANonNull();
        this.generator.writeRaw(rawChars, startIndex, length);
    }

    @Override
    public void writeNumber(BigInteger number) throws IOException, JsonGenerationException {
        this.aboutToWriteANonNull();
        this.generator.writeNumber(number);
    }

    @Override
    public void writeObject(Object o) throws IOException, JsonProcessingException {
        this.aboutToWriteANonNull();
        this.generator.writeObject(o);
    }

    @Override
    public void writeTree(JsonNode node) throws IOException, JsonProcessingException {
        this.aboutToWriteANonNull();
        this.generator.writeTree(node);
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public JsonStreamContext getOutputContext() {
        return this.generator.getOutputContext();
    }

    @Override
    public void writeStartArray() throws IOException, JsonGenerationException {
        this.aboutToWriteANonNull();
        this.generator.writeStartArray();
    }

    @Override
    public void writeEndArray() throws IOException, JsonGenerationException {
        this.generator.writeEndArray();
    }

    @Override
    public void writeStartObject() throws IOException, JsonGenerationException {
        if (this.arrayDepth > 0 && this.depth == this.arrayDepth) {
            this.generator.writeStartArray();
            this.generator.writeStartObject();
        } else {
            this.aboutToWriteANonNull();
            this.generator.writeStartObject();
        }
        ++this.depth;
    }

    @Override
    public void writeEndObject() throws IOException, JsonGenerationException {
        if (this.arrayDepth > 0 && this.depth == this.arrayDepth) {
            this.generator.writeEndObject();
            this.generator.writeEndArray();
        } else {
            this.generator.writeEndObject();
        }
        --this.depth;
    }

    @Override
    public void writeFieldName(String name) throws IOException, JsonGenerationException {
        this.generator.writeFieldName(name);
    }

    @Override
    public void writeString(String s) throws IOException, JsonGenerationException {
        this.aboutToWriteANonNull();
        this.generator.writeString(s);
    }

    @Override
    public void writeString(char[] text, int start, int length) throws IOException, JsonGenerationException {
        this.aboutToWriteANonNull();
        this.generator.writeString(text, start, length);
    }

    @Override
    public void writeRaw(String raw) throws IOException, JsonGenerationException {
        this.aboutToWriteANonNull();
        this.generator.writeRaw(raw);
    }

    @Override
    public void writeRaw(String raw, int start, int length) throws IOException, JsonGenerationException {
        this.aboutToWriteANonNull();
        this.generator.writeRaw(raw, start, length);
    }

    @Override
    public void writeRaw(char[] raw, int start, int count) throws IOException, JsonGenerationException {
        this.aboutToWriteANonNull();
        this.generator.writeRaw(raw, start, count);
    }

    @Override
    public void writeRaw(char c) throws IOException, JsonGenerationException {
        this.aboutToWriteANonNull();
        this.generator.writeRaw(c);
    }

    @Override
    public void writeBinary(Base64Variant variant, byte[] bytes, int start, int count) throws IOException, JsonGenerationException {
        this.aboutToWriteANonNull();
        this.generator.writeBinary(variant, bytes, start, count);
    }

    @Override
    public void writeNumber(int i) throws IOException, JsonGenerationException {
        this.aboutToWriteANonNull();
        this.generator.writeNumber(i);
    }

    @Override
    public void writeNumber(long l) throws IOException, JsonGenerationException {
        this.aboutToWriteANonNull();
        this.generator.writeNumber(l);
    }

    @Override
    public void writeNumber(double d) throws IOException, JsonGenerationException {
        this.aboutToWriteANonNull();
        this.generator.writeNumber(d);
    }

    @Override
    public void writeNumber(float f) throws IOException, JsonGenerationException {
        this.aboutToWriteANonNull();
        this.generator.writeNumber(f);
    }

    @Override
    public void writeNumber(BigDecimal bd) throws IOException, JsonGenerationException {
        this.aboutToWriteANonNull();
        this.generator.writeNumber(bd);
    }

    @Override
    public void writeNumber(String number) throws IOException, JsonGenerationException, UnsupportedOperationException {
        this.aboutToWriteANonNull();
        this.generator.writeNumber(number);
    }

    @Override
    public void writeBoolean(boolean b) throws IOException, JsonGenerationException {
        this.aboutToWriteANonNull();
        this.generator.writeBoolean(b);
    }

    @Override
    public void writeNull() throws IOException, JsonGenerationException {
        switch (this.state) {
            case START: {
                this.state = State.AFTER_NULL;
                break;
            }
            case AFTER_NULL: {
                this.generator.writeStartArray();
                this.generator.writeNull();
                this.state = State.IN_THE_MIDDLE;
            }
            default: {
                this.generator.writeNull();
            }
        }
    }

    @Override
    public void copyCurrentEvent(JsonParser parser) throws IOException, JsonProcessingException {
        if (JsonToken.VALUE_NULL != parser.getCurrentToken()) {
            this.aboutToWriteANonNull();
            this.generator.copyCurrentEvent(parser);
        } else {
            this.writeNull();
        }
    }

    @Override
    public void copyCurrentStructure(JsonParser parser) throws IOException, JsonProcessingException {
        this.generator.copyCurrentStructure(parser);
    }

    @Override
    public void flush() throws IOException {
        if (this.depth == this.arrayDepth) {
            switch (this.state) {
                case IN_THE_MIDDLE: {
                    this.generator.writeEndArray();
                    break;
                }
                case START: 
                case AFTER_NULL: {
                    this.generator.writeStartArray();
                    this.generator.writeEndArray();
                }
            }
        }
        this.generator.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.generator.close();
        this.isClosed = true;
    }

    private static enum State {
        START,
        AFTER_NULL,
        IN_THE_MIDDLE;

    }
}

