/*
 * Decompiled with CFR 0.152.
 */
package jirasync.com.sun.jersey.core.provider.jaxb;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import jirasync.com.sun.jersey.core.impl.provider.entity.Inflector;
import jirasync.com.sun.jersey.core.provider.jaxb.AbstractJAXBProvider;
import jirasync.javax.ws.rs.WebApplicationException;
import jirasync.javax.ws.rs.core.MediaType;
import jirasync.javax.ws.rs.core.MultivaluedMap;
import jirasync.javax.ws.rs.core.Response;
import jirasync.javax.ws.rs.ext.Providers;

public abstract class AbstractListElementProvider
extends AbstractJAXBProvider<Object> {
    private final Inflector inflector = Inflector.getInstance();

    public AbstractListElementProvider(Providers ps) {
        super(ps);
    }

    public AbstractListElementProvider(Providers ps, MediaType mt) {
        super(ps, mt);
    }

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (type == List.class || type == Collection.class) {
            return this.verifyGenericType(genericType) && this.isSupported(mediaType);
        }
        if (type.isArray()) {
            return this.verifyArrayType(type) && this.isSupported(mediaType);
        }
        return false;
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (List.class.isAssignableFrom(type)) {
            return this.verifyGenericType(genericType) && this.isSupported(mediaType);
        }
        if (type.isArray()) {
            return this.verifyArrayType(type) && this.isSupported(mediaType);
        }
        return false;
    }

    private boolean verifyArrayType(Class type) {
        return (type = type.getComponentType()).isAnnotationPresent(XmlRootElement.class) || type.isAnnotationPresent(XmlType.class);
    }

    private boolean verifyGenericType(Type genericType) {
        if (!(genericType instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType pt = (ParameterizedType)genericType;
        if (pt.getActualTypeArguments().length > 1) {
            return false;
        }
        if (!(pt.getActualTypeArguments()[0] instanceof Class)) {
            return false;
        }
        Class listClass = (Class)pt.getActualTypeArguments()[0];
        return listClass.isAnnotationPresent(XmlRootElement.class) || listClass.isAnnotationPresent(XmlType.class);
    }

    @Override
    public final void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        try {
            List<Object> c = type.isArray() ? Arrays.asList((Object[])t) : (List<Object>)t;
            Class elementType = type.isArray() ? type.getComponentType() : this.getElementClass(type, genericType);
            Charset charset = AbstractListElementProvider.getCharset(mediaType);
            String charsetName = charset.name();
            Marshaller m = this.getMarshaller(elementType, mediaType);
            m.setProperty("jaxb.fragment", (Object)true);
            if (charset != UTF8) {
                m.setProperty("jaxb.encoding", (Object)charsetName);
            }
            this.writeList(elementType, c, mediaType, charset, m, entityStream);
        }
        catch (JAXBException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    public abstract void writeList(Class<?> var1, Collection<?> var2, MediaType var3, Charset var4, Marshaller var5, OutputStream var6) throws JAXBException, IOException;

    @Override
    public final Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        try {
            Class elementType = type.isArray() ? type.getComponentType() : this.getElementClass(type, genericType);
            Unmarshaller u = this.getUnmarshaller(elementType, mediaType);
            XMLStreamReader r = this.getXMLStreamReader(elementType, mediaType, u, entityStream);
            ArrayList<Object> l = new ArrayList<Object>();
            int event = r.next();
            while (event != 1) {
                event = r.next();
            }
            event = r.next();
            while (event != 1 && event != 8) {
                event = r.next();
            }
            while (event != 8) {
                if (elementType.isAnnotationPresent(XmlRootElement.class)) {
                    l.add(u.unmarshal(r));
                } else {
                    l.add(u.unmarshal(r, elementType).getValue());
                }
                event = r.getEventType();
                while (event != 1 && event != 8) {
                    event = r.next();
                }
            }
            return type.isArray() ? this.createArray(l, elementType) : l;
        }
        catch (UnmarshalException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.BAD_REQUEST);
        }
        catch (XMLStreamException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.BAD_REQUEST);
        }
        catch (JAXBException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private Object createArray(List l, Class componentType) {
        Object array = Array.newInstance(componentType, l.size());
        for (int i = 0; i < l.size(); ++i) {
            Array.set(array, i, l.get(i));
        }
        return array;
    }

    protected abstract XMLStreamReader getXMLStreamReader(Class<?> var1, MediaType var2, Unmarshaller var3, InputStream var4) throws XMLStreamException;

    protected Class getElementClass(Class<?> type, Type genericType) {
        ParameterizedType pt = (ParameterizedType)genericType;
        return (Class)pt.getActualTypeArguments()[0];
    }

    private final String convertToXmlName(String name) {
        return name.replace("$", "_");
    }

    protected final String getRootElementName(Class<?> elementType) {
        if (this.isXmlRootElementProcessing()) {
            return this.convertToXmlName(this.inflector.pluralize(this.inflector.demodulize(this.getElementName(elementType))));
        }
        return this.convertToXmlName(this.inflector.decapitalize(this.inflector.pluralize(this.inflector.demodulize(elementType.getName()))));
    }

    protected final String getElementName(Class<?> elementType) {
        String name = elementType.getName();
        XmlRootElement xre = elementType.getAnnotation(XmlRootElement.class);
        if (xre != null && !xre.name().equals("##default")) {
            name = xre.name();
        }
        return name;
    }
}

