/*
 * Decompiled with CFR 0.152.
 */
package jirasync.com.sun.jersey.core.osgi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class OsgiLocator {
    private static Map<String, List<Callable<List<Class>>>> factories = new HashMap<String, List<Callable<List<Class>>>>();
    private static ReadWriteLock lock = new ReentrantReadWriteLock();

    private OsgiLocator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister(String id, Callable<List<Class>> factory) {
        lock.writeLock().lock();
        try {
            List<Callable<List<Class>>> l = factories.get(id);
            if (l != null) {
                l.remove(factory);
            }
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(String id, Callable<List<Class>> factory) {
        lock.writeLock().lock();
        try {
            List<Callable<List<Class>>> l = factories.get(id);
            if (l == null) {
                l = new ArrayList<Callable<List<Class>>>();
                factories.put(id, l);
            }
            l.add(factory);
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Class locate(String factoryId) {
        lock.readLock().lock();
        try {
            List<Class> classes;
            List<Callable<List<Class>>> l = factories.get(factoryId);
            if (l == null || l.isEmpty()) {
                Class clazz = null;
                return clazz;
            }
            Callable<List<Class>> c = l.get(l.size() - 1);
            try {
                classes = c.call();
            }
            catch (Exception e) {
                Class clazz = null;
                lock.readLock().unlock();
                return clazz;
            }
            Class clazz = classes.get(0);
            return clazz;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    public static synchronized List<Class> locateAll(String factoryId) {
        ArrayList<Class> classes = new ArrayList<Class>();
        List<Callable<List<Class>>> l = factories.get(factoryId);
        if (l == null) {
            return classes;
        }
        for (Callable<List<Class>> c : l) {
            try {
                classes.addAll((Collection<Class>)c.call());
            }
            catch (Exception e) {}
        }
        return classes;
    }
}

