/*
 * Decompiled with CFR 0.152.
 */
package jirasync.com.sun.jersey.api.client;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class GenericType<T> {
    private final Type t;
    private final Class c;

    protected GenericType() {
        Type superclass = this.getClass().getGenericSuperclass();
        if (!(superclass instanceof ParameterizedType)) {
            throw new RuntimeException("Missing type parameter.");
        }
        ParameterizedType parameterized = (ParameterizedType)superclass;
        this.t = parameterized.getActualTypeArguments()[0];
        this.c = GenericType.getClass(this.t);
    }

    public GenericType(Type genericType) {
        if (genericType == null) {
            throw new IllegalArgumentException("Type must not be null");
        }
        this.t = genericType;
        this.c = GenericType.getClass(this.t);
    }

    private static Class getClass(Type type) {
        ParameterizedType parameterizedType;
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType && (parameterizedType = (ParameterizedType)type).getRawType() instanceof Class) {
            return (Class)parameterizedType.getRawType();
        }
        throw new IllegalArgumentException("Type parameter not a class or parameterized type whose raw type is a class");
    }

    public final Type getType() {
        return this.t;
    }

    public final Class<T> getRawClass() {
        return this.c;
    }
}

