/*
 * Decompiled with CFR 0.152.
 */
package jirasync.com.atlassian.util.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import jirasync.com.atlassian.util.concurrent.Awaitable;
import jirasync.com.atlassian.util.concurrent.RuntimeTimeoutException;
import jirasync.com.atlassian.util.concurrent.Supplier;
import jirasync.com.atlassian.util.concurrent.TimedOutException;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public final class Timeout {
    private final long created;
    private final long timeoutPeriod;
    private final TimeSupplier supplier;

    public static Timeout getNanosTimeout(long time, TimeUnit unit) {
        return new Timeout(time, unit, TimeSuppliers.NANOS);
    }

    public static Timeout getMillisTimeout(long time, TimeUnit unit) {
        return new Timeout(time, unit, TimeSuppliers.MILLIS);
    }

    public static Supplier<Timeout> timeoutFactory(final long time, final TimeUnit unit, final TimeSupplier supplier) {
        return new Supplier<Timeout>(){

            @Override
            public Timeout get() {
                return new Timeout(time, unit, supplier);
            }
        };
    }

    Timeout(long time, TimeUnit unit, TimeSupplier supplier) {
        this.created = supplier.currentTime();
        this.supplier = supplier;
        this.timeoutPeriod = this.supplier.precision().convert(time, unit);
    }

    public long getTime() {
        return this.created + this.timeoutPeriod - this.supplier.currentTime();
    }

    public TimeUnit getUnit() {
        return this.supplier.precision();
    }

    public boolean isExpired() {
        return this.getTime() <= 0L;
    }

    public long getTimeoutPeriod() {
        return this.timeoutPeriod;
    }

    void await(Awaitable waitable) throws TimeoutException, InterruptedException {
        if (!waitable.await(this.getTime(), this.getUnit())) {
            this.throwTimeoutException();
        }
    }

    public void throwTimeoutException() throws TimedOutException {
        throw new TimedOutException(this.timeoutPeriod, this.getUnit());
    }

    public RuntimeTimeoutException getTimeoutException() {
        return new RuntimeTimeoutException(this.timeoutPeriod, this.getUnit());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum TimeSuppliers implements TimeSupplier
    {
        NANOS{

            public long currentTime() {
                return System.nanoTime();
            }

            public TimeUnit precision() {
                return TimeUnit.NANOSECONDS;
            }
        }
        ,
        MILLIS{

            public long currentTime() {
                return System.currentTimeMillis();
            }

            public TimeUnit precision() {
                return TimeUnit.MILLISECONDS;
            }
        };

    }

    public static interface TimeSupplier {
        public long currentTime();

        public TimeUnit precision();
    }
}

