/*
 * Decompiled with CFR 0.152.
 */
package jirasync.com.atlassian.jira.rest.client.internal.json;

import java.util.Collections;
import jirasync.com.atlassian.jira.rest.client.api.domain.Issue;
import jirasync.com.atlassian.jira.rest.client.api.domain.SearchResult;
import jirasync.com.atlassian.jira.rest.client.internal.json.GenericJsonArrayParser;
import jirasync.com.atlassian.jira.rest.client.internal.json.IssueJsonParser;
import jirasync.com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import jirasync.org.codehaus.jettison.json.JSONArray;
import jirasync.org.codehaus.jettison.json.JSONException;
import jirasync.org.codehaus.jettison.json.JSONObject;

public class SearchResultJsonParser
implements JsonObjectParser<SearchResult> {
    @Override
    public SearchResult parse(JSONObject json) throws JSONException {
        Iterable<Issue> issues;
        int startAt = json.getInt("startAt");
        int maxResults = json.getInt("maxResults");
        int total = json.getInt("total");
        JSONArray issuesJsonArray = json.getJSONArray("issues");
        if (issuesJsonArray.length() > 0) {
            IssueJsonParser issueParser = new IssueJsonParser(json.getJSONObject("names"), json.getJSONObject("schema"));
            GenericJsonArrayParser<Issue> issuesParser = GenericJsonArrayParser.create(issueParser);
            issues = issuesParser.parse(issuesJsonArray);
        } else {
            issues = Collections.emptyList();
        }
        return new SearchResult(startAt, maxResults, total, issues);
    }
}

