/*
 * Decompiled with CFR 0.152.
 */
package jirasync.com.atlassian.jira.rest.client.internal.json;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import jirasync.com.atlassian.jira.rest.client.api.domain.CimFieldInfo;
import jirasync.com.atlassian.jira.rest.client.api.domain.FieldSchema;
import jirasync.com.atlassian.jira.rest.client.api.domain.StandardOperation;
import jirasync.com.atlassian.jira.rest.client.internal.json.BasicComponentJsonParser;
import jirasync.com.atlassian.jira.rest.client.internal.json.BasicPriorityJsonParser;
import jirasync.com.atlassian.jira.rest.client.internal.json.BasicProjectJsonParser;
import jirasync.com.atlassian.jira.rest.client.internal.json.CustomFieldOptionJsonParser;
import jirasync.com.atlassian.jira.rest.client.internal.json.FieldSchemaJsonParser;
import jirasync.com.atlassian.jira.rest.client.internal.json.GenericJsonArrayParser;
import jirasync.com.atlassian.jira.rest.client.internal.json.IssueTypeJsonParser;
import jirasync.com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import jirasync.com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import jirasync.com.atlassian.jira.rest.client.internal.json.ResolutionJsonParser;
import jirasync.com.atlassian.jira.rest.client.internal.json.SecurityLevelJsonParser;
import jirasync.com.atlassian.jira.rest.client.internal.json.VersionJsonParser;
import jirasync.org.codehaus.jettison.json.JSONArray;
import jirasync.org.codehaus.jettison.json.JSONException;
import jirasync.org.codehaus.jettison.json.JSONObject;

public class CimFieldsInfoMapJsonParser
implements JsonObjectParser<Map<String, CimFieldInfo>> {
    private final FieldSchemaJsonParser fieldSchemaJsonParser = new FieldSchemaJsonParser();
    protected final Map<String, JsonObjectParser> registeredAllowedValueParsers = new HashMap<String, JsonObjectParser>(){
        {
            this.put("project", new BasicProjectJsonParser());
            this.put("version", new VersionJsonParser());
            this.put("issuetype", new IssueTypeJsonParser());
            this.put("priority", new BasicPriorityJsonParser());
            this.put("customFieldOption", new CustomFieldOptionJsonParser());
            this.put("component", new BasicComponentJsonParser());
            this.put("resolution", new ResolutionJsonParser());
            this.put("securitylevel", new SecurityLevelJsonParser());
        }
    };

    @Override
    public Map<String, CimFieldInfo> parse(JSONObject json) throws JSONException {
        HashMap res = Maps.newHashMapWithExpectedSize((int)json.length());
        Iterator keysIterator = json.keys();
        while (keysIterator.hasNext()) {
            String id = (String)keysIterator.next();
            res.put(id, this.parseIssueFieldInfo(json.getJSONObject(id), id));
        }
        return res;
    }

    private CimFieldInfo parseIssueFieldInfo(JSONObject json, String id) throws JSONException {
        boolean required = json.getBoolean("required");
        String name = JsonParseUtil.getOptionalString(json, "name");
        FieldSchema schema = this.fieldSchemaJsonParser.parse(json.getJSONObject("schema"));
        Set<StandardOperation> operations = this.parseOperations(json.getJSONArray("operations"));
        Iterable<Object> allowedValues = this.parseAllowedValues(json.optJSONArray("allowedValues"), schema);
        URI autoCompleteUri = JsonParseUtil.parseOptionalURI(json, "autoCompleteUrl");
        return new CimFieldInfo(id, required, name, schema, operations, allowedValues, autoCompleteUri);
    }

    private Iterable<Object> parseAllowedValues(@Nullable JSONArray allowedValues, FieldSchema fieldSchema) throws JSONException {
        if (allowedValues == null || allowedValues.equals(JSONObject.NULL)) {
            return null;
        }
        if (allowedValues.length() == 0) {
            return Collections.emptyList();
        }
        JsonObjectParser<Object> allowedValuesJsonParser = this.getParserFor(fieldSchema);
        if (allowedValuesJsonParser != null) {
            boolean isProjectCF = "project".equals(fieldSchema.getType()) && "jirasync.com.atlassian.jira.plugin.system.customfieldtypes:project".equals(fieldSchema.getCustom());
            boolean isVersionCF = "version".equals(fieldSchema.getType()) && "jirasync.com.atlassian.jira.plugin.system.customfieldtypes:version".equals(fieldSchema.getCustom());
            boolean isMultiVersionCF = "array".equals(fieldSchema.getType()) && "version".equals(fieldSchema.getItems()) && "jirasync.com.atlassian.jira.plugin.system.customfieldtypes:multiversion".equals(fieldSchema.getCustom());
            JSONArray valuesToParse = (isProjectCF || isVersionCF || isMultiVersionCF) && allowedValues.get(0) instanceof JSONArray ? allowedValues.getJSONArray(0) : allowedValues;
            return GenericJsonArrayParser.create(allowedValuesJsonParser).parse(valuesToParse);
        }
        int itemsLength = allowedValues.length();
        ArrayList res = Lists.newArrayListWithExpectedSize((int)itemsLength);
        for (int i = 0; i < itemsLength; ++i) {
            res.add(allowedValues.get(i));
        }
        return res;
    }

    private Set<StandardOperation> parseOperations(JSONArray operations) throws JSONException {
        int operationsCount = operations.length();
        HashSet res = Sets.newHashSetWithExpectedSize((int)operationsCount);
        for (int i = 0; i < operationsCount; ++i) {
            String opName = operations.getString(i);
            StandardOperation op = StandardOperation.valueOf(opName.toUpperCase());
            res.add(op);
        }
        return res;
    }

    @Nullable
    private JsonObjectParser<Object> getParserFor(FieldSchema fieldSchema) throws JSONException {
        JsonObjectParser jsonParser;
        ImmutableSet customFieldsTypesWithFieldOption = ImmutableSet.of((Object)"jirasync.com.atlassian.jira.plugin.system.customfieldtypes:multicheckboxes", (Object)"jirasync.com.atlassian.jira.plugin.system.customfieldtypes:radiobuttons", (Object)"jirasync.com.atlassian.jira.plugin.system.customfieldtypes:select", (Object)"jirasync.com.atlassian.jira.plugin.system.customfieldtypes:cascadingselect", (Object)"jirasync.com.atlassian.jira.plugin.system.customfieldtypes:multiselect");
        String type = "array".equals(fieldSchema.getType()) ? fieldSchema.getItems() : fieldSchema.getType();
        String custom = fieldSchema.getCustom();
        if (custom != null && customFieldsTypesWithFieldOption.contains(custom)) {
            type = "customFieldOption";
        }
        if ((jsonParser = this.registeredAllowedValueParsers.get(type)) == null) {
            return null;
        }
        return jsonParser;
    }
}

