/*
 * Decompiled with CFR 0.152.
 */
package jirasync.com.atlassian.jira.rest.client.internal.async;

import java.net.URI;
import jirasync.com.atlassian.httpclient.api.HttpClient;
import jirasync.com.atlassian.jira.rest.client.api.UserRestClient;
import jirasync.com.atlassian.jira.rest.client.api.domain.User;
import jirasync.com.atlassian.jira.rest.client.internal.async.AbstractAsynchronousRestClient;
import jirasync.com.atlassian.jira.rest.client.internal.json.UserJsonParser;
import jirasync.com.atlassian.util.concurrent.Promise;
import jirasync.javax.ws.rs.core.UriBuilder;

public class AsynchronousUserRestClient
extends AbstractAsynchronousRestClient
implements UserRestClient {
    private static final String USER_URI_PREFIX = "user";
    private final UserJsonParser userJsonParser = new UserJsonParser();
    private final URI baseUri;

    public AsynchronousUserRestClient(URI baseUri, HttpClient client) {
        super(client);
        this.baseUri = baseUri;
    }

    @Override
    public Promise<User> getUser(String username) {
        URI userUri = UriBuilder.fromUri(this.baseUri).path(USER_URI_PREFIX).queryParam("username", username).queryParam("expand", "groups").build(new Object[0]);
        return this.getUser(userUri);
    }

    @Override
    public Promise<User> getUser(URI userUri) {
        return this.getAndParse(userUri, this.userJsonParser);
    }
}

