/*
 * Decompiled with CFR 0.152.
 */
package jirasync.com.atlassian.jira.rest.client.internal.async;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Collection;
import jirasync.com.atlassian.httpclient.api.HttpClient;
import jirasync.com.atlassian.jira.rest.client.api.ProjectRolesRestClient;
import jirasync.com.atlassian.jira.rest.client.api.domain.BasicProjectRole;
import jirasync.com.atlassian.jira.rest.client.api.domain.ProjectRole;
import jirasync.com.atlassian.jira.rest.client.internal.async.AbstractAsynchronousRestClient;
import jirasync.com.atlassian.jira.rest.client.internal.json.BasicProjectRoleJsonParser;
import jirasync.com.atlassian.jira.rest.client.internal.json.ProjectRoleJsonParser;
import jirasync.com.atlassian.util.concurrent.Promise;
import jirasync.com.atlassian.util.concurrent.Promises;
import jirasync.javax.ws.rs.core.UriBuilder;

public class AsynchronousProjectRolesRestClient
extends AbstractAsynchronousRestClient
implements ProjectRolesRestClient {
    private final ProjectRoleJsonParser projectRoleJsonParser;
    private final BasicProjectRoleJsonParser basicRoleJsonParser;

    public AsynchronousProjectRolesRestClient(URI serverUri, HttpClient client) {
        super(client);
        this.projectRoleJsonParser = new ProjectRoleJsonParser(serverUri);
        this.basicRoleJsonParser = new BasicProjectRoleJsonParser();
    }

    @Override
    public Promise<ProjectRole> getRole(URI uri) {
        return this.getAndParse(uri, this.projectRoleJsonParser);
    }

    @Override
    public Promise<ProjectRole> getRole(URI projectUri, Long roleId) {
        URI roleUri = UriBuilder.fromUri(projectUri).path("role").path(String.valueOf(roleId)).build(new Object[0]);
        return this.getAndParse(roleUri, this.projectRoleJsonParser);
    }

    @Override
    public Promise<Iterable<ProjectRole>> getRoles(URI projectUri) {
        URI rolesUris = UriBuilder.fromUri(projectUri).path("role").build(new Object[0]);
        Promise<Collection<BasicProjectRole>> basicProjectRoles = this.getAndParse(rolesUris, this.basicRoleJsonParser);
        return Promises.promise(Iterables.transform((Iterable)basicProjectRoles.claim(), (Function)new Function<BasicProjectRole, ProjectRole>(){

            public ProjectRole apply(BasicProjectRole basicProjectRole) {
                return AsynchronousProjectRolesRestClient.this.getRole(basicProjectRole.getSelf()).claim();
            }
        }));
    }
}

