/*
 * Decompiled with CFR 0.152.
 */
package jirasync.com.atlassian.jira.rest.client.internal.async;

import java.net.URI;
import jirasync.com.atlassian.httpclient.api.HttpClient;
import jirasync.com.atlassian.jira.rest.client.api.ProjectRestClient;
import jirasync.com.atlassian.jira.rest.client.api.domain.BasicProject;
import jirasync.com.atlassian.jira.rest.client.api.domain.Project;
import jirasync.com.atlassian.jira.rest.client.internal.async.AbstractAsynchronousRestClient;
import jirasync.com.atlassian.jira.rest.client.internal.json.BasicProjectsJsonParser;
import jirasync.com.atlassian.jira.rest.client.internal.json.ProjectJsonParser;
import jirasync.com.atlassian.util.concurrent.Promise;
import jirasync.javax.ws.rs.core.UriBuilder;

public class AsynchronousProjectRestClient
extends AbstractAsynchronousRestClient
implements ProjectRestClient {
    private static final String PROJECT_URI_PREFIX = "project";
    private final ProjectJsonParser projectJsonParser = new ProjectJsonParser();
    private final BasicProjectsJsonParser basicProjectsJsonParser = new BasicProjectsJsonParser();
    private final URI baseUri;

    public AsynchronousProjectRestClient(URI baseUri, HttpClient client) {
        super(client);
        this.baseUri = baseUri;
    }

    @Override
    public Promise<Project> getProject(String key) {
        URI uri = UriBuilder.fromUri(this.baseUri).path(PROJECT_URI_PREFIX).path(key).build(new Object[0]);
        return this.getAndParse(uri, this.projectJsonParser);
    }

    @Override
    public Promise<Project> getProject(URI projectUri) {
        return this.getAndParse(projectUri, this.projectJsonParser);
    }

    @Override
    public Promise<Iterable<BasicProject>> getAllProjects() {
        URI uri = UriBuilder.fromUri(this.baseUri).path(PROJECT_URI_PREFIX).build(new Object[0]);
        return this.getAndParse(uri, this.basicProjectsJsonParser);
    }
}

