/*
 * Decompiled with CFR 0.152.
 */
package jirasync.com.atlassian.httpclient.api;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Map;
import jirasync.com.atlassian.httpclient.api.Response;

final class ResponsePromiseMapFunction<O>
implements Function<Response, O> {
    private final Map<StatusRange, Function<Response, ? extends O>> functions = Maps.newHashMap();
    private Function<Response, ? extends O> othersFunction;

    ResponsePromiseMapFunction() {
    }

    public void addStatusRangeFunction(StatusRange range, Function<Response, ? extends O> func) {
        this.functions.put(range, func);
    }

    public void setOthersFunction(Function<Response, ? extends O> othersFunction) {
        this.othersFunction = othersFunction;
    }

    public O apply(Response response) {
        final int statusCode = response.getStatusCode();
        Map matchingFunctions = Maps.filterKeys(this.functions, (Predicate)new Predicate<StatusRange>(){

            public boolean apply(StatusRange input) {
                return input.isIn(statusCode);
            }
        });
        if (matchingFunctions.isEmpty()) {
            if (this.othersFunction != null) {
                return (O)this.othersFunction.apply((Object)response);
            }
            throw new IllegalStateException("Could not match any function to status " + statusCode);
        }
        if (matchingFunctions.size() > 1) {
            throw new IllegalStateException("Found multiple functions for status " + statusCode);
        }
        return (O)((Function)Iterables.getLast(matchingFunctions.values())).apply((Object)response);
    }

    static interface StatusRange {
        public boolean isIn(int var1);
    }
}

