/*
 * Decompiled with CFR 0.152.
 */
package jirasync.com.atlassian.httpclient.api;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import jirasync.com.atlassian.httpclient.api.HttpStatus;
import jirasync.com.atlassian.httpclient.api.Response;
import jirasync.com.atlassian.httpclient.api.ResponsePromise;
import jirasync.com.atlassian.httpclient.api.ResponsePromiseMapFunction;
import jirasync.com.atlassian.httpclient.api.ResponseTransformation;
import jirasync.com.atlassian.httpclient.api.ResponseTransformationException;
import jirasync.com.atlassian.httpclient.api.UnexpectedResponseException;
import jirasync.com.atlassian.util.concurrent.Promise;

@NotThreadSafe
final class DefaultResponseTransformation<O>
implements ResponseTransformation<O> {
    private final ResponsePromiseMapFunction<O> mapFunctions = new ResponsePromiseMapFunction();
    private volatile Function<Throwable, ? extends O> failFunction = this.defaultThrowableHandler();
    private final ResponsePromise responsePromise;

    DefaultResponseTransformation(ResponsePromise baseResponsePromise) {
        this.responsePromise = (ResponsePromise)Preconditions.checkNotNull((Object)baseResponsePromise);
    }

    @Override
    public ResponseTransformation<O> on(HttpStatus status, Function<Response, ? extends O> f) {
        return this.addSingle(status, f);
    }

    @Override
    public ResponseTransformation<O> on(int statusCode, Function<Response, ? extends O> f) {
        return this.addSingle(statusCode, f);
    }

    @Override
    public ResponseTransformation<O> informational(Function<Response, ? extends O> f) {
        return this.addRange(HttpStatus.CONTINUE, f);
    }

    @Override
    public ResponseTransformation<O> successful(Function<Response, ? extends O> f) {
        return this.addRange(HttpStatus.OK, f);
    }

    @Override
    public ResponseTransformation<O> ok(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.OK, f);
    }

    @Override
    public ResponseTransformation<O> created(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.CREATED, f);
    }

    @Override
    public ResponseTransformation<O> noContent(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.NO_CONTENT, f);
    }

    @Override
    public ResponseTransformation<O> redirection(Function<Response, ? extends O> f) {
        return this.addRange(HttpStatus.MULTIPLE_CHOICES, f);
    }

    @Override
    public ResponseTransformation<O> seeOther(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.SEE_OTHER, f);
    }

    @Override
    public ResponseTransformation<O> notModified(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.NOT_MODIFIED, f);
    }

    @Override
    public ResponseTransformation<O> clientError(Function<Response, ? extends O> f) {
        return this.addRange(HttpStatus.BAD_REQUEST, f);
    }

    @Override
    public ResponseTransformation<O> badRequest(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.BAD_REQUEST, f);
    }

    @Override
    public ResponseTransformation<O> unauthorized(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.UNAUTHORIZED, f);
    }

    @Override
    public ResponseTransformation<O> forbidden(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.FORBIDDEN, f);
    }

    @Override
    public ResponseTransformation<O> notFound(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.NOT_FOUND, f);
    }

    @Override
    public ResponseTransformation<O> conflict(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.CONFLICT, f);
    }

    @Override
    public ResponseTransformation<O> serverError(Function<Response, ? extends O> f) {
        return this.addRange(HttpStatus.INTERNAL_SERVER_ERROR, f);
    }

    @Override
    public ResponseTransformation<O> internalServerError(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.INTERNAL_SERVER_ERROR, f);
    }

    @Override
    public ResponseTransformation<O> serviceUnavailable(Function<Response, ? extends O> f) {
        return this.addSingle(HttpStatus.SERVICE_UNAVAILABLE, f);
    }

    @Override
    public ResponseTransformation<O> error(Function<Response, ? extends O> f) {
        this.mapFunctions.addStatusRangeFunction(new OrStatusRange(new HundredsStatusRange(HttpStatus.BAD_REQUEST), new HundredsStatusRange(HttpStatus.INTERNAL_SERVER_ERROR)), f);
        return this;
    }

    @Override
    public ResponseTransformation<O> notSuccessful(Function<Response, ? extends O> f) {
        this.mapFunctions.addStatusRangeFunction(new NotInStatusRange(new HundredsStatusRange(HttpStatus.OK)), f);
        return this;
    }

    @Override
    public ResponseTransformation<O> others(Function<Response, ? extends O> f) {
        this.mapFunctions.setOthersFunction(f);
        return this;
    }

    @Override
    public ResponseTransformation<O> otherwise(final Function<Throwable, O> callback) {
        this.others(new Function<Response, O>(){

            public O apply(@Nullable Response input) {
                return callback.apply((Object)new UnexpectedResponseException(input));
            }
        });
        this.fail(callback);
        return this;
    }

    @Override
    public ResponseTransformation<O> done(final Function<Response, O> f) {
        this.others(new Function<Response, O>(){

            public O apply(@Nullable Response input) {
                return f.apply((Object)input);
            }
        });
        return this;
    }

    @Override
    public ResponseTransformation<O> fail(Function<Throwable, ? extends O> f) {
        this.failFunction = f;
        return this;
    }

    private ResponseTransformation<O> addSingle(HttpStatus status, Function<Response, ? extends O> f) {
        return this.addSingle(status.code, f);
    }

    private ResponseTransformation<O> addSingle(int statusCode, Function<Response, ? extends O> f) {
        this.mapFunctions.addStatusRangeFunction(new SingleStatusRange(statusCode), f);
        return this;
    }

    private ResponseTransformation<O> addRange(HttpStatus status, Function<Response, ? extends O> f) {
        this.mapFunctions.addStatusRangeFunction(new HundredsStatusRange(status), f);
        return this;
    }

    @Override
    public O claim() {
        return this.toPromise().claim();
    }

    @Override
    public Promise<O> toPromise() {
        return this.responsePromise.fold(this.failFunction, this.mapFunctions);
    }

    private Function<Throwable, ? extends O> defaultThrowableHandler() {
        return new Function<Throwable, O>(){

            public O apply(Throwable throwable) {
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw new ResponseTransformationException(throwable);
            }
        };
    }

    static final class OrStatusRange
    implements ResponsePromiseMapFunction.StatusRange {
        private final ResponsePromiseMapFunction.StatusRange one;
        private final ResponsePromiseMapFunction.StatusRange two;

        private OrStatusRange(ResponsePromiseMapFunction.StatusRange one, ResponsePromiseMapFunction.StatusRange two) {
            this.one = (ResponsePromiseMapFunction.StatusRange)Preconditions.checkNotNull((Object)one);
            this.two = (ResponsePromiseMapFunction.StatusRange)Preconditions.checkNotNull((Object)two);
        }

        @Override
        public boolean isIn(int code) {
            return this.one.isIn(code) || this.two.isIn(code);
        }
    }

    static final class NotInStatusRange
    implements ResponsePromiseMapFunction.StatusRange {
        private final ResponsePromiseMapFunction.StatusRange range;

        private NotInStatusRange(ResponsePromiseMapFunction.StatusRange range) {
            this.range = (ResponsePromiseMapFunction.StatusRange)Preconditions.checkNotNull((Object)range);
        }

        @Override
        public boolean isIn(int code) {
            return !this.range.isIn(code);
        }
    }

    static final class HundredsStatusRange
    implements ResponsePromiseMapFunction.StatusRange {
        private final HttpStatus status;

        private HundredsStatusRange(HttpStatus status) {
            this.status = (HttpStatus)((Object)Preconditions.checkNotNull((Object)((Object)status)));
        }

        @Override
        public boolean isIn(int code) {
            int diff = code - this.status.code;
            return 0 <= diff && diff < 100;
        }
    }

    static final class SingleStatusRange
    implements ResponsePromiseMapFunction.StatusRange {
        private final int statusCode;

        SingleStatusRange(int statusCode) {
            this.statusCode = (Integer)Preconditions.checkNotNull((Object)statusCode);
        }

        @Override
        public boolean isIn(int code) {
            return this.statusCode == code;
        }
    }
}

