/*
 * Decompiled with CFR 0.152.
 */
package jirasync.com.atlassian.httpclient.apache.httpcomponents;

import com.google.common.base.Preconditions;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import jirasync.com.atlassian.event.api.EventPublisher;
import jirasync.com.atlassian.httpclient.apache.httpcomponents.DefaultHttpClient;
import jirasync.com.atlassian.httpclient.api.HttpClient;
import jirasync.com.atlassian.httpclient.api.factory.HttpClientFactory;
import jirasync.com.atlassian.httpclient.api.factory.HttpClientOptions;
import jirasync.com.atlassian.httpclient.spi.ThreadLocalContextManager;
import jirasync.com.atlassian.sal.api.ApplicationProperties;
import org.springframework.beans.factory.DisposableBean;

public final class DefaultHttpClientFactory
implements HttpClientFactory,
DisposableBean {
    private final EventPublisher eventPublisher;
    private final ApplicationProperties applicationProperties;
    private final ThreadLocalContextManager threadLocalContextManager;
    private final Set<DefaultHttpClient> httpClients = new CopyOnWriteArraySet<DefaultHttpClient>();

    public DefaultHttpClientFactory(EventPublisher eventPublisher, ApplicationProperties applicationProperties, ThreadLocalContextManager threadLocalContextManager) {
        this.eventPublisher = (EventPublisher)Preconditions.checkNotNull((Object)eventPublisher);
        this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties);
        this.threadLocalContextManager = (ThreadLocalContextManager)Preconditions.checkNotNull((Object)threadLocalContextManager);
    }

    @Override
    public HttpClient create(HttpClientOptions options) {
        return this.doCreate(options, this.threadLocalContextManager);
    }

    @Override
    public HttpClient create(HttpClientOptions options, ThreadLocalContextManager threadLocalContextManager) {
        return this.doCreate(options, threadLocalContextManager);
    }

    private HttpClient doCreate(HttpClientOptions options, ThreadLocalContextManager threadLocalContextManager) {
        Preconditions.checkNotNull((Object)options);
        DefaultHttpClient httpClient = new DefaultHttpClient(this.eventPublisher, this.applicationProperties, threadLocalContextManager, options);
        this.httpClients.add(httpClient);
        return httpClient;
    }

    public void destroy() throws Exception {
        for (DefaultHttpClient httpClient : this.httpClients) {
            httpClient.destroy();
        }
    }
}

