/*
 * Decompiled with CFR 0.152.
 */
package jirasync.com.atlassian.event.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jirasync.com.atlassian.event.api.EventPublisher;
import jirasync.com.atlassian.event.config.ListenerHandlersConfiguration;
import jirasync.com.atlassian.event.internal.ClassUtils;
import jirasync.com.atlassian.event.spi.EventDispatcher;
import jirasync.com.atlassian.event.spi.ListenerHandler;
import jirasync.com.atlassian.event.spi.ListenerInvoker;
import jirasync.org.apache.commons.lang.ObjectUtils;
import jirasync.org.apache.commons.lang.StringUtils;
import jirasync.org.apache.commons.lang.builder.EqualsBuilder;
import jirasync.org.apache.commons.lang.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EventPublisherImpl
implements EventPublisher {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final EventDispatcher eventDispatcher;
    private final List<ListenerHandler> listenerHandlers;
    private final Multimap<Class<?>, KeyedListenerInvoker> listenerInvokers;

    public EventPublisherImpl(EventDispatcher eventDispatcher, ListenerHandlersConfiguration listenerHandlersConfiguration) {
        this.eventDispatcher = (EventDispatcher)Preconditions.checkNotNull((Object)eventDispatcher);
        this.listenerHandlers = (List)Preconditions.checkNotNull(((ListenerHandlersConfiguration)Preconditions.checkNotNull((Object)listenerHandlersConfiguration)).getListenerHandlers());
        this.listenerInvokers = this.newMultimap();
    }

    @Override
    public void publish(Object event) {
        this.invokeListeners(this.findListenerInvokersForEvent(Preconditions.checkNotNull((Object)event)), event);
    }

    @Override
    public void register(Object listener) {
        this.registerListener(ObjectUtils.identityToString(Preconditions.checkNotNull((Object)listener)), listener);
    }

    @Override
    public void unregister(Object listener) {
        this.unregisterListener(ObjectUtils.identityToString(Preconditions.checkNotNull((Object)listener)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterAll() {
        Multimap<Class<?>, KeyedListenerInvoker> multimap = this.listenerInvokers;
        synchronized (multimap) {
            this.listenerInvokers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterListener(String listenerKey) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty(listenerKey), (Object)"Key for the listener must not be empty");
        Multimap<Class<?>, KeyedListenerInvoker> multimap = this.listenerInvokers;
        synchronized (multimap) {
            Iterator invokerIterator = this.listenerInvokers.entries().iterator();
            while (invokerIterator.hasNext()) {
                if (!((KeyedListenerInvoker)((Map.Entry)invokerIterator.next()).getValue()).getKey().equals(listenerKey)) continue;
                invokerIterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerListener(String listenerKey, Object listener) {
        Multimap<Class<?>, KeyedListenerInvoker> multimap = this.listenerInvokers;
        synchronized (multimap) {
            this.unregisterListener(listenerKey);
            ArrayList invokers = Lists.newArrayList();
            for (ListenerHandler listenerHandler : this.listenerHandlers) {
                invokers.addAll(listenerHandler.getInvokers(listener));
            }
            if (invokers.isEmpty()) {
                throw new IllegalArgumentException("No listener invokers were found for listener <" + listener + ">");
            }
            this.registerListenerInvokers(listenerKey, invokers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<KeyedListenerInvoker> findListenerInvokersForEvent(Object event) {
        HashSet invokersForEvent = Sets.newHashSet();
        Multimap<Class<?>, KeyedListenerInvoker> multimap = this.listenerInvokers;
        synchronized (multimap) {
            for (Class<?> eventClass : ClassUtils.findAllTypes(Preconditions.checkNotNull((Object)event).getClass())) {
                invokersForEvent.addAll(this.listenerInvokers.get(eventClass));
            }
        }
        return invokersForEvent;
    }

    private void invokeListeners(Collection<KeyedListenerInvoker> listenerInvokers, Object event) {
        for (KeyedListenerInvoker keyedInvoker : listenerInvokers) {
            try {
                this.eventDispatcher.dispatch(keyedInvoker.getInvoker(), event);
            }
            catch (Throwable t) {
                this.log.error("There was an exception thrown trying to dispatch event '" + event + "' from the invoker '" + keyedInvoker.getInvoker() + "'.", t);
            }
        }
    }

    private void registerListenerInvokers(String listenerKey, List<? extends ListenerInvoker> invokers) {
        for (ListenerInvoker listenerInvoker : invokers) {
            this.registerListenerInvoker(listenerKey, listenerInvoker);
        }
    }

    private void registerListenerInvoker(String listenerKey, ListenerInvoker invoker) {
        if (invoker.getSupportedEventTypes().isEmpty()) {
            this.listenerInvokers.put(Object.class, (Object)new KeyedListenerInvoker(listenerKey, invoker));
        }
        for (Class<?> eventClass : invoker.getSupportedEventTypes()) {
            this.listenerInvokers.put(eventClass, (Object)new KeyedListenerInvoker(listenerKey, invoker));
        }
    }

    private Multimap<Class<?>, KeyedListenerInvoker> newMultimap() {
        return Multimaps.synchronizedMultimap((Multimap)Multimaps.newMultimap((Map)Maps.newHashMap(), (Supplier)new Supplier<Collection<KeyedListenerInvoker>>(){

            public Collection<KeyedListenerInvoker> get() {
                return Sets.newHashSet();
            }
        }));
    }

    private static final class KeyedListenerInvoker {
        private final String key;
        private final ListenerInvoker invoker;

        KeyedListenerInvoker(String key, ListenerInvoker invoker) {
            this.invoker = invoker;
            this.key = key;
        }

        String getKey() {
            return this.key;
        }

        ListenerInvoker getInvoker() {
            return this.invoker;
        }

        public int hashCode() {
            return new HashCodeBuilder(5, 23).append(this.key).append(this.invoker).toHashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            KeyedListenerInvoker kli = (KeyedListenerInvoker)obj;
            return new EqualsBuilder().append(this.key, kli.key).append(this.invoker, kli.invoker).isEquals();
        }
    }
}

