/*
 * Decompiled with CFR 0.152.
 */
package jirasync.com.atlassian.event.internal;

import com.google.common.base.Preconditions;
import java.util.concurrent.Executor;
import jirasync.com.atlassian.event.internal.AnnotationAsynchronousEventResolver;
import jirasync.com.atlassian.event.internal.AsynchronousEventResolver;
import jirasync.com.atlassian.event.spi.EventDispatcher;
import jirasync.com.atlassian.event.spi.EventExecutorFactory;
import jirasync.com.atlassian.event.spi.ListenerInvoker;

public final class AsynchronousAbleEventDispatcher
implements EventDispatcher {
    private static final Executor SYNCHRONOUS_EXECUTOR = new Executor(){

        public void execute(Runnable command) {
            command.run();
        }
    };
    private final Executor asynchronousExecutor;
    private final AsynchronousEventResolver asynchronousEventResolver;

    public AsynchronousAbleEventDispatcher(EventExecutorFactory executorFactory) {
        this(executorFactory, new AnnotationAsynchronousEventResolver());
    }

    AsynchronousAbleEventDispatcher(EventExecutorFactory executorFactory, AsynchronousEventResolver asynchronousEventResolver) {
        this.asynchronousEventResolver = (AsynchronousEventResolver)Preconditions.checkNotNull((Object)asynchronousEventResolver);
        this.asynchronousExecutor = (Executor)Preconditions.checkNotNull((Object)((EventExecutorFactory)Preconditions.checkNotNull((Object)executorFactory)).getExecutor());
    }

    public void dispatch(final ListenerInvoker invoker, final Object event) {
        this.getExecutor((ListenerInvoker)Preconditions.checkNotNull((Object)invoker), Preconditions.checkNotNull((Object)event)).execute(new Runnable(){

            public void run() {
                invoker.invoke(event);
            }
        });
    }

    private Executor getExecutor(ListenerInvoker invoker, Object event) {
        return this.asynchronousEventResolver.isAsynchronousEvent(event) && invoker.supportAsynchronousEvents() ? this.asynchronousExecutor : SYNCHRONOUS_EXECUTOR;
    }
}

