/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.testautomation.resultpublisher;

import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.testautomation.AutomatedSuite;
import org.squashtest.tm.domain.users.ApiToken;
import org.squashtest.tm.service.internal.repository.ApiTokenDao;
import org.squashtest.tm.service.internal.repository.AutomatedSuiteDao;
import org.squashtest.tm.service.testautomation.model.AutomatedExecutionState;
import org.squashtest.tm.service.testautomation.resultpublisher.ExecutionService;
import org.squashtest.tm.service.testautomation.resultpublisher.ResultPublicationService;

@Service
@Transactional
public class ResultPublicationServiceImpl
implements ResultPublicationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResultPublicationServiceImpl.class);
    private static final long DELAY = TimeUnit.HOURS.toHours(1L);
    private static final TimeUnit TIME_UNIT = TimeUnit.HOURS;
    @Inject
    private AutomatedSuiteDao autoSuiteDao;
    @Inject
    private ExecutionService executionService;
    @Inject
    private ApiTokenDao apiTokenDao;

    @Override
    public void publishResult(String suiteId, long testId, AutomatedExecutionState stateChange) {
        AutomatedSuite automatedSuite = this.autoSuiteDao.findById(suiteId);
        if (stateChange.isLastUpdate()) {
            automatedSuite.setWorkflows(null);
            this.deleteAutoGeneratedToken(suiteId);
        }
        this.executionService.updateExecutionAndClearSession(testId, suiteId, stateChange);
    }

    protected void deleteAutoGeneratedToken(String automatedSuiteId) {
        if (this.autoSuiteDao.isAutomatedSuiteCreatedByTestAutomationServerUser(automatedSuiteId)) {
            return;
        }
        String tokenPartialName = "-" + automatedSuiteId + "-";
        this.scheduleTokenDeletion(tokenPartialName);
    }

    protected void scheduleTokenDeletion(String tokenPartialName) {
        if (!this.hasFoundTokenToDelete(tokenPartialName)) {
            return;
        }
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
        scheduler.schedule(() -> this.apiTokenDao.deleteAllByNameContains(tokenPartialName), DELAY, TIME_UNIT);
        scheduler.shutdown();
    }

    protected boolean hasFoundTokenToDelete(String tokenPartialName) {
        List<ApiToken> tokens = this.apiTokenDao.findAllByNameContains(tokenPartialName);
        if (tokens == null || tokens.isEmpty()) {
            LOGGER.trace("No token found matching the pattern '{}', associated with the automated suite.", new Object[]{tokenPartialName});
            return false;
        }
        if (tokens.size() > 1) {
            LOGGER.warn("Multiple tokens matching the pattern '{}' were found. All will be scheduled for deletion.", new Object[]{tokenPartialName});
        }
        return true;
    }
}

