/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.testautomation.resultpublisher;

import java.util.ArrayList;
import java.util.Date;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.testautomation.execution.dto.TestExecutionStatus;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.domain.campaign.IterationTestPlanItem;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.security.UserContextHolder;
import org.squashtest.tm.service.campaign.CustomTestSuiteModificationService;
import org.squashtest.tm.service.internal.repository.IterationTestPlanDao;
import org.squashtest.tm.service.internal.repository.UserDao;
import org.squashtest.tm.service.testautomation.model.AutomatedExecutionState;

@Service
@Transactional
public class RestITPIManagerService {
    @Inject
    private IterationTestPlanDao itpiDao;
    @Inject
    private UserDao userDao;
    @Inject
    private CustomTestSuiteModificationService customTestSuiteModificationService;

    @PreAuthorize(value="hasRole('ROLE_TA_API_CLIENT') or hasRole('ROLE_ADMIN') or hasPermission(#id, 'org.squashtest.tm.domain.campaign.IterationTestPlanItem' ,'EXECUTE')")
    public void forceExecutionStatus(long id, @NotNull AutomatedExecutionState stateChange) {
        AutomatedExecutionState automatedExecutionState = stateChange;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$2$7531eba5((Object)automatedExecutionState);
        IterationTestPlanItem item = this.getById(id);
        String login = UserContextHolder.getUsername();
        User user = this.userDao.findUserByLogin(login);
        Date date = new Date();
        TestExecutionStatus testExecutionStatus = stateChange.getTfTestExecutionStatus().tfTestExecutionStatusToTmTestExecutionStatus();
        item.setExecutionStatus(ExecutionStatus.valueOf((String)testExecutionStatus.getStatus().name()));
        this.arbitraryUpdateMetadata(item, user, date);
        ArrayList<TestSuite> testSuitesToUpdate = new ArrayList<TestSuite>();
        testSuitesToUpdate.addAll(item.getTestSuites());
        this.customTestSuiteModificationService.updateExecutionStatus(testSuitesToUpdate);
    }

    public IterationTestPlanItem getById(long id) {
        return this.itpiDao.findByIdWithTestCase(id);
    }

    private void arbitraryUpdateMetadata(IterationTestPlanItem item, User user, Date date) {
        item.setLastExecutedBy(user.getLogin());
        item.setLastExecutedOn(date);
        item.setUser(user);
    }
}

