/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.requirement;

import javax.validation.constraints.NotNull;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.requirement.RequirementStatus;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.service.annotation.CheckBlockingMilestone;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.requirement.CustomRequirementVersionManagerService;

@Transactional
public interface RequirementVersionManagerService
extends CustomRequirementVersionManagerService {
    @Transactional(readOnly=true)
    @PostAuthorize(value="hasPermission(returnObject,'READ') or hasRole('ROLE_ADMIN')")
    public RequirementVersion findById(long var1);

    @PreAuthorize(value="hasPermission(#arg0, 'org.squashtest.tm.domain.requirement.RequirementVersion','WRITE') or hasRole('ROLE_ADMIN')")
    public void changeDescription(long var1, @NotNull String var3);

    @PreAuthorize(value="hasPermission(#arg0, 'org.squashtest.tm.domain.requirement.RequirementVersion', 'WRITE') or hasRole('ROLE_ADMIN')")
    public void changeReference(long var1, @NotNull String var3);

    @CheckBlockingMilestone(entityType=RequirementVersion.class)
    @PreAuthorize(value="hasPermission(#arg0, 'org.squashtest.tm.domain.requirement.RequirementVersion', 'WRITE') or hasRole('ROLE_ADMIN')")
    public void changeStatus(@Id long var1, @NotNull RequirementStatus var3);
}

