/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.projectimporter.xrayimporter.topivot;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.parser.Parser;
import org.squashtest.tm.service.internal.dto.projectimporterxray.jooq.dto.AbstractGenericItem;
import org.squashtest.tm.service.internal.dto.projectimporterxray.jooq.dto.ItemXrayDto;
import org.squashtest.tm.service.internal.projectimporter.xrayimporter.exception.ImportXrayException;

public abstract class AbstractImporterXrayHelper {
    private static final String ERROR_WRITING_TO_JSON = "Error during the generation of the pivot format while writing to the JSON file: ";

    protected static <T> Consumer<T> consumerThrowingIOException(ConsumerThrowing<T, IOException> t) {
        return i -> {
            try {
                t.accept(i);
            }
            catch (IOException e) {
                throw new ImportXrayException(ERROR_WRITING_TO_JSON, e);
            }
        };
    }

    protected static <T> Consumer<T> consumerThrowingRecordAndId(BiConsumerThrowing<T, AtomicInteger, IOException> records) {
        AtomicInteger idGenerator = new AtomicInteger(0);
        return i -> {
            try {
                records.accept(i, idGenerator);
            }
            catch (IOException e) {
                throw new ImportXrayException(ERROR_WRITING_TO_JSON, e);
            }
        };
    }

    protected void writeJson(JsonFactory jsonFactory, ConsumerThrowing<JsonGenerator, IOException> writeToJson, String fileName, ArchiveOutputStream<ZipArchiveEntry> archive, boolean isEmptyEntity) throws IOException {
        if (!isEmptyEntity) {
            ZipArchiveEntry zipArchiveEntry = new ZipArchiveEntry(fileName);
            archive.putArchiveEntry((ArchiveEntry)zipArchiveEntry);
            try {
                Throwable throwable = null;
                Object var8_9 = null;
                try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
                    try {
                        Throwable throwable2 = null;
                        Object var11_15 = null;
                        try (JsonGenerator jsonGenerator = jsonFactory.createGenerator((OutputStream)stream);){
                            jsonGenerator.setCodec((ObjectCodec)new ObjectMapper());
                            jsonGenerator.writeStartObject();
                            writeToJson.accept(jsonGenerator);
                            jsonGenerator.writeEndObject();
                            jsonGenerator.flush();
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (IOException e) {
                        throw new ImportXrayException(ERROR_WRITING_TO_JSON, e);
                    }
                    archive.write(stream.toByteArray());
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            finally {
                archive.closeArchiveEntry();
            }
        }
    }

    protected Document normalizeToHTMLDocument(String fieldValueToNormalize) {
        Document document;
        Element body;
        String fieldValue = "";
        if (Objects.nonNull(fieldValueToNormalize)) {
            fieldValue = fieldValueToNormalize;
        }
        if ((body = (document = Jsoup.parse((String)fieldValue, (Parser)Parser.htmlParser())).body()).children().isEmpty() && StringUtils.isNotEmpty((CharSequence)fieldValue)) {
            body.appendElement("p").text(fieldValue);
        }
        return document;
    }

    protected String generateDescription(ItemXrayDto itemXrayDto, BiConsumer<Element, ItemXrayDto> bodyConsumer) {
        Document document = this.normalizeToHTMLDocument(itemXrayDto.getDescription());
        bodyConsumer.accept(document.body(), itemXrayDto);
        return document.body().children().stream().map(Node::toString).collect(Collectors.joining());
    }

    protected void addLinkPriorityStatusLabelToDescription(Element body, ItemXrayDto itemXrayDto) {
        this.appendTextIfNotNull(itemXrayDto.getLink(), link -> {
            Element element2 = body.appendElement("p").appendChild((Node)new Element("a").attr("href", link).text(link));
        });
        this.appendTextIfNotNull(itemXrayDto.getPriority(), priority -> {
            Element element2 = body.appendElement("p").text(String.format("XRay priority: %s", itemXrayDto.getPriority()));
        });
        this.appendTextIfNotNull(itemXrayDto.getStatus(), status -> {
            Element element2 = body.appendElement("p").text(String.format("XRay status: %s", itemXrayDto.getStatus()));
        });
        this.appendTextIfNotNull(itemXrayDto.getLabel(), label -> {
            Element element2 = body.appendElement("p").text(String.format("XRay Labels: %s", label));
        });
    }

    protected void appendTextIfNotNull(String text, Consumer<String> consumer) {
        if (StringUtils.isNotEmpty((CharSequence)text)) {
            consumer.accept(text);
        }
    }

    protected static Map<String, String> convertStringToMap(String mapToString) {
        mapToString = mapToString.replaceAll("(^\\{)|(}$)", "");
        return Arrays.stream(mapToString.split(",")).map(str -> StringUtils.trim((String)str).split("=")).collect(Collectors.toMap(str -> str[0], str -> str[1]));
    }

    protected <T extends AbstractGenericItem> void writeLog(PrintWriter logWriter, T item) {
        switch (item.getItemStatus()) {
            case SUCCESS: {
                logWriter.write(String.valueOf(item.getMessageOnSuccess()) + System.lineSeparator());
                break;
            }
            case WARNING: {
                item.getMessagesOnWarn().forEach(message -> logWriter.write(String.valueOf(message) + System.lineSeparator()));
                break;
            }
            case FAILURE: {
                logWriter.write(String.valueOf(item.getMessageOnError()) + System.lineSeparator());
            }
        }
    }

    @FunctionalInterface
    protected static interface BiConsumerThrowing<T, U, E extends Exception> {
        public void accept(T var1, U var2) throws E;
    }

    @FunctionalInterface
    protected static interface ConsumerThrowing<T, E extends Exception> {
        public void accept(T var1) throws E;
    }
}

