/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testautomation.model.messages;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opentestfactory.dto.v1.JobDTO;
import org.opentestfactory.messages.AbstractStep;
import org.opentestfactory.messages.Category;
import org.opentestfactory.messages.OTFMessage;
import org.squashtest.squash.automation.tm.testplan.library.application.ParamActionStep;
import org.squashtest.squash.automation.tm.testplan.library.application.TestCodeCheckoutStep;
import org.squashtest.squash.automation.tm.testplan.library.application.TestExecutionProviderStep;
import org.squashtest.squash.automation.tm.testplan.library.model.Credentials;
import org.squashtest.squash.automation.tm.testplan.library.model.Project;
import org.squashtest.squash.automation.tm.testplan.library.model.TestExecution;
import org.squashtest.squash.automation.tm.testplan.library.model.TestPlan;
import org.squashtest.tm.service.internal.testautomation.model.TestPlanContext;
import org.squashtest.tm.service.internal.testautomation.model.messages.AdditionalConfiguration;

public class Workflow
extends OTFMessage {
    public static final String NAME_METADATA_KEY = "name";
    private Map<String, JobDTO> jobs;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Map<String, Object> variables = new HashMap<String, Object>();
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Map<String, Object> resources = new HashMap<String, Object>();
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<Object> hooks = new ArrayList<Object>();
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Map<String, Object> defaults = new HashMap<String, Object>();
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Map<String, Object> strategy = new HashMap<String, Object>();

    public Workflow(String apiVersion, String name, TestPlan testPlan, TestPlanContext testPlanContext, String additionalConfiguration) {
        super(apiVersion);
        this.addMetadata(NAME_METADATA_KEY, name);
        this.addMetadata("namespace", testPlan.getNamespace());
        this.addMetadata("managedTests", new HashMap());
        this.addOriginProjectsMetaData(testPlan);
        Map managedTests = (Map)this.getMetadata().get("managedTests");
        managedTests.put("testPlan", this.getTestPlanMetadata(testPlanContext));
        managedTests.put("testCases", new HashMap());
        HashMap<String, JobDTO> jobMap = new HashMap<String, JobDTO>(testPlan.getProjects().size());
        for (Project project : testPlan.getProjects()) {
            JobDTO job = this.buildJob(project);
            jobMap.put("squashTMJob-" + jobMap.size(), job);
            Map testCases = (Map)managedTests.get("testCases");
            project.getTests().forEach(test -> {
                Map map2 = testCases.put(test.getMetadata("exec_step_id").toString(), test.getMetadata());
            });
        }
        this.jobs = jobMap;
        if (additionalConfiguration != null && !"".equals(additionalConfiguration)) {
            AdditionalConfiguration addConf = new AdditionalConfiguration(additionalConfiguration);
            this.mergeWithAdditionalConfiguration(addConf);
        }
    }

    public Workflow(String apiVersion) {
        super(apiVersion);
    }

    private void addOriginProjectsMetaData(TestPlan testPlan) {
        List<String> projectIds = testPlan.getConfigurations().stream().map(conf -> conf.getTmProjectId().toString()).toList();
        this.addMetadata("annotations", Collections.singletonMap("squashtest.org/originating-projects", projectIds));
    }

    private void mergeWithAdditionalConfiguration(AdditionalConfiguration additionalConfiguration) {
        this.setDefaults(additionalConfiguration.getDefaults());
        this.setHooks(additionalConfiguration.getHooks());
        this.setMetadata(Stream.concat(this.getMetadata().entrySet().stream(), additionalConfiguration.getMetadata().entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (baseMetadata, additionalMetadata) -> baseMetadata)));
        this.setResources(additionalConfiguration.getResources());
        this.setVariables(additionalConfiguration.getVariables());
        this.setStrategy(additionalConfiguration.getStrategy());
    }

    private Map<String, Object> getTestPlanMetadata(TestPlanContext testPlanContext) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put("uuid", testPlanContext.getEntityUuid());
        results.put("type", testPlanContext.getEntityTypeAsString());
        results.put("path", testPlanContext.getEntityPathAsList());
        return results;
    }

    public String name() {
        return (String)this.getMetadata().get(NAME_METADATA_KEY);
    }

    private JobDTO buildJob(Project project) {
        ArrayList<Object> steps = new ArrayList<Object>();
        Credentials testRepositoryCredentials = project.testRepositoryCredentials;
        steps.add(new TestCodeCheckoutStep(project.testRepository, testRepositoryCredentials, "checkOut"));
        for (TestExecution exec : project.getTests()) {
            if (!exec.getParams().isEmpty()) {
                ParamActionStep paramActionStep = new ParamActionStep(project.toolCategory, exec.getParams(), "paramStepName");
                steps.add(paramActionStep);
                exec.addMetadata("param_step_id", (Object)paramActionStep.getStepId());
            }
            steps.add(new TestExecutionProviderStep(exec.getDefinition(), project.toolCategory, exec.getStepId(), "execStepName"));
        }
        List<String> runsOn = this.getRunsOn(project);
        if (Objects.nonNull(project.getEnvironmentVariables()) && !project.getEnvironmentVariables().isEmpty()) {
            steps.forEach((Consumer<Object>)((Consumer<AbstractStep>)step -> step.setVariables(project.getEnvironmentVariables())));
            return new JobDTO(runsOn, steps, project.getEnvironmentVariables());
        }
        return new JobDTO(runsOn, steps);
    }

    public Map<String, JobDTO> getJobs() {
        return Collections.unmodifiableMap(this.jobs);
    }

    private List<String> getRunsOn(Project project) {
        String technologyTag;
        ArrayList<String> environmentTags = new ArrayList<String>(project.getEnvironmentTags());
        if (!environmentTags.contains(technologyTag = new Category(project.toolCategory).prefix())) {
            environmentTags.add(technologyTag);
        }
        return environmentTags;
    }

    public Map<String, Object> getVariables() {
        return !this.variables.isEmpty() ? Collections.unmodifiableMap(this.variables) : null;
    }

    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }

    public Map<String, Object> getResources() {
        return !this.resources.isEmpty() ? Collections.unmodifiableMap(this.resources) : null;
    }

    public void setResources(Map<String, Object> resources) {
        this.resources = resources;
    }

    public List<Object> getHooks() {
        return !this.hooks.isEmpty() ? this.hooks : null;
    }

    public void setHooks(List<Object> hooks) {
        this.hooks = hooks;
    }

    public Map<String, Object> getDefaults() {
        return !this.defaults.isEmpty() ? Collections.unmodifiableMap(this.defaults) : null;
    }

    public void setDefaults(Map<String, Object> defaults) {
        this.defaults = defaults;
    }

    public Map<String, Object> getStrategy() {
        return !this.strategy.isEmpty() ? Collections.unmodifiableMap(this.strategy) : null;
    }

    public void setStrategy(Map<String, Object> strategy) {
        this.strategy = strategy;
    }
}

