/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testautomation.httpclient;

import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import org.apache.http.client.config.RequestConfig;
import org.squashtest.tm.service.internal.testautomation.httpclient.ClientRuntimeException;

public class RequestConfigurationFactory {
    public RequestConfig getRequestConfig(URI endpoint, int timeoutSeconds) {
        try {
            if (InetAddress.getByName(endpoint.getHost()).isLoopbackAddress()) {
                byte[] byArray = new byte[4];
                byArray[0] = 127;
                byArray[3] = 1;
                return this.defaultConfigBuilder(timeoutSeconds).setLocalAddress(InetAddress.getByAddress(byArray)).build();
            }
            return this.defaultConfigBuilder(timeoutSeconds).build();
        }
        catch (UnknownHostException ex) {
            throw new ClientRuntimeException("Request configuration failure", ex, endpoint.toString());
        }
    }

    private RequestConfig.Builder defaultConfigBuilder(int timeoutSeconds) {
        int timeoutMs = timeoutSeconds * 1000;
        return RequestConfig.copy((RequestConfig)RequestConfig.DEFAULT).setConnectionRequestTimeout(timeoutMs).setConnectTimeout(timeoutMs).setSocketTimeout(timeoutMs);
    }
}

