/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testautomation.environment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.domain.servers.TokenAuthCredentials;
import org.squashtest.tm.domain.testautomation.TestAutomationServer;
import org.squashtest.tm.service.display.test.automation.server.TestAutomationServerDisplayService;
import org.squashtest.tm.service.internal.display.dto.automatedexecutionenvironments.ExecutionEnvironmentCountDto;
import org.squashtest.tm.service.internal.repository.ProjectDao;
import org.squashtest.tm.service.internal.repository.TestAutomationServerDao;
import org.squashtest.tm.service.internal.testautomation.TestAutomationConnectorRegistry;
import org.squashtest.tm.service.servers.StoredCredentialsManager;
import org.squashtest.tm.service.testautomation.environment.AutomatedExecutionEnvironmentService;
import org.squashtest.tm.service.testautomation.model.AutomatedExecutionEnvironment;
import org.squashtest.tm.service.testautomation.spi.InvalidSquashOrchestratorConfigurationException;
import org.squashtest.tm.service.testautomation.spi.OutdatedSquashOrchestratorException;
import org.squashtest.tm.service.testautomation.spi.TestAutomationConnector;
import org.squashtest.tm.service.testautomation.spi.TestAutomationException;

@Service
@Transactional(noRollbackFor={InvalidSquashOrchestratorConfigurationException.class})
public class AutomatedExecutionEnvironmentServiceImpl
implements AutomatedExecutionEnvironmentService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutomatedExecutionEnvironmentServiceImpl.class);
    private final TestAutomationServerDao testAutomationServerDao;
    private final TestAutomationConnectorRegistry testAutomationConnectorRegistry;
    private final TestAutomationServerDisplayService testAutomationServerDisplayService;
    private final ProjectDao customProjectDao;
    private final StoredCredentialsManager credentialsManager;

    @Inject
    public AutomatedExecutionEnvironmentServiceImpl(TestAutomationServerDao testAutomationServerDao, TestAutomationConnectorRegistry testAutomationConnectorRegistry, TestAutomationServerDisplayService testAutomationServerDisplayService, ProjectDao customProjectDao, StoredCredentialsManager credentialsManager) {
        this.testAutomationServerDao = testAutomationServerDao;
        this.testAutomationConnectorRegistry = testAutomationConnectorRegistry;
        this.testAutomationServerDisplayService = testAutomationServerDisplayService;
        this.customProjectDao = customProjectDao;
        this.credentialsManager = credentialsManager;
    }

    @Override
    public List<AutomatedExecutionEnvironment> getAllAccessibleEnvironments(Long testAutomationServerId) {
        Optional server = this.testAutomationServerDao.findById(testAutomationServerId);
        if (server.isEmpty()) {
            return Collections.emptyList();
        }
        TestAutomationConnector connector = this.testAutomationConnectorRegistry.getConnectorForKind(((TestAutomationServer)server.get()).getKind());
        return connector.getAllAccessibleEnvironments((TestAutomationServer)server.get());
    }

    @Override
    public List<AutomatedExecutionEnvironment> getAllAccessibleEnvironments(Long testAutomationServerId, Credentials credentials) {
        Optional server = this.testAutomationServerDao.findById(testAutomationServerId);
        if (server.isEmpty()) {
            return Collections.emptyList();
        }
        TestAutomationConnector connector = this.testAutomationConnectorRegistry.getConnectorForKind(((TestAutomationServer)server.get()).getKind());
        return connector.getAllAccessibleEnvironments((TestAutomationServer)server.get(), credentials);
    }

    @Override
    public boolean doesServerSupportAutomatedExecutionEnvironments(long testAutomationServerId) {
        TestAutomationServer server = (TestAutomationServer)this.testAutomationServerDao.getReferenceById(testAutomationServerId);
        TestAutomationConnector connector = this.testAutomationConnectorRegistry.getConnectorForKind(server.getKind());
        return connector.supportsAutomatedExecutionEnvironments();
    }

    @Override
    public ExecutionEnvironmentCountDto getExecutionEnvironmentCountDto(Map<Long, Long> projectAndServerIds) {
        if (projectAndServerIds.isEmpty()) {
            return new ExecutionEnvironmentCountDto(null, null, 0, null, null);
        }
        ArrayList<AutomatedExecutionEnvironment> environments = new ArrayList<AutomatedExecutionEnvironment>();
        int nbOfUnreachableServers = 0;
        int nbOfNoTokenInProjectOrServer = 0;
        for (Map.Entry<Long, Long> entry : projectAndServerIds.entrySet()) {
            Long projectId = entry.getKey();
            Long serverId = entry.getValue();
            boolean hasServerToken = this.testAutomationServerDisplayService.hasDefinedCredentials(serverId);
            Optional<TokenAuthCredentials> optionalProjectToken = this.findProjectToken(serverId, projectId);
            boolean hasProjectToken = optionalProjectToken.isPresent();
            if (!hasServerToken && !hasProjectToken) {
                LOGGER.warn("Could not get automated execution environments for server {} and project {} because no token was found", new Object[]{serverId, projectId});
                ++nbOfNoTokenInProjectOrServer;
                continue;
            }
            try {
                environments.addAll(hasProjectToken ? this.getAllAccessibleEnvironments(serverId, (Credentials)optionalProjectToken.get()) : this.getAllAccessibleEnvironments(serverId));
            }
            catch (InvalidSquashOrchestratorConfigurationException | OutdatedSquashOrchestratorException | TestAutomationException ex) {
                ++nbOfUnreachableServers;
                LOGGER.warn("Could not get automated execution environments for server {} and project {}", new Object[]{serverId, projectId, ex});
            }
        }
        Map<String, Long> statusCounts = environments.isEmpty() ? null : environments.stream().collect(Collectors.groupingBy(AutomatedExecutionEnvironment::getStatus, Collectors.counting()));
        Set<Long> projectIds = projectAndServerIds.keySet();
        return new ExecutionEnvironmentCountDto(statusCounts, this.customProjectDao.findProjectsAndServersByProjectIds(projectIds), projectAndServerIds.size(), nbOfUnreachableServers, nbOfNoTokenInProjectOrServer);
    }

    private Optional<TokenAuthCredentials> findProjectToken(Long testAutomationServerId, Long projectId) {
        return Optional.ofNullable(this.credentialsManager.findProjectCredentials(testAutomationServerId, projectId)).filter(TokenAuthCredentials.class::isInstance).map(TokenAuthCredentials.class::cast);
    }
}

