/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.scmserver;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.scm.ScmRepository;
import org.squashtest.tm.domain.scm.ScmServer;
import org.squashtest.tm.service.internal.scmserver.ScmConnectorProvider;
import org.squashtest.tm.service.spi.ScmConnector;

@Component
public class ScmConnectorRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScmConnectorRegistry.class);
    @Autowired(required=false)
    private Collection<ScmConnectorProvider> collectedScmConnectors = Collections.emptyList();
    private Map<String, ScmConnectorProvider> registeredScmConnectorsMap = new ConcurrentHashMap<String, ScmConnectorProvider>(3);

    @PostConstruct
    public void registerScmConnectorProviders() {
        for (ScmConnectorProvider provider : this.collectedScmConnectors) {
            String kind = provider.getScmKind();
            if (kind == null) {
                throw new IllegalArgumentException("Could not register ScmConnector, its kind is undefined.");
            }
            this.registeredScmConnectorsMap.put(kind, provider);
            LOGGER.info("Registered Connector of kind '{}' for Source Code Management.", new Object[]{kind});
        }
    }

    public Set<String> getRegisteredScmKinds() {
        return this.registeredScmConnectorsMap.keySet();
    }

    public ScmConnector createConnector(ScmServer scmServer) {
        String kind = scmServer.getKind();
        LOGGER.debug("Creating connector for source code management of kind '{}'.", new Object[]{kind});
        ScmConnectorProvider scmConnectorProvider = this.registeredScmConnectorsMap.get(kind);
        if (scmConnectorProvider == null) {
            throw new IllegalArgumentException("No registered ScmConnectorProvider is of type '" + kind + "'.");
        }
        return scmConnectorProvider.createScmConnector(scmServer);
    }

    public ScmConnector createConnector(ScmRepository scmRepository) {
        String kind = scmRepository.getScmServer().getKind();
        LOGGER.debug("Creating connector for source code management of kind '{}'.", new Object[]{kind});
        ScmConnectorProvider scmConnectorProvider = this.registeredScmConnectorsMap.get(kind);
        if (scmConnectorProvider == null) {
            throw new IllegalArgumentException("No registered ScmConnectorProvider is of type '" + kind + "'.");
        }
        return scmConnectorProvider.createScmConnector(scmRepository);
    }
}

