/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.requirement;

import java.util.List;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.squashtest.tm.domain.requirement.RequirementVersionLinkType;
import org.squashtest.tm.exception.RequiredFieldException;
import org.squashtest.tm.exception.requirement.link.CodesAndRolesInconsistentException;
import org.squashtest.tm.exception.requirement.link.LinkTypeCodeAlreadyExistsDomainException;
import org.squashtest.tm.exception.requirement.link.LinkTypeIsDefaultTypeException;
import org.squashtest.tm.service.internal.repository.RequirementVersionLinkDao;
import org.squashtest.tm.service.internal.repository.RequirementVersionLinkTypeDao;
import org.squashtest.tm.service.requirement.RequirementVersionLinkTypeManagerService;

@Transactional
@Service(value="squashtest.tm.service.RequirementVersionLinkTypeManagerService")
public class RequirementVersionLinkTypeManagerServiceImpl
implements RequirementVersionLinkTypeManagerService {
    private static final String ROLE_1_CODE = "role1Code";
    private static final String ROLE_2_CODE = "role2Code";
    private static final String ROLE_1 = "role1";
    @Inject
    private RequirementVersionLinkTypeDao linkTypeDao;
    @Inject
    private RequirementVersionLinkDao reqLinkDao;

    @Override
    public void addLinkType(RequirementVersionLinkType newLinkType) {
        if (this.linkTypeDao.doesCodeAlreadyExist(newLinkType.getRole1Code())) {
            throw new LinkTypeCodeAlreadyExistsDomainException("code", ROLE_1_CODE);
        }
        if (this.linkTypeDao.doesCodeAlreadyExist(newLinkType.getRole2Code())) {
            throw new LinkTypeCodeAlreadyExistsDomainException("code", ROLE_2_CODE);
        }
        if (newLinkType.getRole1Code().equals(newLinkType.getRole2Code()) && !newLinkType.getRole1().equals(newLinkType.getRole2())) {
            throw new CodesAndRolesInconsistentException(newLinkType.getRole1(), newLinkType.getRole1Code(), ROLE_1);
        }
        this.linkTypeDao.save(newLinkType);
    }

    @Override
    public boolean doesLinkTypeCodeAlreadyExist(String code) {
        return this.linkTypeDao.doesCodeAlreadyExist(code);
    }

    @Override
    public boolean doesLinkTypeCodeAlreadyExist(String code, Long linkTypeId) {
        return this.linkTypeDao.doesCodeAlreadyExist(code, linkTypeId);
    }

    @Override
    public void changeDefault(Long linkTypeId) {
        RequirementVersionLinkType newDefaultReqLinkType = (RequirementVersionLinkType)this.linkTypeDao.getReferenceById(linkTypeId);
        List<RequirementVersionLinkType> allReqLinkTypes = this.linkTypeDao.getAllRequirementVersionLinkTypes();
        for (RequirementVersionLinkType linkType : allReqLinkTypes) {
            linkType.setDefault(false);
        }
        newDefaultReqLinkType.setDefault(true);
    }

    @Override
    public void changeRole1(Long linkTypeId, String newRole1) {
        RequirementVersionLinkType linkType = (RequirementVersionLinkType)this.linkTypeDao.getReferenceById(linkTypeId);
        if (linkType.getRole1Code().equals(linkType.getRole2Code())) {
            if (!this.areCodesAndRolesConsistent(newRole1, linkType.getRole1Code(), linkType.getRole2(), linkType.getRole2Code())) {
                throw new CodesAndRolesInconsistentException(newRole1, linkType.getRole1Code(), ROLE_1);
            }
        } else {
            this.checkFieldIsNotBlank(newRole1, ROLE_1);
        }
        linkType.setRole1(newRole1);
    }

    @Override
    public void changeRole2(Long linkTypeId, String newRole2) {
        RequirementVersionLinkType linkType = (RequirementVersionLinkType)this.linkTypeDao.getReferenceById(linkTypeId);
        if (linkType.getRole1Code().equals(linkType.getRole2Code())) {
            if (!this.areCodesAndRolesConsistent(linkType.getRole1(), linkType.getRole1Code(), newRole2, linkType.getRole2Code())) {
                throw new CodesAndRolesInconsistentException(newRole2, linkType.getRole2Code(), "role2");
            }
        } else {
            this.checkFieldIsNotBlank(newRole2, "role2");
        }
        linkType.setRole2(newRole2);
    }

    @Override
    public void changeCode1(Long linkTypeId, String newCode1) {
        RequirementVersionLinkType linkType = (RequirementVersionLinkType)this.linkTypeDao.getReferenceById(linkTypeId);
        if (newCode1.equals(linkType.getRole2Code())) {
            if (!this.areCodesAndRolesConsistent(linkType.getRole1(), newCode1, linkType.getRole2(), linkType.getRole2Code())) {
                throw new CodesAndRolesInconsistentException(linkType.getRole1(), newCode1, ROLE_1_CODE);
            }
        } else {
            this.checkCodeFieldErrors(newCode1, ROLE_1_CODE);
        }
        linkType.setRole1Code(newCode1);
    }

    @Override
    public void changeCode2(Long linkTypeId, String newCode2) {
        RequirementVersionLinkType linkType = (RequirementVersionLinkType)this.linkTypeDao.getReferenceById(linkTypeId);
        if (newCode2.equals(linkType.getRole1Code())) {
            if (!this.areCodesAndRolesConsistent(linkType.getRole1(), linkType.getRole1Code(), linkType.getRole2(), newCode2)) {
                throw new CodesAndRolesInconsistentException(linkType.getRole2(), newCode2, ROLE_2_CODE);
            }
        } else {
            this.checkCodeFieldErrors(newCode2, ROLE_2_CODE);
        }
        linkType.setRole2Code(newCode2);
    }

    @Override
    public boolean isLinkTypeDefault(Long linkTypeId) {
        return this.linkTypeDao.isLinkTypeDefault(linkTypeId);
    }

    @Override
    public boolean isLinkTypeUsed(Long linkTypeId) {
        return this.linkTypeDao.isLinkTypeUsed(linkTypeId);
    }

    @Override
    public void deleteLinkType(Long linkTypeId) {
        RequirementVersionLinkType linkTypeToDelete = (RequirementVersionLinkType)this.linkTypeDao.getReferenceById(linkTypeId);
        if (this.linkTypeDao.isLinkTypeDefault(linkTypeId)) {
            throw new LinkTypeIsDefaultTypeException();
        }
        RequirementVersionLinkType defaultLinkType = this.linkTypeDao.getDefaultRequirementVersionLinkType();
        this.reqLinkDao.setLinksTypeToDefault(linkTypeToDelete, defaultLinkType);
        this.linkTypeDao.delete(linkTypeToDelete);
    }

    @Override
    public boolean doesContainDefault(List<Long> linkTypesIdsToCheck) {
        List linkTypesToCheck = this.linkTypeDao.findAllById(linkTypesIdsToCheck);
        for (RequirementVersionLinkType linkType : linkTypesToCheck) {
            if (!linkType.isDefault()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void deleteLinkTypes(List<Long> linkTypeIdsToDelete) {
        for (Long id : linkTypeIdsToDelete) {
            this.deleteLinkType(id);
        }
    }

    private boolean areCodesAndRolesConsistent(String role1, String role1Code, String role2, String role2Code) {
        return !role1Code.equals(role2Code) || role1.equals(role2);
    }

    private void checkCodeFieldErrors(String code, String fieldName) {
        this.checkFieldIsNotBlank(code, fieldName);
        if (this.linkTypeDao.doesCodeAlreadyExist(code)) {
            throw new LinkTypeCodeAlreadyExistsDomainException("code", fieldName);
        }
    }

    private void checkFieldIsNotBlank(String fieldValue, String fieldName) {
        if (!StringUtils.hasText((String)fieldValue)) {
            throw new RequiredFieldException(fieldName);
        }
    }
}

