/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.requirement;

import java.util.List;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.requirement.HighLevelNewRequirementVersionDto;
import org.squashtest.tm.domain.requirement.HighLevelRequirementConverter;
import org.squashtest.tm.domain.requirement.HighLevelRequirementCreator;
import org.squashtest.tm.domain.requirement.NewRequirementVersionDto;
import org.squashtest.tm.domain.requirement.Requirement;

@Component
public class RequirementFactory {
    private final List<HighLevelRequirementCreator> requirementCreators;
    private final List<HighLevelRequirementConverter> requirementConverters;

    public RequirementFactory(List<HighLevelRequirementCreator> requirementCreators, List<HighLevelRequirementConverter> requirementConverters) {
        this.requirementCreators = requirementCreators;
        this.requirementConverters = requirementConverters;
    }

    Requirement createRequirement(NewRequirementVersionDto newVersionData) {
        if (newVersionData.isHighLevel()) {
            return this.createRequirement((HighLevelNewRequirementVersionDto)newVersionData);
        }
        return new Requirement(newVersionData.toRequirementVersion());
    }

    Requirement createRequirement(HighLevelNewRequirementVersionDto newVersionData) {
        HighLevelRequirementCreator requirementCreator = (HighLevelRequirementCreator)this.requirementCreators.stream().findFirst().orElseThrow(() -> new UnsupportedOperationException("A dedicated plugin is required to create high level requirements"));
        return requirementCreator.createRequirement(newVersionData);
    }

    void convertIntoHighLevelRequirement(Long requirementId) {
        HighLevelRequirementConverter requirementConverter = (HighLevelRequirementConverter)this.requirementConverters.stream().findFirst().orElseThrow(() -> new UnsupportedOperationException("A dedicated plugin is required to convert standard requirement into high level requirement"));
        requirementConverter.convertIntoHighLevelRequirement(requirementId);
    }

    void convertIntoStandardRequirement(Long requirementId) {
        HighLevelRequirementConverter requirementConverter = (HighLevelRequirementConverter)this.requirementConverters.stream().findFirst().orElseThrow(() -> new UnsupportedOperationException("A dedicated plugin is required to convert high level requirement into standard requirement"));
        requirementConverter.convertIntoStandardRequirement(requirementId);
    }
}

