/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate.attachmentlist.querybuilder;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.service.internal.repository.hibernate.attachmentlist.querybuilder.ActionTestStepAttachmentListQueryStrategy;
import org.squashtest.tm.service.internal.repository.hibernate.attachmentlist.querybuilder.CampaignAttachmentListQueryStrategy;
import org.squashtest.tm.service.internal.repository.hibernate.attachmentlist.querybuilder.ExecutionAttachmentListQueryStrategy;
import org.squashtest.tm.service.internal.repository.hibernate.attachmentlist.querybuilder.ExecutionStepAttachmentListQueryStrategy;
import org.squashtest.tm.service.internal.repository.hibernate.attachmentlist.querybuilder.IterationAttachmentListQueryStrategy;
import org.squashtest.tm.service.internal.repository.hibernate.attachmentlist.querybuilder.RequirementVersionAttachmentListQueryStrategy;
import org.squashtest.tm.service.internal.repository.hibernate.attachmentlist.querybuilder.TestCaseAttachmentListQueryStrategy;
import org.squashtest.tm.service.internal.repository.hibernate.attachmentlist.querybuilder.context.AttachmentListLockedMilestonesQueryContext;
import org.squashtest.tm.service.internal.repository.hibernate.attachmentlist.querybuilder.strategy.AttachmentListLockedMilestonesQueryStrategy;

public class AttachmentListQueryBuilder {
    private static final String HOLDER_BASE_QUERY = "select holder from ";
    private static final String HOLDER_REQUIREMENT_FOLDER_QUERY = " holder where holder.resource.attachmentList.id = :attachmentListId";
    private static final String HOLDER_DEFAULT_QUERY = " holder where holder.attachmentList.id = :attachmentListId";
    private static final Map<String, String> customQueries = new HashMap<String, String>();
    private static final Map<EntityType, Supplier<AttachmentListLockedMilestonesQueryStrategy>> STRATEGY_MAP;

    static {
        customQueries.put(EntityType.REQUIREMENT_FOLDER.getSimpleClassName(), HOLDER_REQUIREMENT_FOLDER_QUERY);
        customQueries.put(EntityType.REQUIREMENT.getSimpleClassName(), HOLDER_REQUIREMENT_FOLDER_QUERY);
        STRATEGY_MAP = new EnumMap<EntityType, Supplier<AttachmentListLockedMilestonesQueryStrategy>>(EntityType.class);
        STRATEGY_MAP.put(EntityType.REQUIREMENT_VERSION, RequirementVersionAttachmentListQueryStrategy::new);
        STRATEGY_MAP.put(EntityType.TEST_CASE, TestCaseAttachmentListQueryStrategy::new);
        STRATEGY_MAP.put(EntityType.CAMPAIGN, CampaignAttachmentListQueryStrategy::new);
        STRATEGY_MAP.put(EntityType.ITERATION, IterationAttachmentListQueryStrategy::new);
        STRATEGY_MAP.put(EntityType.EXECUTION, ExecutionAttachmentListQueryStrategy::new);
        STRATEGY_MAP.put(EntityType.EXECUTION_STEP, ExecutionStepAttachmentListQueryStrategy::new);
        STRATEGY_MAP.put(EntityType.ACTION_TEST_STEP, ActionTestStepAttachmentListQueryStrategy::new);
    }

    public boolean isLockedMilestonesQuerySupported(EntityType entityType) {
        return STRATEGY_MAP.containsKey(entityType);
    }

    public String getLockedMilestonesQuery(EntityType entityType) {
        AttachmentListLockedMilestonesQueryContext context = new AttachmentListLockedMilestonesQueryContext();
        Supplier<AttachmentListLockedMilestonesQueryStrategy> strategySupplier = STRATEGY_MAP.get(entityType);
        if (strategySupplier == null) {
            throw new IllegalArgumentException("Unsupported entity type: " + entityType);
        }
        context.setStrategy(strategySupplier.get());
        return context.getLockedMilestonesQuery();
    }

    public String getHolderEntityQuery(EntityType entityType) {
        String className = entityType.getSimpleClassName();
        StringBuilder query = new StringBuilder(HOLDER_BASE_QUERY).append(className);
        query.append(customQueries.getOrDefault(className, HOLDER_DEFAULT_QUERY));
        return query.toString();
    }
}

