/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.hibernate.type.LongType;
import org.hibernate.type.Type;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.collection.DefaultPagingAndSorting;
import org.squashtest.tm.core.foundation.collection.Paging;
import org.squashtest.tm.core.foundation.collection.PagingAndSorting;
import org.squashtest.tm.core.foundation.collection.SortOrder;
import org.squashtest.tm.core.foundation.collection.Sorting;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.requirement.RequirementStatus;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.testcase.RequirementVersionCoverage;
import org.squashtest.tm.exception.requirement.RequirementVersionNotLinkableException;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.foundation.collection.PagingUtils;
import org.squashtest.tm.service.internal.foundation.collection.SortingUtils;
import org.squashtest.tm.service.internal.repository.CustomRequirementVersionCoverageDao;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateEntityDao;

public class RequirementVersionCoverageDaoImpl
extends HibernateEntityDao<RequirementVersionCoverage>
implements CustomRequirementVersionCoverageDao {
    @Inject
    private DSLContext dslContext;

    @Override
    public List<RequirementVersionCoverage> findAllByTestCaseId(long testCaseId, PagingAndSorting pas) {
        Query namedquery = this.currentSession().getNamedQuery("RequirementVersionCoverage.findAllByTestCaseId");
        String hql = namedquery.getQueryString();
        hql = SortingUtils.addOrder(hql, (Sorting)pas);
        Query q = this.currentSession().createQuery(hql);
        if (!pas.shouldDisplayAll()) {
            PagingUtils.addPaging(q, (Paging)pas);
        }
        q.setParameter("testCaseId", (Object)testCaseId);
        List raw = q.list();
        ArrayList<RequirementVersionCoverage> res = new ArrayList<RequirementVersionCoverage>(raw.size());
        for (Object[] tuple : raw) {
            res.add((RequirementVersionCoverage)tuple[0]);
        }
        return res;
    }

    @Override
    public List<RequirementVersion> findDistinctRequirementVersionsByTestCases(Collection<Long> testCaseIds, PagingAndSorting pagingAndSorting) {
        if (testCaseIds.isEmpty()) {
            return Collections.emptyList();
        }
        Query namedquery = this.currentSession().getNamedQuery("RequirementVersion.findDistinctRequirementVersionsByTestCases");
        String hql = namedquery.getQueryString();
        hql = SortingUtils.addOrder(hql, (Sorting)pagingAndSorting);
        Query q = this.currentSession().createQuery(hql);
        if (!pagingAndSorting.shouldDisplayAll()) {
            PagingUtils.addPaging(q, (Paging)pagingAndSorting);
        }
        q.setParameterList("testCaseIds", testCaseIds, (Type)LongType.INSTANCE);
        List raw = q.list();
        ArrayList<RequirementVersion> res = new ArrayList<RequirementVersion>(raw.size());
        for (Object[] tuple : raw) {
            res.add((RequirementVersion)tuple[0]);
        }
        if ("endDate".equals(pagingAndSorting.getSortedAttribute())) {
            Collections.sort(res, new Comparator<RequirementVersion>(){

                @Override
                public int compare(RequirementVersion req1, RequirementVersion req2) {
                    return RequirementVersionCoverageDaoImpl.this.compareReqMilestoneDate(req1, req2);
                }
            });
            if (pagingAndSorting.getSortOrder() == SortOrder.ASCENDING) {
                Collections.reverse(res);
            }
        }
        return res;
    }

    private int compareReqMilestoneDate(RequirementVersion req1, RequirementVersion req2) {
        boolean isEmpty1 = req1.getMilestones().isEmpty();
        boolean isEmpty2 = req2.getMilestones().isEmpty();
        if (isEmpty1 && isEmpty2) {
            return 0;
        }
        if (isEmpty1) {
            return 1;
        }
        if (isEmpty2) {
            return -1;
        }
        return this.getMinDate(req1).before(this.getMinDate(req2)) ? (this.getMinDate(req1).after(this.getMinDate(req2)) ? 0 : 1) : -1;
    }

    private Date getMinDate(RequirementVersion req) {
        return Collections.min(req.getMilestones(), new Comparator<Milestone>(){

            @Override
            public int compare(Milestone m1, Milestone m2) {
                return m1.getEndDate().before(m2.getEndDate()) ? -1 : 1;
            }
        }).getEndDate();
    }

    @Override
    @Transactional(readOnly=true)
    public List<RequirementVersion> findDistinctRequirementVersionsByTestCases(Collection<Long> testCaseIds) {
        DefaultPagingAndSorting pas = new DefaultPagingAndSorting("RequirementVersion.name", true);
        return this.findDistinctRequirementVersionsByTestCases(testCaseIds, (PagingAndSorting)pas);
    }

    @Override
    public void delete(List<Long> requirementVersionCoverageIds) {
        this.removeTestSTepByCoverageIds(requirementVersionCoverageIds);
        Query queryRemoveRequirementVersionCoverage = this.currentSession().getNamedQuery("requirementDeletionDao.deleteVersionCoverages");
        queryRemoveRequirementVersionCoverage.setParameterList("covIds", requirementVersionCoverageIds);
        queryRemoveRequirementVersionCoverage.executeUpdate();
    }

    @Override
    public void removeTestSTepByCoverageIds(List<Long> requirementVersionCoverageIds) {
        Session s = this.currentSession();
        String sql = "delete from VERIFYING_STEPS where requirement_version_coverage_id in :covIds";
        NativeQuery q = s.createNativeQuery(sql);
        q.setParameterList("covIds", requirementVersionCoverageIds);
        q.executeUpdate();
        s.flush();
    }

    @Override
    public List<Long> byTestCaseAndRequirementVersions(Collection<Long> reqVerCovIds, long testCaseId) {
        return this.dslContext.select((SelectField)Tables.REQUIREMENT_VERSION_COVERAGE.REQUIREMENT_VERSION_COVERAGE_ID).from((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).where(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID.eq((Object)testCaseId).and(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID.in(reqVerCovIds))).fetchInto(Long.class);
    }

    @Override
    public List<Long> byRequirementVersionAndTestCases(Collection<Long> testCaseIds, long resourceId) {
        return this.dslContext.select((SelectField)Tables.REQUIREMENT_VERSION_COVERAGE.REQUIREMENT_VERSION_COVERAGE_ID).from((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).join((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID)).where(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID.in(testCaseIds).and(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID.eq((Object)resourceId))).fetchInto(Long.class);
    }

    @Override
    public void checkIfReqVersionIsLinkable(long reqVersionId) {
        RequirementStatus status;
        String result = (String)this.dslContext.select((SelectField)Tables.REQUIREMENT_VERSION.REQUIREMENT_STATUS).from((TableLike)Tables.REQUIREMENT_VERSION).where(Tables.REQUIREMENT_VERSION.RES_ID.eq((Object)reqVersionId)).fetchOneInto(String.class);
        if (result != null && !(status = RequirementStatus.valueOf((String)result)).isRequirementLinkable()) {
            throw new RequirementVersionNotLinkableException(Long.valueOf(reqVersionId));
        }
    }

    @Override
    public List<Long> byRequirementVersionsAndTestStep(Collection<Long> rvIds, long stepId) {
        return this.dslContext.select((SelectField)Tables.REQUIREMENT_VERSION_COVERAGE.REQUIREMENT_VERSION_COVERAGE_ID).from((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).join((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID)).join((TableLike)Tables.VERIFYING_STEPS).on(Tables.VERIFYING_STEPS.REQUIREMENT_VERSION_COVERAGE_ID.eq((Field)Tables.REQUIREMENT_VERSION_COVERAGE.REQUIREMENT_VERSION_COVERAGE_ID)).where(Tables.VERIFYING_STEPS.TEST_STEP_ID.eq((Object)stepId).and(Tables.REQUIREMENT_VERSION.RES_ID.in(rvIds))).fetchInto(Long.class);
    }
}

