/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.jooq.CommonTableExpression;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.squashtest.tm.domain.testcase.Parameter;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.repository.CustomParameterDao;
import org.squashtest.tm.service.internal.repository.hibernate.loaders.EntityGraphQueryBuilder;

public class ParameterDaoImpl
implements CustomParameterDao {
    @PersistenceContext
    private EntityManager em;
    @Inject
    private DSLContext dslContext;

    @Override
    public List<Parameter> findAllParametersByTestCase(Long testcaseId) {
        ArrayList<Parameter> allParameters = new ArrayList<Parameter>();
        HashSet<Long> exploredTc = new HashSet<Long>();
        List<Long> srcTc = new LinkedList<Long>();
        Query next = this.em.createNamedQuery("parameter.findTestCasesThatDelegatesParameters");
        srcTc.add(testcaseId);
        while (!srcTc.isEmpty()) {
            allParameters.addAll(this.findTestCaseParameters(srcTc));
            next.setParameter("srcIds", srcTc);
            List destTc = next.getResultList();
            exploredTc.addAll(srcTc);
            srcTc = destTc;
            srcTc.removeAll(exploredTc);
        }
        return allParameters;
    }

    private List<Parameter> findTestCaseParameters(List<Long> testcaseIds) {
        Query query = this.em.createNamedQuery("Parameter.findOwnParametersByTestCases");
        query.setParameter("testCaseIds", testcaseIds);
        return query.getResultList();
    }

    @Override
    public Map<Long, List<Parameter>> findOwnParametersByTestCaseIds(Collection<Long> testCaseIds) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Stream<Object[]> resultStream = this.getParametersByTCIdsStream(testCaseIds);){
            return resultStream.collect(Collectors.groupingBy(result -> (Long)result[0], Collectors.mapping(result -> (Parameter)result[1], Collectors.toList())));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Stream<Object[]> getParametersByTCIdsStream(Collection<Long> testCaseIds) {
        return this.em.createQuery("select testCase.id, parameter, parameter.name\nfrom Parameter parameter\njoin parameter.testCase testCase\nwhere testCase.id in :ids\norder by parameter.name", Object[].class).setParameter("ids", testCaseIds).getResultStream();
    }

    @Override
    public Map<Long, List<Parameter>> findAllParametersByTestCaseIds(Collection<Long> sourceTestCaseIds) {
        Map<Long, List<Long>> calledTestCaseIdsByCaller = this.findTestCasesThatDelegatesParameters(sourceTestCaseIds);
        Set<Long> allTestCaseIds = Stream.concat(sourceTestCaseIds.stream(), calledTestCaseIdsByCaller.values().stream().flatMap(Collection::stream)).collect(Collectors.toSet());
        Map<Long, List<Parameter>> parametersByTestCaseId = this.findParametersByTestCaseIds(allTestCaseIds);
        return sourceTestCaseIds.stream().map(testCaseId -> {
            ArrayList parameters = new ArrayList(parametersByTestCaseId.getOrDefault(testCaseId, List.of()));
            calledTestCaseIdsByCaller.getOrDefault(testCaseId, Collections.emptyList()).stream().map(calledId -> parametersByTestCaseId.getOrDefault(calledId, List.of())).forEach(parameters::addAll);
            return parameters.isEmpty() ? null : Map.entry(testCaseId, parameters);
        }).filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public Map<Long, List<Parameter>> findParametersByTestCaseIds(Collection<Long> testCaseIds) {
        List<Parameter> parameters = new EntityGraphQueryBuilder<Parameter>(this.em, Parameter.class, "select parameter from Parameter parameter where parameter.testCase.id in (:ids)").executeDistinctList(Map.of("ids", testCaseIds));
        HashMap<Long, List<Parameter>> result = new HashMap<Long, List<Parameter>>();
        for (Parameter parameter : parameters) {
            result.computeIfAbsent(parameter.getTestCase().getId(), k -> new ArrayList()).add(parameter);
        }
        return result;
    }

    private Map<Long, List<Long>> findTestCasesThatDelegatesParameters(Collection<Long> testCaseIds) {
        CommonTableExpression cte = DSL.name((String)"cte").fields("source_id", "called_id").as((ResultQuery)DSL.select((SelectField)Tables.TEST_CASE_STEPS.TEST_CASE_ID, (SelectField)Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID).from((TableLike)Tables.TEST_CASE_STEPS).innerJoin((TableLike)Tables.CALL_TEST_STEP).on(Tables.TEST_CASE_STEPS.STEP_ID.eq((Field)Tables.CALL_TEST_STEP.TEST_STEP_ID)).where(Tables.TEST_CASE_STEPS.TEST_CASE_ID.in(testCaseIds).and(Tables.CALL_TEST_STEP.DELEGATE_PARAMETER_VALUES.eq((Object)Boolean.TRUE))).union((Select)DSL.select((SelectField)DSL.field((Name)DSL.name((String[])new String[]{"cte", "source_id"}), Long.class), (SelectField)Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID).from(DSL.name((String)"cte")).innerJoin((TableLike)Tables.TEST_CASE_STEPS).on(DSL.field((Name)DSL.name((String[])new String[]{"cte", "called_id"})).eq((Object)Tables.TEST_CASE_STEPS.TEST_CASE_ID)).innerJoin((TableLike)Tables.CALL_TEST_STEP).on(Tables.TEST_CASE_STEPS.STEP_ID.eq((Field)Tables.CALL_TEST_STEP.TEST_STEP_ID).and(Tables.CALL_TEST_STEP.DELEGATE_PARAMETER_VALUES.eq((Object)Boolean.TRUE)))));
        return this.dslContext.withRecursive(new CommonTableExpression[]{cte}).selectFrom((TableLike)cte).fetchGroups(DSL.field((String)"source_id", Long.class), DSL.field((String)"called_id", Long.class));
    }
}

