/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.bdd.BddScriptLanguage;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.IterationTestPlanItem;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.testautomation.TestAutomationServerKind;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseAutomatable;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequestStatus;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.ItemTestPlanExecution;
import org.squashtest.tm.service.internal.repository.CustomIterationTestPlanDao;
import org.squashtest.tm.service.internal.repository.hibernate.loaders.EntityGraphQueryBuilder;

@Repository
public class IterationTestPlanDaoImpl
implements CustomIterationTestPlanDao {
    private static final Condition TEST_CASE_HAS_AUTOMATED_STATUS = Tables.TEST_CASE.AUTOMATABLE.eq((Object)TestCaseAutomatable.Y.name()).and(Tables.AUTOMATION_REQUEST.REQUEST_STATUS.eq((Object)AutomationRequestStatus.AUTOMATED.name()));
    @PersistenceContext
    private EntityManager entityManager;
    @Inject
    private DSLContext dslContext;

    @Override
    public List<IterationTestPlanItem> findAllByIterationIdWithTCAutomated(Long iterationId) {
        Query q = this.entityManager.createNamedQuery("IterationTestPlanItem.findAllByIterationIdWithTCAutomated");
        q.setParameter("iterationId", (Object)iterationId);
        return q.getResultList();
    }

    @Override
    public List<IterationTestPlanItem> findAllByTestSuiteIdWithTCAutomated(Long testSuiteId) {
        Query q = this.entityManager.createNamedQuery("IterationTestPlanItem.findAllByTestSuiteIdWithTCAutomated");
        q.setParameter("testSuiteId", (Object)testSuiteId);
        return q.getResultList();
    }

    @Override
    public List<IterationTestPlanItem> findAllByItemsIdWithTCAutomated(List<Long> itemsIds) {
        Query q = this.entityManager.createNamedQuery("IterationTestPlanItem.findAllByItemsIdWithTCAutomated");
        q.setParameter("itemsIds", itemsIds);
        return q.getResultList();
    }

    @Override
    public List<IterationTestPlanItem> fetchForAutomatedExecutionCreation(Collection<Long> itemTestPlanIds) {
        List<IterationTestPlanItem> testPlanItems = this.fetchIterationTestPlanItems(itemTestPlanIds);
        Map<Long, IterationTestPlanItem> itemMap = testPlanItems.stream().collect(Collectors.toMap(IterationTestPlanItem::getId, item -> item));
        return itemTestPlanIds.stream().map(itemMap::get).toList();
    }

    private List<IterationTestPlanItem> fetchIterationTestPlanItems(Collection<Long> itemTestPlanIds) {
        List<IterationTestPlanItem> items = new EntityGraphQueryBuilder<IterationTestPlanItem>(this.entityManager, IterationTestPlanItem.class, "SELECT DISTINCT itpi FROM IterationTestPlanItem itpi WHERE itpi.id IN :ids ORDER BY itpi.id").addAttributeNodes("testSuites", "iteration", "exploratorySessionOverview").executeDistinctList(Collections.singletonMap("ids", itemTestPlanIds));
        if (items.isEmpty()) {
            return Collections.emptyList();
        }
        this.loadItemsAttributes(items);
        return items;
    }

    private void loadItemsAttributes(List<IterationTestPlanItem> items) {
        Set<Long> tcIds = items.stream().map(item -> item.getReferencedTestCase().getId()).collect(Collectors.toSet());
        Set datasetIds = items.stream().filter(item -> item.getReferencedDataset() != null).map(item -> item.getReferencedDataset().getId()).collect(Collectors.toSet());
        Set iterationIds = items.stream().filter(item -> item.getIteration() != null).map(item -> item.getIteration().getId()).collect(Collectors.toSet());
        new EntityGraphQueryBuilder<TestCase>(this.entityManager, TestCase.class, "SELECT DISTINCT tc FROM TestCase tc WHERE tc.id IN :ids").addAttributeNodes("parameters", "automationRequest", "automatedTest", "nature", "type", "attachmentList", "automatedTestReference", "automatedTestTechnology", "datasets", "scmRepository", "steps").addSubGraph("attachmentList", "attachments").addSubGraph("scmRepository", "scmServer").executeDistinctList(Collections.singletonMap("ids", tcIds));
        new EntityGraphQueryBuilder<Dataset>(this.entityManager, Dataset.class, "SELECT DISTINCT ds FROM Dataset ds WHERE ds.id IN :ids").addAttributeNodes("parameterValues").addSubGraph("parameterValues", "dataset", "parameter").executeDistinctList(Collections.singletonMap("ids", datasetIds));
        new EntityGraphQueryBuilder<Iteration>(this.entityManager, Iteration.class, "SELECT DISTINCT it FROM Iteration it WHERE it.id IN :ids").addAttributeNodes("campaign", "testPlans").addSubGraph("testPlans", "exploratorySessionOverview").addSubGraph("campaign", "iterations").executeDistinctList(Collections.singletonMap("ids", iterationIds));
        this.fetchTestStepsForAutomatedExecutionCreation(tcIds);
    }

    private void fetchTestStepsForAutomatedExecutionCreation(Set<Long> testCaseIds) {
        this.entityManager.createNamedQuery("ActionTestSteps.fetchWithAttachmentReferences").setParameter("testCaseIds", testCaseIds).setHint("hibernate.query.passDistinctThrough", (Object)false).getResultList();
    }

    @Override
    public List<Long> findAllByIterationIdAndLogin(Long iterationId, String login) {
        Query q = this.entityManager.createNamedQuery("IterationTestPlanItem.findAllByIterationIdAndUserLogin");
        q.setParameter("iterationId", (Object)iterationId);
        q.setParameter("login", (Object)login);
        return q.getResultList();
    }

    @Override
    public List<Long> findAllByTestSuiteId(Long testSuiteId) {
        Query q = this.entityManager.createNamedQuery("IterationTestPlanItem.findAllByTestSuiteIdWithReferencedDataset");
        q.setParameter("testSuiteId", (Object)testSuiteId);
        return q.getResultList();
    }

    @Override
    public List<IterationTestPlanItem> findIterationTestPlanItemsToRemoveInDeleteTestSuite(List<TestSuite> suites, List<Long> targetIds) {
        Query q = this.entityManager.createNamedQuery("IterationTestPlanItem.findIterationTestPlanItemsToRemoveInDeleteTestSuite");
        q.setParameter("suites", suites);
        q.setParameter("targetIds", targetIds);
        return q.getResultList();
    }

    @Override
    public List<IterationTestPlanItem> fetchWithServerByIds(Collection<Long> itemIds) {
        return new EntityGraphQueryBuilder<IterationTestPlanItem>(this.entityManager, IterationTestPlanItem.class, "SELECT DISTINCT itpi FROM IterationTestPlanItem itpi WHERE itpi.id IN :ids ORDER BY itpi.id").addAttributeNodes("referencedTestCase", "iteration", "testSuites", "exploratorySessionOverview").addSubGraph("referencedTestCase", "scmRepository").addSubgraphToSubgraph("referencedTestCase", "scmRepository", "scmServer").executeDistinctList(Map.of("ids", itemIds));
    }

    @Override
    public List<Long> getITPIsByIterationUUIDAndIsAutomated(String iterationUUID) {
        return this.entityManager.createQuery("select distinct itpi.id from Iteration it join it.testPlans itpi join itpi.referencedTestCase tc left join tc.automationRequest ar WHERE it.uuid = :uuid AND ((tc.project.allowAutomationWorkflow = TRUE AND tc.automatable = 'Y' AND ar.id = tc.automationRequest.id AND ar.requestStatus = 'AUTOMATED') OR tc.project.allowAutomationWorkflow = FALSE )AND (tc.scmRepository IS NOT NULL AND tc.automatedTestReference IS NOT NULL AND tc.automatedTestReference != '' AND tc.automatedTestTechnology IS NOT NULL) ORDER BY index(itpi)", Long.class).setParameter("uuid", (Object)iterationUUID).setHint("hibernate.query.passDistinctThrough", (Object)false).getResultList();
    }

    @Override
    public List<Long> getITPIsByTestSuiteUUIDAndIsAutomated(String testSuiteUUID) {
        return this.entityManager.createQuery("SELECT distinct itpi.id FROM TestSuite ts JOIN ts.testPlan itpi JOIN itpi.referencedTestCase tc LEFT JOIN tc.automationRequest ar WHERE ts.uuid = :uuid AND ((tc.project.allowAutomationWorkflow = TRUE AND tc.automatable = 'Y' AND ar.id = tc.automationRequest.id AND ar.requestStatus = 'AUTOMATED') OR tc.project.allowAutomationWorkflow = FALSE )AND (tc.scmRepository IS NOT NULL AND tc.automatedTestReference IS NOT NULL AND tc.automatedTestReference != '' AND tc.automatedTestTechnology IS NOT NULL)ORDER BY index(itpi)", Long.class).setParameter("uuid", (Object)testSuiteUUID).setHint("hibernate.query.passDistinctThrough", (Object)false).getResultList();
    }

    @Override
    public List<Long> filterSquashTfItemIds(List<Long> itemIds) {
        Condition isSquashTFAutomated = Tables.TEST_AUTOMATION_SERVER.KIND.eq((Object)TestAutomationServerKind.jenkins.name()).and(Tables.TEST_CASE.TA_TEST.isNotNull());
        Condition condition = Tables.PROJECT.ALLOW_AUTOMATION_WORKFLOW.eq((Object)Boolean.TRUE).and(TEST_CASE_HAS_AUTOMATED_STATUS).and(isSquashTFAutomated).or(Tables.PROJECT.ALLOW_AUTOMATION_WORKFLOW.eq((Object)Boolean.FALSE).and(isSquashTFAutomated));
        return this.filterItemIds(itemIds, condition);
    }

    @Override
    public List<Long> filterSquashOrchestratorItemIds(List<Long> itemIds) {
        Condition isSquashOrchestratorAutomated = Tables.TEST_AUTOMATION_SERVER.KIND.eq((Object)TestAutomationServerKind.squashOrchestrator.name()).and(Tables.TEST_CASE.AUTOMATED_TEST_TECHNOLOGY.isNotNull().and(Tables.TEST_CASE.AUTOMATED_TEST_REFERENCE.ne((Object)"")).and(Tables.TEST_CASE.SCM_REPOSITORY_ID.isNotNull()));
        Condition condition = Tables.PROJECT.ALLOW_AUTOMATION_WORKFLOW.eq((Object)Boolean.TRUE).and(TEST_CASE_HAS_AUTOMATED_STATUS).and(isSquashOrchestratorAutomated).or(Tables.PROJECT.ALLOW_AUTOMATION_WORKFLOW.eq((Object)Boolean.FALSE).and(isSquashOrchestratorAutomated));
        return this.filterItemIds(itemIds, condition);
    }

    private List<Long> filterItemIds(List<Long> itemIds, Condition condition) {
        return this.dslContext.select((SelectField)Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID).from((TableLike)Tables.ITERATION_TEST_PLAN_ITEM).innerJoin((TableLike)Tables.TEST_CASE).on(Tables.ITERATION_TEST_PLAN_ITEM.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).leftJoin((TableLike)Tables.AUTOMATION_REQUEST).on(Tables.TEST_CASE.AUTOMATION_REQUEST_ID.eq((Field)Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).leftJoin((TableLike)Tables.TEST_AUTOMATION_SERVER).on(Tables.PROJECT.TA_SERVER_ID.eq((Field)Tables.TEST_AUTOMATION_SERVER.SERVER_ID)).where(Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID.in(itemIds).and(condition)).fetchInto(Long.class);
    }

    @Override
    public Map<Long, Integer> getNextTestPlanExecutionOrders(Collection<Long> testPlanIds) {
        return this.dslContext.select((SelectField)Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID, (SelectField)DSL.coalesce((Field)DSL.max((Field)ItemTestPlanExecution.ITEM_TEST_PLAN_EXECUTION.EXECUTION_ORDER).plus((Number)1), (Object)0).as("ORDER")).from((TableLike)Tables.ITERATION_TEST_PLAN_ITEM).leftJoin((TableLike)ItemTestPlanExecution.ITEM_TEST_PLAN_EXECUTION).on(Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID.eq((Field)ItemTestPlanExecution.ITEM_TEST_PLAN_EXECUTION.ITEM_TEST_PLAN_ID)).where(Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID.in(testPlanIds)).groupBy(new GroupField[]{Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID}).fetchMap((Field)Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID, DSL.field((String)"ORDER", Integer.class));
    }

    @Override
    public BddScriptLanguage findProjectBddScriptLanguageByIterationTestPlanItemId(long testPlanItemId) {
        return (BddScriptLanguage)this.dslContext.select((SelectField)Tables.PROJECT.BDD_SCRIPT_LANGUAGE).from((TableLike)Tables.PROJECT).join((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).join((TableLike)Tables.ITERATION_TEST_PLAN_ITEM).on(Tables.ITERATION_TEST_PLAN_ITEM.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).where(Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID.eq((Object)testPlanItemId)).fetchOneInto(BddScriptLanguage.class);
    }
}

