/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.hibernate.query.Query;
import org.hibernate.type.LongType;
import org.hibernate.type.Type;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.service.internal.repository.TestStepDao;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateEntityDao;
import org.squashtest.tm.service.internal.repository.hibernate.SetQueryParametersCallback;

@Repository
public class HibernateTestStepDao
extends HibernateEntityDao<TestStep>
implements TestStepDao {
    @Override
    public List<TestStep> findListById(List<Long> testStepIds) {
        TestStepIdsQueryParametersCallback callback = new TestStepIdsQueryParametersCallback(testStepIds);
        return this.executeListNamedQuery("testStep.findOrderedListById", callback);
    }

    @Override
    public int findPositionOfStep(Long testStepId) {
        Query query = this.currentSession().getNamedQuery("testStep.findPositionOfStep");
        query.setParameter("stepId", (Object)testStepId, (Type)LongType.INSTANCE);
        return (Integer)query.uniqueResult();
    }

    @Override
    public ActionTestStep findActionTestStepById(long testStepId) {
        return (ActionTestStep)this.currentSession().get(ActionTestStep.class, (Serializable)Long.valueOf(testStepId));
    }

    @Override
    public boolean stringIsFoundInStepsOfTestCase(String stringToFind, long testCaseId) {
        Query query = this.currentSession().getNamedQuery("testStep.stringIsFoundInStepsOfTestCase");
        query.setParameter("testCaseId", (Object)testCaseId);
        query.setParameter("stringToFind", (Object)("%" + stringToFind + "%"));
        return (Long)query.uniqueResult() > 0L;
    }

    @Override
    public boolean stringIsFoundInStepsOfKeywordTestCase(String stringToFind, long testCaseId) {
        Query query = this.currentSession().getNamedQuery("testStep.stringIsFoundInStepsOfKeywordTestCase");
        query.setParameter("testCaseId", (Object)testCaseId);
        query.setParameter("stringToFind", (Object)stringToFind);
        return (Long)query.uniqueResult() > 0L;
    }

    @Override
    public List<TestStep> findByIdOrderedByIndex(List<Long> testStepIds) {
        Query query = this.currentSession().getNamedQuery("testStep.findByIdOrderedByIndex");
        query.setParameterList("testStepIds", testStepIds);
        return query.list();
    }

    @Override
    public TestCase findTestCaseFromActionTestStep(long testStepId) {
        Query query = this.currentSession().getNamedQuery("testStep.findTestCaseFromActionTestStep");
        query.setParameter("testStepId", (Object)testStepId, (Type)LongType.INSTANCE);
        return (TestCase)query.uniqueResult();
    }

    @Override
    public List<Object[]> findTestStepsDetails(Collection<Long> testCaseIds) {
        return this.entityManager.createQuery("select tc.id,\ncase when st.class = ActionTestStep then 'ACTION' else 'CALL' end as steptype,\ncase when st.class = CallTestStep then st.calledTestCase.id else null end as calledTC,\ncase when st.class=CallTestStep then st.delegateParameterValues else false end as delegates\nfrom TestCase tc join tc.steps st where tc.id in :ids order by index(st)", Object[].class).setParameter("ids", testCaseIds).getResultList();
    }

    private static final class TestStepIdsQueryParametersCallback
    implements SetQueryParametersCallback {
        private List<Long> testStepIds;

        private TestStepIdsQueryParametersCallback(List<Long> testStepIds) {
            this.testStepIds = testStepIds;
        }

        @Override
        public void setQueryParameters(Query query) {
            query.setParameterList("testStepIds", this.testStepIds, (Type)LongType.INSTANCE);
        }
    }
}

