/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.type.LongType;
import org.hibernate.type.Type;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.service.clipboard.model.ClipboardPayload;
import org.squashtest.tm.service.internal.copier.ChildEntityDtoResult;
import org.squashtest.tm.service.internal.copier.ChildEntityDtoResultTransformer;
import org.squashtest.tm.service.internal.repository.EntityDao;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateDao;

public class HibernateEntityDao<ENTITY_TYPE>
extends HibernateDao<ENTITY_TYPE>
implements EntityDao<ENTITY_TYPE> {
    @Override
    public ENTITY_TYPE findById(long id) {
        return this.getEntity(id);
    }

    @Override
    public List<ENTITY_TYPE> findAll() {
        return this.entityManager.createQuery("from " + this.entityType.getName()).getResultList();
    }

    @Override
    public List<ENTITY_TYPE> findAllByIds(Collection<Long> ids) {
        if (Objects.isNull(ids)) {
            throw new IllegalArgumentException("The list can't be null.");
        }
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        return this.entityManager.createQuery("from %s where %s in :ids".formatted(this.entityType.getName(), this.getIdPropertyName())).setParameter("ids", ids).getResultList();
    }

    public String getIdPropertyName() {
        return "id";
    }

    protected List<Long> findDescendantIds(List<Long> params, String sql) {
        if (!params.isEmpty()) {
            List list;
            Session session = this.currentSession();
            ArrayList<Long> result = new ArrayList<Long>();
            result.addAll(params);
            List<Long> local = params;
            do {
                NativeQuery sqlQuery = session.createNativeQuery(sql);
                sqlQuery.setParameterList("list", local, (Type)new LongType());
                list = sqlQuery.list();
                if (list.isEmpty()) continue;
                local.clear();
                this.addingDescendantIds(local, result, list);
            } while (!list.isEmpty());
            if (result.isEmpty()) {
                return null;
            }
            return result;
        }
        return Collections.emptyList();
    }

    private void addingDescendantIds(List<Long> local, List<Long> result, List<BigInteger> list) {
        for (BigInteger bint : list) {
            local.add(bint.longValue());
            result.add(bint.longValue());
        }
    }

    public ChildEntityDtoResult getChildEntityDtoForPaste(String query, Collection<Long> ids, int maxResult, int offset, ClipboardPayload clipboardPayload, BiConsumer<EntityType, List<Long>> additionalContent) {
        ChildEntityDtoResultTransformer childEntityDtoResultTransformer = new ChildEntityDtoResultTransformer(clipboardPayload);
        List childEntityDtos = ((Query)this.entityManager.createQuery(query).setParameter("ids", ids).setMaxResults(maxResult).setFirstResult(offset).setHint("hibernate.query.passDistinctThrough", (Object)false).unwrap(Query.class)).setResultTransformer((ResultTransformer)childEntityDtoResultTransformer).getResultList();
        childEntityDtos.stream().flatMap(c -> c.getChildren().stream()).collect(Collectors.groupingBy(treeNode -> EntityType.fromSimpleName((String)treeNode.getClass().getSimpleName()), Collectors.mapping(Identified::getId, Collectors.toList()))).forEach(additionalContent);
        return new ChildEntityDtoResult(childEntityDtos, maxResult == childEntityDtoResultTransformer.getEntitiesCount());
    }
}

