/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import org.hibernate.query.NativeQuery;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.type.LongType;
import org.hibernate.type.Type;
import org.jooq.CommonTableExpression;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.core.foundation.lang.PathUtils;
import org.squashtest.tm.domain.campaign.CampaignLibraryNode;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.repository.EntityDao;
import org.squashtest.tm.service.internal.repository.LibraryNodeDao;
import org.squashtest.tm.service.internal.repository.ProjectDao;
import org.squashtest.tm.service.internal.repository.SprintGroupDao;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateEntityDao;
import org.squashtest.tm.service.internal.repository.hibernate.SqLIdResultTransformer;

@Repository(value="squashtest.tm.repository.CampaignLibraryNodeDao")
public class HibernateCampaignLibraryNodeDao
extends HibernateEntityDao<CampaignLibraryNode>
implements LibraryNodeDao<CampaignLibraryNode>,
EntityDao<CampaignLibraryNode> {
    private static final String ID = "ID";
    private static final String PATH = "PATH";
    private static final String PATH_CTE = "PATH_CTE";
    @Inject
    private DSLContext dslContext;
    @Inject
    private SprintGroupDao sprintGroupDao;
    @Inject
    private ProjectDao projectDao;

    @Override
    public List<String> getParentsName(long entityId) {
        NativeQuery query = this.currentSession().createNativeQuery("select cln.name  from CAMPAIGN_LIBRARY_NODE cln inner join CLN_RELATIONSHIP_CLOSURE clos on clos.ancestor_id = cln.cln_id where clos.descendant_id = :nodeId order by clos.depth desc");
        query.setParameter("nodeId", (Object)entityId, (Type)LongType.INSTANCE);
        return query.list();
    }

    @Override
    public List<Long> getParentsIds(long entityId) {
        NativeQuery query = this.currentSession().createNativeQuery("select cln.cln_id  from CAMPAIGN_LIBRARY_NODE cln inner join CLN_RELATIONSHIP_CLOSURE clos on clos.ancestor_id = cln.cln_id where clos.descendant_id = :nodeId order by clos.depth desc");
        query.setResultTransformer((ResultTransformer)new SqLIdResultTransformer());
        query.setParameter("nodeId", (Object)entityId, (Type)LongType.INSTANCE);
        return query.list();
    }

    @Override
    public List<Long> findNodeIdsByPath(List<String> paths) {
        String fullPath = paths.get(paths.size() - 1);
        List<String> splits = Arrays.asList(PathUtils.splitPath((String)fullPath));
        List effectiveSplits = PathUtils.unescapeSlashes(splits);
        if (effectiveSplits.size() < 2) {
            return new ArrayList<Long>();
        }
        Long projectId = this.projectDao.findIdByName((String)effectiveSplits.get(0));
        String rootFolderName = (String)effectiveSplits.get(1);
        if (effectiveSplits.size() == 2) {
            Long existingId = this.existingNodeIdOrNull(projectId, rootFolderName);
            return Objects.isNull(existingId) ? new ArrayList() : Collections.singletonList(existingId);
        }
        String fullPathWithoutProjectName = PathUtils.getPathWithoutProject((List)effectiveSplits);
        return this.getChildren(projectId, rootFolderName, fullPathWithoutProjectName);
    }

    @Override
    public Long findNodeIdByPath(String path) {
        List effectiveSplits = PathUtils.getSplitPathWithoutProjectNameFromAPath((String)path);
        if (effectiveSplits.size() < 2) {
            return null;
        }
        if (effectiveSplits.size() == 2) {
            Long projectId = this.projectDao.findIdByName((String)effectiveSplits.get(0));
            return this.existingNodeIdOrNull(projectId, (String)effectiveSplits.get(1));
        }
        List<Long> children = this.findNodeIdsByPath(Collections.singletonList(path));
        return effectiveSplits.size() == children.size() ? children.get(children.size() - 1) : null;
    }

    private Long existingNodeIdOrNull(Long projectId, String rootFolderName) {
        return this.sprintGroupDao.findRootNodeIdByProjectIdAndName(projectId, rootFolderName);
    }

    private List<Long> getChildren(Long projectId, String rootFolderName, String fullPathWithoutProjectName) {
        Field exactPathToCheckInCte = DSL.concat((Field[])new Field[]{DSL.field((Name)DSL.name((String[])new String[]{PATH_CTE, PATH})), DSL.val((String)"/"), Tables.CAMPAIGN_LIBRARY_NODE.NAME});
        Field longerPathToCheckInCte = DSL.concat((Field[])new Field[]{exactPathToCheckInCte, DSL.val((String)"/%")});
        CommonTableExpression cte = DSL.name((String)PATH_CTE).fields(ID, PATH).as((ResultQuery)this.dslContext.select((SelectField)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.NAME.cast(String.class)).from((TableLike)Tables.PROJECT).join((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID)).join((TableLike)Tables.CAMPAIGN_LIBRARY_CONTENT).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_CONTENT.CONTENT_ID)).where(Tables.PROJECT.PROJECT_ID.eq((Object)projectId)).and(Tables.CAMPAIGN_LIBRARY_NODE.NAME.eq((Object)rootFolderName)).union((Select)DSL.select((SelectField)Tables.CLN_RELATIONSHIP.DESCENDANT_ID, (SelectField)DSL.field((Name)DSL.name((String[])new String[]{PATH_CTE, PATH})).concat(new String[]{"/"}).concat(new Field[]{Tables.CAMPAIGN_LIBRARY_NODE.NAME}).cast(String.class)).from(DSL.name((String)PATH_CTE)).join((TableLike)Tables.CLN_RELATIONSHIP).on(DSL.field((Name)DSL.name((String[])new String[]{PATH_CTE, ID})).eq((Object)Tables.CLN_RELATIONSHIP.ANCESTOR_ID)).join((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.CLN_RELATIONSHIP.DESCENDANT_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).where((Condition)DSL.val((String)fullPathWithoutProjectName).like(exactPathToCheckInCte)).or((Condition)DSL.val((String)fullPathWithoutProjectName).like(longerPathToCheckInCte))));
        return this.dslContext.withRecursive(new CommonTableExpression[]{cte}).select((SelectField)cte.field(ID)).from((TableLike)cte).fetchInto(Long.class);
    }
}

