/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.hibernate.Hibernate;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.WindowSpecification;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.core.foundation.collection.Paging;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.execution.ExecutionStatusReport;
import org.squashtest.tm.domain.testautomation.TestAutomationServerKind;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.CampaignIteration;
import org.squashtest.tm.jooq.domain.tables.CampaignLibraryNode;
import org.squashtest.tm.jooq.domain.tables.ExecutionExecutionSteps;
import org.squashtest.tm.jooq.domain.tables.ExecutionStep;
import org.squashtest.tm.jooq.domain.tables.ItemTestPlanExecution;
import org.squashtest.tm.jooq.domain.tables.ItemTestPlanList;
import org.squashtest.tm.jooq.domain.tables.IterationTestPlanItem;
import org.squashtest.tm.jooq.domain.tables.Project;
import org.squashtest.tm.jooq.domain.tables.TestAutomationServer;
import org.squashtest.tm.service.internal.dto.AutomatedExecutionUpdateData;
import org.squashtest.tm.service.internal.dto.ExecutionSummaryDto;
import org.squashtest.tm.service.internal.repository.CustomExecutionDao;
import org.squashtest.tm.service.internal.repository.hibernate.loaders.EntityGraphQueryBuilder;

@Repository
public class ExecutionDaoImpl
implements CustomExecutionDao {
    private static final String EXECUTION_COUNT_STATUS = "Execution.countStatus";
    private static final String STATUS = "status";
    @PersistenceContext
    private EntityManager entityManager;
    @Inject
    private DSLContext dsl;

    @Override
    public Execution findAndInit(long executionId) {
        Execution execution = this.findById(executionId);
        Hibernate.initialize((Object)execution.getReferencedTestCase());
        Hibernate.initialize((Object)execution.getSteps());
        return execution;
    }

    private Execution findById(long executionId) {
        return (Execution)this.entityManager.getReference(Execution.class, (Object)executionId);
    }

    @Override
    public ExecutionStatusReport getStatusReport(long executionId) {
        ExecutionStatusReport report = new ExecutionStatusReport();
        ExecutionStatus[] executionStatusArray = ExecutionStatus.values();
        int n = executionStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExecutionStatus status;
            ExecutionStatus fStatus = status = executionStatusArray[n2];
            Long lResult = (Long)this.entityManager.createNamedQuery(EXECUTION_COUNT_STATUS).setParameter("execId", (Object)executionId).setParameter(STATUS, (Object)fStatus).getSingleResult();
            report.set(status, lResult.intValue());
            ++n2;
        }
        return report;
    }

    @Override
    public List<org.squashtest.tm.domain.execution.ExecutionStep> findStepsFiltered(Long executionId, Paging filter) {
        Execution execution = this.findById(executionId);
        int listSize = execution.getSteps().size();
        int startIndex = filter.getFirstItemIndex();
        int lastIndex = filter.getFirstItemIndex() + filter.getPageSize();
        if (startIndex >= listSize) {
            return new LinkedList<org.squashtest.tm.domain.execution.ExecutionStep>();
        }
        if (lastIndex >= listSize) {
            lastIndex = listSize;
        }
        return execution.getSteps().subList(startIndex, lastIndex);
    }

    @Override
    public boolean projectUsesExecutionStatus(long projectId, ExecutionStatus executionStatus) {
        return this.hasExecStepWithStatus(projectId, executionStatus) || this.hasItemTestPlanWithStatus(projectId, executionStatus) || this.hasExecWithStatus(projectId, executionStatus);
    }

    private boolean hasExecStepWithStatus(long projectId, ExecutionStatus executionStatus) {
        return (Integer)this.dsl.selectCount().from((TableLike)ExecutionStep.EXECUTION_STEP).innerJoin((TableLike)ExecutionExecutionSteps.EXECUTION_EXECUTION_STEPS).on(ExecutionExecutionSteps.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ID.eq((Field)ExecutionStep.EXECUTION_STEP.EXECUTION_STEP_ID)).innerJoin((TableLike)ItemTestPlanExecution.ITEM_TEST_PLAN_EXECUTION).on(ItemTestPlanExecution.ITEM_TEST_PLAN_EXECUTION.EXECUTION_ID.eq((Field)ExecutionExecutionSteps.EXECUTION_EXECUTION_STEPS.EXECUTION_ID)).innerJoin((TableLike)ItemTestPlanList.ITEM_TEST_PLAN_LIST).on(ItemTestPlanExecution.ITEM_TEST_PLAN_EXECUTION.ITEM_TEST_PLAN_ID.eq((Field)ItemTestPlanList.ITEM_TEST_PLAN_LIST.ITEM_TEST_PLAN_ID)).innerJoin((TableLike)CampaignIteration.CAMPAIGN_ITERATION).on(CampaignIteration.CAMPAIGN_ITERATION.ITERATION_ID.eq((Field)ItemTestPlanList.ITEM_TEST_PLAN_LIST.ITERATION_ID)).innerJoin((TableLike)CampaignLibraryNode.CAMPAIGN_LIBRARY_NODE).on(CampaignIteration.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Field)CampaignLibraryNode.CAMPAIGN_LIBRARY_NODE.CLN_ID)).where(ExecutionStep.EXECUTION_STEP.EXECUTION_STATUS.eq((Object)executionStatus.name())).and(CampaignLibraryNode.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).fetchOneInto(Integer.TYPE) > 0;
    }

    private boolean hasExecWithStatus(long projectId, ExecutionStatus executionStatus) {
        return (Integer)this.dsl.selectCount().from((TableLike)org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION).innerJoin((TableLike)ItemTestPlanExecution.ITEM_TEST_PLAN_EXECUTION).on(ItemTestPlanExecution.ITEM_TEST_PLAN_EXECUTION.EXECUTION_ID.eq((Field)org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION.EXECUTION_ID)).innerJoin((TableLike)ItemTestPlanList.ITEM_TEST_PLAN_LIST).on(ItemTestPlanExecution.ITEM_TEST_PLAN_EXECUTION.ITEM_TEST_PLAN_ID.eq((Field)ItemTestPlanList.ITEM_TEST_PLAN_LIST.ITEM_TEST_PLAN_ID)).innerJoin((TableLike)CampaignIteration.CAMPAIGN_ITERATION).on(CampaignIteration.CAMPAIGN_ITERATION.ITERATION_ID.eq((Field)ItemTestPlanList.ITEM_TEST_PLAN_LIST.ITERATION_ID)).innerJoin((TableLike)CampaignLibraryNode.CAMPAIGN_LIBRARY_NODE).on(CampaignIteration.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Field)CampaignLibraryNode.CAMPAIGN_LIBRARY_NODE.CLN_ID)).where(org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION.EXECUTION_STATUS.eq((Object)executionStatus.name())).and(CampaignLibraryNode.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).fetchOneInto(Integer.TYPE) > 0;
    }

    private boolean hasItemTestPlanWithStatus(long projectId, ExecutionStatus executionStatus) {
        return (Integer)this.dsl.selectCount().from((TableLike)IterationTestPlanItem.ITERATION_TEST_PLAN_ITEM).innerJoin((TableLike)ItemTestPlanList.ITEM_TEST_PLAN_LIST).on(ItemTestPlanList.ITEM_TEST_PLAN_LIST.ITEM_TEST_PLAN_ID.eq((Field)IterationTestPlanItem.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID)).innerJoin((TableLike)CampaignIteration.CAMPAIGN_ITERATION).on(CampaignIteration.CAMPAIGN_ITERATION.ITERATION_ID.eq((Field)ItemTestPlanList.ITEM_TEST_PLAN_LIST.ITERATION_ID)).innerJoin((TableLike)CampaignLibraryNode.CAMPAIGN_LIBRARY_NODE).on(CampaignIteration.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Field)CampaignLibraryNode.CAMPAIGN_LIBRARY_NODE.CLN_ID)).where(IterationTestPlanItem.ITERATION_TEST_PLAN_ITEM.EXECUTION_STATUS.eq((Object)executionStatus.name())).and(CampaignLibraryNode.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).fetchOneInto(Integer.TYPE) > 0;
    }

    @Override
    public TestAutomationServerKind getTestAutomationServerKindByProjectId(Long projectId) {
        return (TestAutomationServerKind)this.dsl.select((SelectField)TestAutomationServer.TEST_AUTOMATION_SERVER.KIND).from((TableLike)TestAutomationServer.TEST_AUTOMATION_SERVER).innerJoin((TableLike)Project.PROJECT).on(Project.PROJECT.TA_SERVER_ID.eq((Field)TestAutomationServer.TEST_AUTOMATION_SERVER.SERVER_ID)).where(Project.PROJECT.PROJECT_ID.eq((Object)projectId)).fetchOneInto(TestAutomationServerKind.class);
    }

    @Override
    public Map<Long, List<ExecutionSummaryDto>> findIterationTestPlanItemLastExecStatuses(Collection<Long> itemTestPlanIds) {
        Table maxOrderTable = DSL.select((SelectField)ItemTestPlanExecution.ITEM_TEST_PLAN_EXECUTION.ITEM_TEST_PLAN_ID, (SelectField)DSL.max((Field)ItemTestPlanExecution.ITEM_TEST_PLAN_EXECUTION.EXECUTION_ORDER).as("max_order")).from((TableLike)ItemTestPlanExecution.ITEM_TEST_PLAN_EXECUTION).where(ItemTestPlanExecution.ITEM_TEST_PLAN_EXECUTION.ITEM_TEST_PLAN_ID.in(itemTestPlanIds)).groupBy(new GroupField[]{ItemTestPlanExecution.ITEM_TEST_PLAN_EXECUTION.ITEM_TEST_PLAN_ID}).asTable("max_order_table");
        Table partitionTable = DSL.select((SelectField)ItemTestPlanExecution.ITEM_TEST_PLAN_EXECUTION.ITEM_TEST_PLAN_ID, (SelectField)org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION.EXECUTION_ID, (SelectField)DSL.when((Condition)org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION.EXECUTION_STATUS.isNull(), (Field)DSL.val((Object)ExecutionStatus.READY, String.class)).otherwise((Field)org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION.EXECUTION_STATUS).as("EXECUTION_STATUS"), (SelectField)org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION.LAST_EXECUTED_ON, (SelectField)DSL.rowNumber().over((WindowSpecification)DSL.partitionBy((Field[])new Field[]{ItemTestPlanExecution.ITEM_TEST_PLAN_EXECUTION.ITEM_TEST_PLAN_ID}).orderBy(new OrderField[]{ItemTestPlanExecution.ITEM_TEST_PLAN_EXECUTION.EXECUTION_ORDER.desc()})).as("ROW_NUMBER")).from((TableLike)org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION).innerJoin((TableLike)ItemTestPlanExecution.ITEM_TEST_PLAN_EXECUTION).on(ItemTestPlanExecution.ITEM_TEST_PLAN_EXECUTION.EXECUTION_ID.eq((Field)org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION.EXECUTION_ID)).innerJoin((TableLike)maxOrderTable).on(ItemTestPlanExecution.ITEM_TEST_PLAN_EXECUTION.ITEM_TEST_PLAN_ID.eq(maxOrderTable.field("ITEM_TEST_PLAN_ID", Long.class)).and(ItemTestPlanExecution.ITEM_TEST_PLAN_EXECUTION.EXECUTION_ORDER.ne(maxOrderTable.field("max_order", Integer.class)))).asTable();
        return this.dsl.selectFrom((TableLike)partitionTable).where(partitionTable.field("ROW_NUMBER", Integer.class).le((Object)5)).fetchStream().collect(Collectors.groupingBy(r -> (Long)r.get("ITEM_TEST_PLAN_ID", Long.class), Collectors.mapping(r -> new ExecutionSummaryDto((Long)r.get("EXECUTION_ID", Long.class), (String)r.get("EXECUTION_STATUS", String.class), (Date)r.get("LAST_EXECUTED_ON", Date.class)), Collectors.toList())));
    }

    @Override
    public List<ExecutionSummaryDto> findSprintTestPlanItemLastExecStatuses(Long testPlanItemId) {
        Integer maxOrder = (Integer)this.dsl.select((SelectField)DSL.max((Field)org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION.EXECUTION_ORDER)).from((TableLike)org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION).where(org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION.TEST_PLAN_ITEM_ID.eq((Object)testPlanItemId)).fetchOneInto(Integer.class);
        return this.dsl.select((SelectField)org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION.EXECUTION_ID, (SelectField)DSL.when((Condition)org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION.EXECUTION_STATUS.isNull(), (Field)DSL.val((Object)ExecutionStatus.READY, String.class)).otherwise((Field)org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION.EXECUTION_STATUS).as("EXECUTION_STATUS"), (SelectField)org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION.LAST_EXECUTED_ON).from((TableLike)org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION).where(org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION.TEST_PLAN_ITEM_ID.eq((Object)testPlanItemId).and(org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION.EXECUTION_ORDER.notEqual((Object)maxOrder))).orderBy((OrderField)org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION.EXECUTION_ORDER.desc()).limit((Number)5).fetchInto(ExecutionSummaryDto.class);
    }

    @Override
    public AutomatedExecutionUpdateData findAutomatedExecutionUpdateData(Long itemId, String suiteId) {
        return (AutomatedExecutionUpdateData)this.dsl.select((SelectField)org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION.EXECUTION_ID, (SelectField)Tables.AUTOMATED_EXECUTION_EXTENDER.EXTENDER_ID, (SelectField)org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION.ATTACHMENT_LIST_ID).from((TableLike)org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION).innerJoin((TableLike)ItemTestPlanExecution.ITEM_TEST_PLAN_EXECUTION).on(ItemTestPlanExecution.ITEM_TEST_PLAN_EXECUTION.EXECUTION_ID.eq((Field)org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION.EXECUTION_ID)).innerJoin((TableLike)Tables.AUTOMATED_EXECUTION_EXTENDER).on(Tables.AUTOMATED_EXECUTION_EXTENDER.MASTER_EXECUTION_ID.eq((Field)org.squashtest.tm.jooq.domain.tables.Execution.EXECUTION.EXECUTION_ID)).where(ItemTestPlanExecution.ITEM_TEST_PLAN_EXECUTION.ITEM_TEST_PLAN_ID.eq((Object)itemId).and(Tables.AUTOMATED_EXECUTION_EXTENDER.SUITE_ID.eq((Object)suiteId))).fetchOneInto(AutomatedExecutionUpdateData.class);
    }

    @Override
    public List<Long> findItpiIdsByExecutionIds(List<Long> executionIds) {
        return this.dsl.selectDistinct((SelectField)ItemTestPlanExecution.ITEM_TEST_PLAN_EXECUTION.ITEM_TEST_PLAN_ID).from((TableLike)ItemTestPlanExecution.ITEM_TEST_PLAN_EXECUTION).where(ItemTestPlanExecution.ITEM_TEST_PLAN_EXECUTION.EXECUTION_ID.in(executionIds)).fetchInto(Long.class);
    }

    @Override
    public List<Long> findAllIdsByAutomatedSuiteIds(List<String> automatedSuiteIds) {
        Query fetchQuery = this.entityManager.createNamedQuery("Execution.findAllIdsByAutomatedSuiteIds");
        fetchQuery.setParameter("automatedSuiteIds", automatedSuiteIds);
        return fetchQuery.getResultList();
    }

    @Override
    public List<org.squashtest.tm.domain.execution.ExecutionStep> findStepsForAllExecutions(Collection<Long> executionIds) {
        return new EntityGraphQueryBuilder<org.squashtest.tm.domain.execution.ExecutionStep>(this.entityManager, org.squashtest.tm.domain.execution.ExecutionStep.class, "select step from ExecutionStep step where step.execution.id in (:ids)").executeDistinctList(Map.of("ids", executionIds));
    }
}

