/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import java.util.List;
import javax.persistence.Query;
import org.hibernate.Session;
import org.hibernate.transform.Transformers;
import org.squashtest.tm.core.foundation.collection.Paging;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.CustomFieldBinding;
import org.squashtest.tm.service.internal.foundation.collection.JpaPagingUtils;
import org.squashtest.tm.service.internal.repository.CustomCustomFieldBindingDao;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateEntityDao;

public class CustomFieldBindingDaoImpl
extends HibernateEntityDao<CustomFieldBinding>
implements CustomCustomFieldBindingDao {
    @Override
    public List<CustomFieldBinding> findAllForProjectAndEntity(long projectId, BindableEntity boundEntity, Paging paging) {
        Query q = this.entityManager.createNamedQuery("CustomFieldBinding.findAllForProjectAndEntity");
        q.setParameter("projectId", (Object)projectId);
        q.setParameter("entityType", (Object)boundEntity);
        JpaPagingUtils.addPaging(q, paging);
        return q.getResultList();
    }

    @Override
    public boolean cufBindingAlreadyExists(long projectId, BindableEntity entity, long cufId) {
        Query q = this.entityManager.createNamedQuery("CustomFieldBinding.cufBindingAlreadyExists");
        q.setParameter("cufId", (Object)cufId);
        q.setParameter("boundEntity", (Object)entity);
        q.setParameter("projectId", (Object)projectId);
        Long numberOfLines = (Long)q.getSingleResult();
        return numberOfLines > 0L;
    }

    @Override
    public void removeCustomFieldBindings(List<Long> bindingIds) {
        if (!bindingIds.isEmpty()) {
            this.entityManager.createNamedQuery("CustomFieldBinding.removeCustomFieldBindings").setParameter("cfbIds", bindingIds).executeUpdate();
            List<NewBindingPosition> newPositions = this.recomputeBindingPositions();
            this.updateBindingPositions(newPositions);
        }
    }

    protected List<NewBindingPosition> recomputeBindingPositions() {
        return ((Session)this.entityManager.unwrap(Session.class)).getNamedQuery("CustomFieldBinding.recomputeBindingPositions").setResultTransformer(Transformers.aliasToBean(NewBindingPosition.class)).list();
    }

    protected void updateBindingPositions(List<NewBindingPosition> newPositions) {
        Query q = this.entityManager.createNamedQuery("CustomFielBinding.updateBindingPosition");
        for (NewBindingPosition newPos : newPositions) {
            if (!newPos.needsUpdate()) continue;
            q.setParameter("newPos", (Object)newPos.getNewPosition());
            q.setParameter("id", (Object)newPos.getBindingId());
            q.executeUpdate();
        }
    }

    public static class NewBindingPosition {
        private Long bindingId;
        private int formerPosition;
        private int newPosition;

        public Long getBindingId() {
            return this.bindingId;
        }

        public void setBindingId(Long bindingId) {
            this.bindingId = bindingId;
        }

        public int getFormerPosition() {
            return this.formerPosition;
        }

        public void setFormerPosition(int formerPosition) {
            this.formerPosition = formerPosition;
        }

        public int getNewPosition() {
            return this.newPosition;
        }

        public void setNewPosition(Long newPosition) {
            this.newPosition = newPosition.intValue();
        }

        public boolean needsUpdate() {
            return this.formerPosition != this.newPosition;
        }
    }
}

