/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import javax.inject.Inject;
import org.jooq.AggregateFilterStep;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.dto.DenormalizedEnvironmentTagDto;
import org.squashtest.tm.service.internal.repository.CustomDenormalizedEnvironmentTagDao;

@Repository
public class CustomDenormalizedEnvironmentTagDaoImpl
implements CustomDenormalizedEnvironmentTagDao {
    private static final String VALUE = "VALUE";
    @Inject
    DSLContext dslContext;

    @Override
    public DenormalizedEnvironmentTagDto getAllByExecutionId(Long executionId) {
        Condition containTags = DSL.count((Field)Tables.DENORMALIZED_ENVIRONMENT_TAG.VALUE).greaterThan((Object)0);
        Condition containTestTechnology = DSL.length((Field)Tables.AUTOMATED_EXECUTION_EXTENDER.TEST_TECHNOLOGY).greaterThan((Object)0);
        Condition containTagsOrTestTechnology = containTestTechnology.or(Tables.DENORMALIZED_ENVIRONMENT_TAG.VALUE.isNotNull());
        AggregateFilterStep aggregateTags = DSL.listAgg((Field)Tables.DENORMALIZED_ENVIRONMENT_TAG.VALUE, (String)", ").withinGroupOrderBy(new OrderField[]{Tables.DENORMALIZED_ENVIRONMENT_TAG.VALUE});
        Field withDenormalizedTags = DSL.when((Condition)containTestTechnology, (Field)aggregateTags.concat(new Field[]{DSL.val((String)", "), Tables.AUTOMATED_EXECUTION_EXTENDER.TEST_TECHNOLOGY})).otherwise((Field)aggregateTags);
        return (DenormalizedEnvironmentTagDto)this.dslContext.select((SelectField)DSL.when((Condition)containTags, (Field)withDenormalizedTags).otherwise((Field)Tables.AUTOMATED_EXECUTION_EXTENDER.TEST_TECHNOLOGY).as(VALUE)).from((TableLike)Tables.EXECUTION).innerJoin((TableLike)Tables.AUTOMATED_EXECUTION_EXTENDER).on(Tables.EXECUTION.EXECUTION_ID.eq((Field)Tables.AUTOMATED_EXECUTION_EXTENDER.MASTER_EXECUTION_ID)).leftJoin((TableLike)Tables.DENORMALIZED_ENVIRONMENT_TAG).on(Tables.DENORMALIZED_ENVIRONMENT_TAG.HOLDER_ID.eq((Field)Tables.AUTOMATED_EXECUTION_EXTENDER.EXTENDER_ID)).where(Tables.EXECUTION.EXECUTION_ID.eq((Object)executionId).and(containTagsOrTestTechnology)).groupBy(new GroupField[]{Tables.EXECUTION.EXECUTION_ID, Tables.AUTOMATED_EXECUTION_EXTENDER.EXTENDER_ID}).fetchOneInto(DenormalizedEnvironmentTagDto.class);
    }
}

