/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl.collectors;

import com.google.common.base.Strings;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.NodeReference;
import org.squashtest.tm.domain.NodeType;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.grid.DataRow;
import org.squashtest.tm.service.internal.repository.display.CustomFieldValueDisplayDao;
import org.squashtest.tm.service.internal.repository.display.MilestoneDisplayDao;
import org.squashtest.tm.service.internal.repository.display.RequirementVersionDisplayDao;
import org.squashtest.tm.service.internal.repository.display.TreeNodeCollector;
import org.squashtest.tm.service.internal.repository.display.impl.MilestoneDisplayDaoImpl;
import org.squashtest.tm.service.internal.repository.display.impl.collectors.AbstractTreeNodeCollector;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;

@Component
public class RequirementCollector
extends AbstractTreeNodeCollector
implements TreeNodeCollector {
    private static final String REQ_CATEGORY_LABEL = "REQ_CATEGORY_LABEL";
    private static final String REQ_CATEGORY_ICON = "REQ_CATEGORY_ICON";
    private static final String REQ_CATEGORY_TYPE = "REQ_CATEGORY_TYPE";
    private static final String HAS_DESCRIPTION = "HAS_DESCRIPTION";
    private static final String IS_SYNCHRONIZED = "IS_SYNCHRONIZED";
    private final RequirementVersionDisplayDao requirementVersionDisplayDao;

    public RequirementCollector(DSLContext dsl, CustomFieldValueDisplayDao customFieldValueDisplayDao, ActiveMilestoneHolder activeMilestoneHolder, MilestoneDisplayDao milestoneDisplayDao, RequirementVersionDisplayDao requirementVersionDisplayDao) {
        super(dsl, customFieldValueDisplayDao, activeMilestoneHolder, milestoneDisplayDao);
        this.requirementVersionDisplayDao = requirementVersionDisplayDao;
    }

    @Override
    protected Map<Long, DataRow> doCollect(List<Long> requirementIds) {
        Map<Long, Long> requirementVersionIdsByRequirement = this.requirementVersionDisplayDao.findCurrentRequirementVersions(requirementIds);
        Map<Long, DataRow> requirementRows = this.collectRequirementRows(requirementVersionIdsByRequirement);
        this.appendRequirementVersionsMilestones(requirementVersionIdsByRequirement, requirementRows);
        return requirementRows;
    }

    private Map<Long, DataRow> collectRequirementRows(Map<Long, Long> requirementVersionIdsByRequirement) {
        return this.dsl.select((SelectField)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID, (SelectField)Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID.as("projectId"), (SelectField)Tables.RESOURCE.NAME.as("NAME"), (SelectField)DSL.field((Condition)DSL.nvl((Field)DSL.length((Field)Tables.RESOURCE.DESCRIPTION), (Object)0).gt((Object)0)).as(HAS_DESCRIPTION), (SelectField)Tables.REQUIREMENT_VERSION.REFERENCE, (SelectField)Tables.REQUIREMENT_VERSION.CRITICALITY, (SelectField)Tables.REQUIREMENT_VERSION.REQUIREMENT_STATUS, (SelectField)Tables.INFO_LIST_ITEM.ICON_NAME.as(REQ_CATEGORY_ICON), (SelectField)Tables.INFO_LIST_ITEM.LABEL.as(REQ_CATEGORY_LABEL), (SelectField)Tables.INFO_LIST_ITEM.ITEM_TYPE.as(REQ_CATEGORY_TYPE), (SelectField)DSL.count((Field)Tables.RLN_RELATIONSHIP.ANCESTOR_ID).as("CHILD_COUNT"), (SelectField)DSL.countDistinct((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID).as("COVERAGE_COUNT"), (SelectField)DSL.field((Condition)Tables.REQUIREMENT_SYNC_EXTENDER.REQ_SYNC_ID.isNotNull()).as(IS_SYNCHRONIZED), (SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_PERIMETER_STATUS, (SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID).from((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).leftJoin((TableLike)Tables.RLN_RELATIONSHIP).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Field)Tables.RLN_RELATIONSHIP.ANCESTOR_ID)).innerJoin((TableLike)Tables.REQUIREMENT).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Field)Tables.REQUIREMENT.RLN_ID)).innerJoin((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.eq((Field)Tables.REQUIREMENT.RLN_ID)).innerJoin((TableLike)Tables.RESOURCE).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.RESOURCE.RES_ID)).innerJoin((TableLike)Tables.INFO_LIST_ITEM).on(Tables.REQUIREMENT_VERSION.CATEGORY.eq((Field)Tables.INFO_LIST_ITEM.ITEM_ID)).leftJoin((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID)).leftJoin((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).on(Tables.REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID)).where(Tables.REQUIREMENT_VERSION.RES_ID.in(requirementVersionIdsByRequirement.values())).groupBy(new GroupField[]{Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID, Tables.RESOURCE.RES_ID, Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID, Tables.RLN_RELATIONSHIP.ANCESTOR_ID, Tables.REQUIREMENT_VERSION.RES_ID, Tables.INFO_LIST_ITEM.ITEM_ID, Tables.REQUIREMENT_SYNC_EXTENDER.REQ_SYNC_ID}).fetch().stream().collect(Collectors.toMap(tuple -> (Long)tuple.get((Field)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID), tuple -> {
            DataRow dataRow = new DataRow();
            dataRow.setId(new NodeReference(NodeType.REQUIREMENT, (Long)tuple.get((Field)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID)).toNodeId());
            dataRow.setProjectId((Long)tuple.get("projectId", Long.class));
            dataRow.setState((Integer)tuple.get("CHILD_COUNT", Integer.class) > 0 ? DataRow.State.closed : DataRow.State.leaf);
            dataRow.setData(tuple.intoMap());
            if (!Strings.isNullOrEmpty((String)((String)tuple.get((Field)Tables.REQUIREMENT_VERSION.REFERENCE, String.class)))) {
                dataRow.getData().replace("NAME", String.valueOf((String)tuple.get((Field)Tables.REQUIREMENT_VERSION.REFERENCE)) + " - " + (String)tuple.get((Field)Tables.RESOURCE.NAME));
            }
            return dataRow;
        }));
    }

    private void appendRequirementVersionsMilestones(Map<Long, Long> requirementVersionIdsByRequirement, Map<Long, DataRow> requirementRows) {
        Optional<Milestone> activeMilestone = this.activeMilestoneHolder.getActiveMilestone();
        if (activeMilestone.isPresent()) {
            MilestoneDisplayDaoImpl.RequirementVersionMilestones milestonesByRequirementVersionId = this.milestoneDisplayDao.findMilestonesByRequirementVersionId(new HashSet<Long>(requirementVersionIdsByRequirement.values()));
            requirementRows.forEach((requirementId, dataRow) -> {
                List<Long> directlyBoundMilestone = milestonesByRequirementVersionId.getDirectlyBoundMilestone((Long)requirementVersionIdsByRequirement.get(requirementId));
                dataRow.addData("MILESTONES", directlyBoundMilestone);
                boolean directlyBound = directlyBoundMilestone.contains(((Milestone)activeMilestone.get()).getId());
                dataRow.addData("DIRECT_MILESTONE_BIND", directlyBound);
                List<Long> indirectlyBoundMilestone = milestonesByRequirementVersionId.getIndirectlyBoundMilestone((Long)requirementVersionIdsByRequirement.get(requirementId));
                boolean indirectlyBound = !directlyBound && indirectlyBoundMilestone.contains(((Milestone)activeMilestone.get()).getId());
                dataRow.addData("INDIRECT_MILESTONE_BIND", indirectlyBound);
                dataRow.addData("ALL_MILESTONES", milestonesByRequirementVersionId.getAllBoundMilestone((Long)requirementVersionIdsByRequirement.get(requirementId)));
            });
        }
    }

    @Override
    public NodeType getHandledEntityType() {
        return NodeType.REQUIREMENT;
    }
}

