/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl;

import java.util.List;
import java.util.Map;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.NamedReference;
import org.squashtest.tm.domain.campaign.SprintStatus;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.dto.sprint.SprintDto;
import org.squashtest.tm.service.internal.repository.display.SprintDisplayDao;

@Repository
public class SprintDisplayDaoImpl
implements SprintDisplayDao {
    private final DSLContext dsl;

    public SprintDisplayDaoImpl(DSLContext dsl) {
        this.dsl = dsl;
    }

    @Override
    public SprintDto getSprintDtoById(long sprintId) {
        return (SprintDto)this.dsl.select((SelectField)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.as("ID"), (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.ATTACHMENT_LIST_ID, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.DESCRIPTION, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.NAME, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.CREATED_BY, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.CREATED_ON, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.LAST_MODIFIED_BY, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.LAST_MODIFIED_ON, (SelectField)Tables.REMOTE_SYNCHRONISATION.KIND.as("synchronisationKind"), (SelectField)Tables.PROJECT.CL_ID.as("CAMPAIGN_LIBRARY_ID"), (SelectField)Tables.SPRINT.REFERENCE, (SelectField)Tables.SPRINT.STATUS, (SelectField)Tables.SPRINT.REMOTE_STATE, (SelectField)Tables.SPRINT.START_DATE, (SelectField)Tables.SPRINT.END_DATE).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).innerJoin((TableLike)Tables.PROJECT).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID)).innerJoin((TableLike)Tables.SPRINT).on(Tables.SPRINT.CLN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).leftJoin((TableLike)Tables.REMOTE_SYNCHRONISATION).on(Tables.REMOTE_SYNCHRONISATION.REMOTE_SYNCHRONISATION_ID.eq((Field)Tables.SPRINT.REMOTE_SYNCHRONISATION_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Object)sprintId)).fetchOneInto(SprintDto.class);
    }

    @Override
    public SprintStatus getSprintStatusByTestPlanItemId(long testPlanItemId) {
        return (SprintStatus)this.dsl.select((SelectField)Tables.SPRINT.STATUS).from((TableLike)Tables.SPRINT).innerJoin((TableLike)Tables.SPRINT_REQ_VERSION).on(Tables.SPRINT.CLN_ID.eq((Field)Tables.SPRINT_REQ_VERSION.SPRINT_ID)).innerJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.SPRINT_REQ_VERSION.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID)).where(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq((Object)testPlanItemId)).fetchOneInto(SprintStatus.class);
    }

    @Override
    public SprintStatus getSprintStatusByExecutionId(long executionId) {
        return (SprintStatus)this.dsl.select((SelectField)Tables.SPRINT.STATUS).from((TableLike)Tables.SPRINT).innerJoin((TableLike)Tables.SPRINT_REQ_VERSION).on(Tables.SPRINT.CLN_ID.eq((Field)Tables.SPRINT_REQ_VERSION.SPRINT_ID)).innerJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.SPRINT_REQ_VERSION.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID)).innerJoin((TableLike)Tables.EXECUTION).on(Tables.EXECUTION.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).where(Tables.EXECUTION.EXECUTION_ID.eq((Object)executionId)).fetchOneInto(SprintStatus.class);
    }

    @Override
    public SprintStatus getSprintStatusByExecutionStepId(Long executionStepId) {
        return (SprintStatus)this.dsl.select((SelectField)Tables.SPRINT.STATUS).from((TableLike)Tables.SPRINT).innerJoin((TableLike)Tables.SPRINT_REQ_VERSION).on(Tables.SPRINT.CLN_ID.eq((Field)Tables.SPRINT_REQ_VERSION.SPRINT_ID)).innerJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.SPRINT_REQ_VERSION.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID)).innerJoin((TableLike)Tables.EXECUTION).on(Tables.EXECUTION.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).innerJoin((TableLike)Tables.EXECUTION_EXECUTION_STEPS).on(Tables.EXECUTION.EXECUTION_ID.eq((Field)Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_ID)).where(Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ID.eq((Object)executionStepId)).fetchOneInto(SprintStatus.class);
    }

    @Override
    public Map<Long, List<Long>> findExecutionIdsBySprintIds(List<Long> sprintIds) {
        return this.dsl.select((SelectField)Tables.SPRINT_REQ_VERSION.SPRINT_ID, (SelectField)Tables.EXECUTION.EXECUTION_ID).from((TableLike)Tables.EXECUTION).leftJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.EXECUTION.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).leftJoin((TableLike)Tables.SPRINT_REQ_VERSION).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.SPRINT_REQ_VERSION.TEST_PLAN_ID)).where(Tables.SPRINT_REQ_VERSION.SPRINT_ID.in(sprintIds)).fetchGroups((Field)Tables.SPRINT_REQ_VERSION.SPRINT_ID, (Field)Tables.EXECUTION.EXECUTION_ID);
    }

    @Override
    public List<NamedReference> findNamedReferences(List<Long> clnIds) {
        return this.dsl.select((SelectField)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.as("ID"), (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.NAME).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).join((TableLike)Tables.SPRINT).on(Tables.SPRINT.CLN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.in(clnIds)).fetchInto(NamedReference.class);
    }

    @Override
    public int countTestPlanItems(long sprintId, String userToRestrictTo) {
        Integer count = (Integer)this.dsl.selectCount().from((TableLike)Tables.TEST_PLAN_ITEM).innerJoin((TableLike)Tables.SPRINT_REQ_VERSION).on(Tables.SPRINT_REQ_VERSION.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID)).innerJoin((TableLike)Tables.SPRINT).on(Tables.SPRINT.CLN_ID.eq((Field)Tables.SPRINT_REQ_VERSION.SPRINT_ID)).leftJoin((TableLike)Tables.CORE_USER).on(Tables.CORE_USER.PARTY_ID.eq((Field)Tables.TEST_PLAN_ITEM.ASSIGNEE_ID)).leftJoin((TableLike)Tables.EXPLORATORY_SESSION_OVERVIEW).on(Tables.EXPLORATORY_SESSION_OVERVIEW.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).where(this.deduceCondition(userToRestrictTo, sprintId)).fetchOneInto(Integer.TYPE);
        return count != null ? count : 0;
    }

    @Override
    public SprintStatus getSprintStatusBySprintReqVersionId(long sprintReqVersionId) {
        return (SprintStatus)this.dsl.select((SelectField)Tables.SPRINT.STATUS).from((TableLike)Tables.SPRINT).innerJoin((TableLike)Tables.SPRINT_REQ_VERSION).on(Tables.SPRINT.CLN_ID.eq((Field)Tables.SPRINT_REQ_VERSION.SPRINT_ID)).where(Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID.eq((Object)sprintReqVersionId)).fetchOneInto(SprintStatus.class);
    }

    @Override
    public SprintStatus getSprintStatusBySessionOverviewId(long overviewId) {
        return (SprintStatus)this.dsl.select((SelectField)Tables.SPRINT.STATUS).from((TableLike)Tables.SPRINT).innerJoin((TableLike)Tables.SPRINT_REQ_VERSION).on(Tables.SPRINT_REQ_VERSION.SPRINT_ID.eq((Field)Tables.SPRINT.CLN_ID)).innerJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.SPRINT_REQ_VERSION.TEST_PLAN_ID)).innerJoin((TableLike)Tables.EXPLORATORY_SESSION_OVERVIEW).on(Tables.EXPLORATORY_SESSION_OVERVIEW.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).where(Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID.eq((Object)overviewId)).fetchOneInto(SprintStatus.class);
    }

    private Condition deduceCondition(String userToRestrictTo, long sprintId) {
        Condition condition = Tables.SPRINT.CLN_ID.eq((Object)sprintId);
        if (userToRestrictTo == null) {
            return condition;
        }
        return condition.and(Tables.CORE_USER.LOGIN.eq((Object)userToRestrictTo).or(Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID.isNotNull()));
    }
}

