/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.dto.AttachmentDto;
import org.squashtest.tm.service.internal.display.dto.AttachmentListDto;
import org.squashtest.tm.service.internal.repository.display.AttachmentDisplayDao;

@Repository
public class AttachmentDisplayDaoImpl
implements AttachmentDisplayDao {
    @Inject
    private DSLContext dsl;

    @Override
    public AttachmentListDto findAttachmentListById(long attachmentListId) {
        Set<AttachmentListDto> attachmentLists = this.findAttachmentListByIds(Collections.singleton(attachmentListId));
        return new ArrayList<AttachmentListDto>(attachmentLists).get(0);
    }

    @Override
    public Set<AttachmentListDto> findAttachmentListByIds(Set<Long> attachmentListIds) {
        Set<AttachmentListDto> attachmentLists = this.dsl.select((SelectField)Tables.ATTACHMENT_LIST.ATTACHMENT_LIST_ID, (SelectField)Tables.ATTACHMENT.ATTACHMENT_ID.as("ID"), (SelectField)Tables.ATTACHMENT.NAME, (SelectField)Tables.ATTACHMENT.SIZE, (SelectField)Tables.ATTACHMENT.ADDED_ON, (SelectField)Tables.ATTACHMENT.LAST_MODIFIED_ON).from((TableLike)Tables.ATTACHMENT_LIST).leftJoin((TableLike)Tables.ATTACHMENT).on(Tables.ATTACHMENT.ATTACHMENT_LIST_ID.eq((Field)Tables.ATTACHMENT_LIST.ATTACHMENT_LIST_ID)).where(Tables.ATTACHMENT_LIST.ATTACHMENT_LIST_ID.in(attachmentListIds)).fetch().intoGroups((Field)Tables.ATTACHMENT_LIST.ATTACHMENT_LIST_ID, AttachmentDto.class).entrySet().stream().map(AttachmentListDto::fromMapEntry).collect(Collectors.toSet());
        Set ids = attachmentLists.stream().map(AttachmentListDto::getId).collect(Collectors.toSet());
        if (!ids.equals(attachmentListIds)) {
            String msg = String.format("Error. AttachmentListIds %s do not correspond to fetched attachment lists %s.", attachmentListIds.toString(), ids.toString());
            throw new IllegalArgumentException(msg);
        }
        return attachmentLists;
    }
}

