/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record3;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectUnionStep;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.domain.acl.AclClass;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.records.AclClassRecord;
import org.squashtest.tm.service.internal.repository.display.AclDisplayDao;

@Repository
public class AclDisplayDaoImpl
implements AclDisplayDao,
InitializingBean {
    private final DSLContext dsl;
    private List<AclClassReference> aclClass;

    public AclDisplayDaoImpl(DSLContext dsl) {
        this.dsl = dsl;
    }

    @Override
    public Map<Long, Multimap<String, String>> findPermissions(List<Long> projectIds, List<Long> partyIds) {
        return this.craftRequest(projectIds, partyIds, this.aclClass).fetch().stream().collect(PermissionCollector.permissionCollector(projectIds));
    }

    @Override
    public Map<Long, Multimap<String, String>> findPermissionsForProject(List<Long> projectIds, List<Long> partyIds) {
        AclClassReference aclClassReference = this.aclClass.stream().filter(it -> it.aclClass.equals((Object)AclClass.PROJECT)).findFirst().orElseThrow(() -> new IllegalArgumentException("AclClass.PROJECT not found"));
        return this.craftRequest(projectIds, partyIds, Collections.singletonList(aclClassReference)).fetch().stream().collect(PermissionCollector.permissionCollector(projectIds));
    }

    private SelectUnionStep<Record3<Long, Integer, String>> craftRequest(List<Long> projectIds, List<Long> partyIds, List<AclClassReference> aclClassReferences) {
        ArrayDeque clauses = aclClassReferences.stream().map(aclClassReference -> this.craftSelectClause(projectIds, partyIds, (AclClassReference)((Object)aclClassReference))).collect(Collectors.toCollection(ArrayDeque::new));
        SelectUnionStep request = (SelectUnionStep)clauses.pop();
        while (Objects.nonNull(clauses.peek())) {
            request.unionAll((Select)clauses.pop());
        }
        return request;
    }

    public SelectUnionStep<Record3<Long, Integer, String>> craftSelectClause(List<Long> projectIds, List<Long> partyIds, AclClassReference aclClass) {
        return this.dsl.selectDistinct((SelectField)Tables.PROJECT.PROJECT_ID, (SelectField)Tables.ACL_GROUP_PERMISSION.PERMISSION_MASK, (SelectField)DSL.val((String)aclClass.getName()).as("ACL_CLASS")).from((TableLike)Tables.PROJECT).innerJoin((TableLike)Tables.ACL_OBJECT_IDENTITY).on(Tables.ACL_OBJECT_IDENTITY.IDENTITY.eq(aclClass.getIdentityColumn())).innerJoin((TableLike)Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY).on(Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.OBJECT_IDENTITY_ID.eq((Field)Tables.ACL_OBJECT_IDENTITY.ID)).innerJoin((TableLike)Tables.ACL_GROUP_PERMISSION).on(Tables.ACL_GROUP_PERMISSION.ACL_GROUP_ID.eq((Field)Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.ACL_GROUP_ID)).where(Tables.PROJECT.PROJECT_ID.in(projectIds).and(Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.PARTY_ID.in(partyIds)).and(Tables.ACL_OBJECT_IDENTITY.CLASS_ID.eq((Object)aclClass.getId()).and(Tables.ACL_GROUP_PERMISSION.CLASS_ID.eq((Object)aclClass.getId())))).orderBy((OrderField)Tables.PROJECT.PROJECT_ID, (OrderField)Tables.ACL_GROUP_PERMISSION.PERMISSION_MASK);
    }

    public void afterPropertiesSet() throws Exception {
        this.aclClass = this.dsl.select(new SelectFieldOrAsterisk[0]).from((TableLike)Tables.ACL_CLASS).fetch().into(AclClassReference.class);
        this.aclClass.forEach(aclClassReference -> {
            String classname = aclClassReference.getClassname();
            AclClass foundAclClass = AclClass.findByClassName((String)classname);
            aclClassReference.setAclClass(foundAclClass);
        });
    }

    private static class AclClassReference
    extends AclClassRecord {
        private AclClass aclClass;

        private AclClassReference() {
        }

        public void setAclClass(AclClass aclClass) {
            this.aclClass = aclClass;
        }

        public Field<Long> getIdentityColumn() {
            return this.aclClass.getIdentityColumn();
        }

        public String getSimpleClassName() {
            return this.aclClass.getSimpleClassName();
        }

        public String getName() {
            return this.aclClass.name();
        }
    }

    static class PermissionCollector
    implements Collector<Record3<Long, Integer, String>, Map<Long, Multimap<String, String>>, Map<Long, Multimap<String, String>>> {
        private final Map<Integer, Permissions> permissionByMask = EnumSet.allOf(Permissions.class).stream().collect(Collectors.toMap(Permissions::getMask, Function.identity()));
        private List<Long> expectedProjects;

        public PermissionCollector(List<Long> projectIds) {
            this.expectedProjects = projectIds;
        }

        @Override
        public Supplier<Map<Long, Multimap<String, String>>> supplier() {
            return () -> this.expectedProjects.stream().collect(Collectors.toMap(Function.identity(), id -> ArrayListMultimap.create()));
        }

        @Override
        public BiConsumer<Map<Long, Multimap<String, String>>, Record3<Long, Integer, String>> accumulator() {
            return (permissionMap, record) -> {
                Multimap projectPermissions = (Multimap)permissionMap.get(record.get((Field)Tables.PROJECT.PROJECT_ID));
                String aclClassName = (String)record.get("ACL_CLASS", String.class);
                Integer mask = (Integer)record.get((Field)Tables.ACL_GROUP_PERMISSION.PERMISSION_MASK);
                Permissions permission = this.permissionByMask.get(mask);
                if (Objects.isNull(permission)) {
                    throw new IllegalArgumentException("Unknown permission mask" + mask);
                }
                projectPermissions.put((Object)aclClassName, (Object)permission.name());
            };
        }

        @Override
        public BinaryOperator<Map<Long, Multimap<String, String>>> combiner() {
            return (longProjectPermissionsMap, longProjectPermissionsMap2) -> {
                throw new UnsupportedOperationException();
            };
        }

        @Override
        public Function<Map<Long, Multimap<String, String>>, Map<Long, Multimap<String, String>>> finisher() {
            return Function.identity();
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Collections.singleton(Collector.Characteristics.UNORDERED);
        }

        public static PermissionCollector permissionCollector(List<Long> projectsIds) {
            return new PermissionCollector(projectsIds);
        }
    }
}

