/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.report;

import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.hibernate.Session;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.customreport.CustomReportLibraryNode;
import org.squashtest.tm.domain.customreport.CustomReportTreeEntity;
import org.squashtest.tm.domain.report.ReportDefinition;
import org.squashtest.tm.service.customreport.CustomReportLibraryNodeService;
import org.squashtest.tm.service.internal.repository.ReportDefinitionDao;
import org.squashtest.tm.service.report.ReportModificationService;

@Transactional
@Service(value="squashtest.tm.service.ReportModificationService")
public class ReportModificationServiceImpl
implements ReportModificationService {
    @PersistenceContext
    private EntityManager em;
    @Inject
    private CustomReportLibraryNodeService customReportLibraryNodeService;
    @Inject
    private ReportDefinitionDao reportDefinitionDao;

    @Override
    public ReportDefinition findById(long id) {
        return (ReportDefinition)this.reportDefinitionDao.getReferenceById(id);
    }

    @Override
    public void update(ReportDefinition reportDef) {
        this.session().saveOrUpdate((Object)reportDef);
    }

    @Override
    @PreAuthorize(value="hasPermission(#definition.id, 'org.squashtest.tm.domain.report.ReportDefinition' ,'WRITE')  or hasRole('ROLE_ADMIN')")
    public void updateDefinition(ReportDefinition definition, ReportDefinition oldDef) {
        definition.setProject(oldDef.getProject());
        definition.setCreatedBy(oldDef.getCreatedBy());
        definition.setCreatedOn(oldDef.getCreatedOn());
        if (!definition.getName().equals(oldDef.getName())) {
            CustomReportLibraryNode node = this.customReportLibraryNodeService.findNodeFromEntity((CustomReportTreeEntity)oldDef);
            node.renameNode(definition.getName());
        }
        this.session().flush();
        this.session().clear();
        this.update(definition);
    }

    @Override
    public void save(ReportDefinition report) {
        this.session().save((Object)report);
    }

    private Session session() {
        return (Session)this.em.unwrap(Session.class);
    }
}

