/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.query;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.ReflectionUtils;
import org.squashtest.tm.domain.Level;
import org.squashtest.tm.domain.query.ColumnType;
import org.squashtest.tm.domain.query.QueryColumnPrototype;
import org.squashtest.tm.domain.query.QueryModel;
import org.squashtest.tm.domain.query.QueryProjectionColumn;
import org.squashtest.tm.domain.query.SpecializedEntityType;
import org.squashtest.tm.service.internal.query.InternalEntityType;

class EnumHelper {
    private Class<?> enumType;

    EnumHelper(QueryColumnPrototype column) {
        if (!column.getDataType().isAssignableToLevelEnum()) {
            throw new IllegalArgumentException("The EnumHelper can help only with Enums, but received column '" + column.getLabel() + "' of type '" + column.getDataType() + "'");
        }
        this.initialize(column);
    }

    <E extends Enum<E>> E valueOf(String value) {
        return (E)Enum.valueOf(this.enumType, value);
    }

    Map<Level, Integer> getLevelMap() {
        LinkedHashMap<Level, Integer> result = new LinkedHashMap<Level, Integer>();
        List<Level> sortedLevels = Arrays.stream(this.enumType.getEnumConstants()).map(e -> (Level)e).sorted(Comparator.comparing(Level::getLevel)).toList();
        for (Level l : sortedLevels) {
            result.put(l, l.getLevel());
        }
        return result;
    }

    private void initialize(QueryColumnPrototype proto) {
        ColumnType type = proto.getColumnType();
        switch (type) {
            case ATTRIBUTE: {
                this.processAttributeColumn(proto);
                break;
            }
            case CALCULATED: {
                this.processCalculatedColumn(proto);
                break;
            }
            default: {
                throw new IllegalArgumentException("The EnumHelper can process columns of type ATTRIBUTE or CALCULATED only, but received a " + type + " instead");
            }
        }
    }

    private void processAttributeColumn(QueryColumnPrototype proto) {
        Class<?> ownerType = this.findOwnerType(proto);
        Class<?> fieldClass = this.findFieldClass(ownerType, proto.getAttributeName());
        this.throwIfNotEnum(fieldClass);
        this.enumType = fieldClass;
    }

    private Class<?> findOwnerType(QueryColumnPrototype proto) {
        SpecializedEntityType specType = proto.getSpecializedType();
        InternalEntityType internalType = InternalEntityType.fromSpecializedType(specType);
        return internalType.getEntityClass();
    }

    private Class<?> findFieldClass(Class<?> ownerType, String attributePath) {
        List<String> splitPath = Arrays.asList(attributePath.split("\\."));
        Class<?> fieldClass = ownerType;
        for (String attrName : splitPath) {
            Field attrField = ReflectionUtils.findField(fieldClass, (String)attrName);
            if (attrField == null) {
                throw new RuntimeException("Could not find attribute '" + attrName + "' in class '" + fieldClass + "'");
            }
            fieldClass = attrField.getType();
        }
        return fieldClass;
    }

    private void throwIfNotEnum(Class<?> possibleEnum) {
        if (!possibleEnum.isEnum()) {
            throw new IllegalArgumentException("class '" + possibleEnum + "' is not an enum type");
        }
    }

    private void processCalculatedColumn(QueryColumnPrototype proto) {
        QueryModel subquery = proto.getSubQuery();
        List projections = subquery.getProjectionColumns();
        if (projections.isEmpty()) {
            throw new RuntimeException("Processing subquery of column " + proto.getLabel() + " which have no projection at all");
        }
        QueryProjectionColumn projection = (QueryProjectionColumn)projections.get(0);
        this.initialize(projection.getColumn());
    }
}

