/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.projectimporter.pivotimporter.parsers;

import com.fasterxml.jackson.core.JsonParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.squashtest.tm.service.internal.dto.projectimporter.AttachmentToImport;
import org.squashtest.tm.service.projectimporter.pivotimporter.PivotJsonParsingHelper;

public final class AttachmentParserHelper {
    private AttachmentParserHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static List<AttachmentToImport> parseAttachments(JsonParser jsonParser) throws IOException {
        ArrayList<AttachmentToImport> attachments = new ArrayList<AttachmentToImport>();
        while (PivotJsonParsingHelper.isNotTheEndOfParsedArray(jsonParser)) {
            if (!PivotJsonParsingHelper.isStartingToParseNewObject(jsonParser)) continue;
            AttachmentParserHelper.parseAttachment(jsonParser, attachments);
        }
        return attachments;
    }

    private static void parseAttachment(JsonParser jsonParser, List<AttachmentToImport> attachments) throws IOException {
        AttachmentToImport attachment = new AttachmentToImport();
        while (PivotJsonParsingHelper.isNotTheEndOfParsedObject(jsonParser)) {
            String fieldName = jsonParser.getCurrentName();
            jsonParser.nextToken();
            switch (fieldName) {
                case "zip_import_file_name": {
                    attachment.setZipImportFileName(jsonParser.getText());
                    break;
                }
                case "original_file_name": {
                    attachment.setOriginalFileName(jsonParser.getText());
                    break;
                }
            }
        }
        attachments.add(attachment);
    }
}

