/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.projectimporter.pivotimporter;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.stereotype.Service;
import org.squashtest.tm.aspect.validation.CleanHtmlAspect;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.projectimporter.PivotFormatImport;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.domain.testcase.CallTestStep;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.KeywordTestStep;
import org.squashtest.tm.domain.testcase.Parameter;
import org.squashtest.tm.domain.testcase.ParameterAssignationMode;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseKind;
import org.squashtest.tm.service.internal.dto.projectimporter.JsonImportFile;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotImportMetadata;
import org.squashtest.tm.service.internal.dto.projectimporter.ProjectIdsReferences;
import org.squashtest.tm.service.internal.dto.projectimporter.testcaseworkspace.ActionTestStepToImport;
import org.squashtest.tm.service.internal.dto.projectimporter.testcaseworkspace.CalledTestCaseStepToImport;
import org.squashtest.tm.service.internal.dto.projectimporter.testcaseworkspace.DatasetParamToImport;
import org.squashtest.tm.service.internal.dto.projectimporter.testcaseworkspace.DatasetToImport;
import org.squashtest.tm.service.internal.dto.projectimporter.testcaseworkspace.KeywordTestStepToImport;
import org.squashtest.tm.service.internal.dto.projectimporter.testcaseworkspace.TestCaseToImport;
import org.squashtest.tm.service.internal.projectimporter.pivotimporter.AttachmentHolderInfo;
import org.squashtest.tm.service.internal.projectimporter.pivotimporter.PivotFormatLoggerHelper;
import org.squashtest.tm.service.internal.projectimporter.pivotimporter.TestCasePivotImporterServiceImpl$AjcClosure1;
import org.squashtest.tm.service.internal.projectimporter.pivotimporter.TestCasePivotImporterServiceImpl$AjcClosure3;
import org.squashtest.tm.service.projectimporter.pivotimporter.AttachmentPivotImportService;
import org.squashtest.tm.service.projectimporter.pivotimporter.PivotJsonParsingHelper;
import org.squashtest.tm.service.projectimporter.pivotimporter.TestCasePivotImporterService;
import org.squashtest.tm.service.projectimporter.pivotimporter.parsers.TestCaseWorkspaceParser;
import org.squashtest.tm.service.requirement.VerifiedRequirementsManagerService;
import org.squashtest.tm.service.testcase.CallStepManagerService;
import org.squashtest.tm.service.testcase.DatasetModificationService;
import org.squashtest.tm.service.testcase.ParameterFinder;
import org.squashtest.tm.service.testcase.ParameterModificationService;
import org.squashtest.tm.service.testcase.TestCaseLibraryNavigationService;
import org.squashtest.tm.service.testcase.TestCaseModificationService;

@Service(value="TestCasePivotImporterService")
public class TestCasePivotImporterServiceImpl
implements TestCasePivotImporterService {
    private static final Logger LOGGER;
    private final TestCaseLibraryNavigationService testCaseLibraryNavigationService;
    private final TestCaseModificationService testCaseModificationService;
    private final VerifiedRequirementsManagerService verifiedRequirementsManagerService;
    private final ParameterModificationService parameterModificationService;
    private final DatasetModificationService datasetModificationService;
    private final CallStepManagerService callStepManager;
    private final ParameterFinder parameterFinder;
    private final TestCaseWorkspaceParser testCaseWorkspaceParser;
    private final AttachmentPivotImportService attachmentPivotImportService;
    @PersistenceContext
    private EntityManager entityManager;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        TestCasePivotImporterServiceImpl.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(TestCasePivotImporterService.class);
    }

    public TestCasePivotImporterServiceImpl(TestCaseLibraryNavigationService testCaseLibraryNavigationService, TestCaseModificationService testCaseModificationService, VerifiedRequirementsManagerService verifiedRequirementsManagerService, ParameterModificationService parameterModificationService, DatasetModificationService datasetModificationService, CallStepManagerService callStepManager, ParameterFinder parameterFinder, TestCaseWorkspaceParser testCaseWorkspaceParser, AttachmentPivotImportService attachmentPivotImportService) {
        this.testCaseLibraryNavigationService = testCaseLibraryNavigationService;
        this.testCaseModificationService = testCaseModificationService;
        this.verifiedRequirementsManagerService = verifiedRequirementsManagerService;
        this.parameterModificationService = parameterModificationService;
        this.datasetModificationService = datasetModificationService;
        this.callStepManager = callStepManager;
        this.parameterFinder = parameterFinder;
        this.testCaseWorkspaceParser = testCaseWorkspaceParser;
        this.attachmentPivotImportService = attachmentPivotImportService;
    }

    @Override
    public void importTestCasesFromZipArchive(ZipFile zipFile, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) throws IOException {
        PivotFormatLoggerHelper.logImportStartedForEntitiesKind(LOGGER, zipFile.getName(), "test cases", pivotFormatImport);
        ZipEntry entry = zipFile.getEntry(JsonImportFile.TEST_CASES.getFileName());
        if (Objects.nonNull(entry)) {
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (InputStream jsonInputStream = zipFile.getInputStream(entry);){
                    this.handleTestCasesFromJsonFile(jsonInputStream, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
                    PivotFormatLoggerHelper.logImportSuccessForEntitiesKind(LOGGER, "test cases", pivotFormatImport);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                PivotFormatLoggerHelper.logImportFailureForEntitiesKind(LOGGER, "test cases", pivotFormatImport);
                throw e;
            }
        }
    }

    private void handleTestCasesFromJsonFile(InputStream jsonInputStream, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) throws IOException {
        JsonFactory jsonFactory = new JsonFactory();
        Throwable throwable = null;
        Object var7_8 = null;
        try (JsonParser jsonParser = jsonFactory.createParser(jsonInputStream);){
            while (jsonParser.nextToken() != null) {
                this.parseTestCasesArray(projectIdsReferences, pivotImportMetadata, jsonParser, pivotFormatImport);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void parseTestCasesArray(ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, JsonParser jsonParser, PivotFormatImport pivotFormatImport) throws IOException {
        testCasesToImport = new ArrayList<TestCaseToImport>();
        if ("test_cases".equals(jsonParser.getCurrentName())) ** GOTO lbl10
        return;
lbl-1000:
        // 1 sources

        {
            if (PivotJsonParsingHelper.isStartingToParseNewObject(jsonParser)) {
                testCaseToImport = this.testCaseWorkspaceParser.parseTestCase(jsonParser, pivotImportMetadata, pivotFormatImport);
                testCasesToImport.add(testCaseToImport);
            }
            if (testCasesToImport.size() != 100) continue;
            this.createTestCases(testCasesToImport, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
lbl10:
            // 3 sources

            ** while (PivotJsonParsingHelper.isNotTheEndOfParsedArray((JsonParser)jsonParser))
        }
lbl11:
        // 1 sources

        if (!testCasesToImport.isEmpty()) {
            this.createTestCases(testCasesToImport, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
        }
    }

    private void createTestCases(List<TestCaseToImport> testCasesToImport, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        for (TestCaseToImport testCaseToImport : testCasesToImport) {
            PivotFormatLoggerHelper.logEntityCreationStarted(LOGGER, "test case", testCaseToImport.getInternalId(), pivotFormatImport);
            try {
                TestCase testCase = this.createTestCase(testCaseToImport, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
                this.createTestStepsForTestCase(testCaseToImport, testCase, pivotImportMetadata, pivotFormatImport);
            }
            catch (Exception e) {
                PivotFormatLoggerHelper.handleEntityCreationFailed(LOGGER, "test case", testCaseToImport.getName(), testCaseToImport.getInternalId(), pivotFormatImport, e);
            }
            PivotFormatLoggerHelper.logEntityCreatedSuccessfully(LOGGER, "test case", testCaseToImport.getName(), testCaseToImport.getInternalId(), pivotFormatImport);
        }
        testCasesToImport.clear();
        this.entityManager.flush();
        this.entityManager.clear();
    }

    private TestCase createTestCase(TestCaseToImport testCaseToImport, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) throws IOException {
        Long squashTargetId = pivotImportMetadata.getTestCaseFoldersIdsMap().get(testCaseToImport.getParentId());
        TestCase squashTestCase = switch (testCaseToImport.getParentType()) {
            case EntityType.TEST_CASE_LIBRARY -> this.testCaseLibraryNavigationService.addTestCaseToLibraryUnsecured(projectIdsReferences.getTestCaseLibraryId(), testCaseToImport.toTestCase(), testCaseToImport.getCustomFields(), null, new ArrayList<Long>());
            case EntityType.TEST_CASE_FOLDER -> this.testCaseLibraryNavigationService.addTestCaseToFolderUnsecured(squashTargetId, testCaseToImport.toTestCase(), testCaseToImport.getCustomFields(), null, new ArrayList<Long>());
            default -> throw new IllegalArgumentException("This entity type is not handled " + testCaseToImport.getParentType());
        };
        pivotImportMetadata.getTestCaseIdsMap().put(testCaseToImport.getInternalId(), squashTestCase.getId());
        this.addVerifiedRequirementsToTestCase(pivotImportMetadata.getRequirementIdsMap(), testCaseToImport.getVerifiedRequirementIds(), squashTestCase);
        this.addDatasetParamsToTestCase(squashTestCase, testCaseToImport, pivotImportMetadata.getDatasetParamIdsMap(), pivotFormatImport);
        this.addDatasetsToTestCase(squashTestCase, testCaseToImport.getDataSets(), pivotImportMetadata);
        this.attachmentPivotImportService.addAttachmentsToEntity(testCaseToImport.getAttachments(), new AttachmentHolderInfo(squashTestCase.getId(), squashTestCase.getAttachmentList().getId(), EntityType.TEST_CASE, testCaseToImport.getInternalId()), pivotFormatImport, pivotImportMetadata);
        return squashTestCase;
    }

    private void addDatasetParamsToTestCase(TestCase squashTestCase, TestCaseToImport testCaseToImport, Map<String, Long> datasetParamIdsMap, PivotFormatImport pivotFormatImport) {
        this.logStartingDatasetParamsImportForTestCase(testCaseToImport, pivotFormatImport);
        testCaseToImport.getDatasetParams().forEach(datasetParam -> {
            try {
                Parameter parameter = this.parameterModificationService.addNewParameterToTestCaseUnsecured(datasetParam.toDatasetParameter(), squashTestCase);
                datasetParamIdsMap.put(datasetParam.getInternalId(), parameter.getId());
                this.logDatasetParamImportedSuccessfully((DatasetParamToImport)datasetParam, squashTestCase, pivotFormatImport);
            }
            catch (Exception e) {
                TestCasePivotImporterServiceImpl.logDatasetParamImportFailed(datasetParam, squashTestCase, pivotFormatImport, e);
                throw e;
            }
        });
    }

    private void addDatasetsToTestCase(TestCase squashTestCase, List<DatasetToImport> dataSets, PivotImportMetadata pivotImportMetadata) {
        dataSets.forEach(datasetToImport -> {
            Dataset dataset = this.datasetModificationService.persistUnsecured(datasetToImport.toDataset(this.parameterFinder, pivotImportMetadata.getDatasetParamIdsMap()), squashTestCase);
            pivotImportMetadata.getDatasetIdsMap().put(datasetToImport.getInternalId(), dataset.getId());
        });
    }

    private void createTestStepsForTestCase(TestCaseToImport testCaseToImport, TestCase testCase, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) throws IOException {
        this.logStartingTestStepsImportForTestCase(testCaseToImport, pivotFormatImport);
        if (TestCaseKind.STANDARD.equals((Object)TestCaseKind.valueOf((String)testCaseToImport.getTestCaseKind()))) {
            this.createActionTestSteps(testCaseToImport.getActionTestSteps(), testCase, pivotImportMetadata, pivotFormatImport);
        } else if (TestCaseKind.KEYWORD.equals((Object)TestCaseKind.valueOf((String)testCaseToImport.getTestCaseKind()))) {
            this.createKeywordTestSteps(testCaseToImport.getKeywordTestSteps(), testCase, pivotImportMetadata, pivotFormatImport);
        }
    }

    private void createActionTestSteps(List<ActionTestStepToImport> actionTestSteps, TestCase testCase, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) throws IOException {
        for (ActionTestStepToImport actionTestStepToImport : actionTestSteps) {
            try {
                ActionTestStep testStep = this.testCaseModificationService.addActionTestStepUnsecured(testCase, actionTestStepToImport.toActionTestStep(), actionTestStepToImport.getCustomFields());
                this.addVerifiedRequirementsToTestStep(pivotImportMetadata.getRequirementIdsMap(), actionTestStepToImport, testStep, testCase);
                pivotImportMetadata.getTestStepsIdsMap().put(actionTestStepToImport.getInternalId(), testStep.getId());
                this.attachmentPivotImportService.addAttachmentsToEntity(actionTestStepToImport.getAttachments(), new AttachmentHolderInfo(testCase.getId(), testStep.getAttachmentList().getId(), EntityType.ACTION_TEST_STEP, actionTestStepToImport.getInternalId()), pivotFormatImport, pivotImportMetadata);
                this.logActionTestStepImportedSuccessfully(actionTestStepToImport, testCase, pivotFormatImport);
            }
            catch (Exception e) {
                TestCasePivotImporterServiceImpl.logActionTestStepImportFailed(actionTestStepToImport, testCase, pivotFormatImport, e);
                throw e;
            }
        }
    }

    private void createKeywordTestSteps(List<KeywordTestStepToImport> keywordTestSteps, TestCase testCase, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        keywordTestSteps.forEach(keywordStep -> {
            try {
                KeywordTestStepToImport keywordTestStepToImport = keywordStep;
                JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)keywordTestStepToImport);
                Object[] objectArray = new Object[]{this, keywordTestStepToImport, joinPoint};
                TestCasePivotImporterServiceImpl$AjcClosure1 testCasePivotImporterServiceImpl$AjcClosure1 = new TestCasePivotImporterServiceImpl$AjcClosure1(objectArray);
                KeywordTestStep testStep = this.testCaseModificationService.addKeywordTestStep((long)testCase.getId(), keywordStep.getKeyword().name(), (String)CleanHtmlAspect.aspectOf().aroundCleanHtmlMethodExecution(testCasePivotImporterServiceImpl$AjcClosure1.linkClosureAndJoinPoint(4112)));
                testStep.setDocstring(keywordStep.getDocString());
                KeywordTestStepToImport keywordTestStepToImport2 = keywordStep;
                JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)keywordTestStepToImport2);
                Object[] objectArray2 = new Object[]{this, keywordTestStepToImport2, joinPoint2};
                TestCasePivotImporterServiceImpl$AjcClosure3 testCasePivotImporterServiceImpl$AjcClosure3 = new TestCasePivotImporterServiceImpl$AjcClosure3(objectArray2);
                testStep.setComment((String)CleanHtmlAspect.aspectOf().aroundCleanHtmlMethodExecution(testCasePivotImporterServiceImpl$AjcClosure3.linkClosureAndJoinPoint(4112)));
                testStep.setDatatable(keywordStep.getDataTable());
                pivotImportMetadata.getTestStepsIdsMap().put(keywordStep.getInternalId(), testStep.getId());
                this.logKeywordTestStepImportedSuccessfully((KeywordTestStepToImport)keywordStep, testCase, pivotFormatImport);
            }
            catch (Exception e) {
                TestCasePivotImporterServiceImpl.logKeywordTestStepImportFailed(keywordStep, testCase, pivotFormatImport, e);
                throw e;
            }
        });
    }

    private void addVerifiedRequirementsToTestCase(Map<String, Long> requirementIdsMap, List<String> internalVerifiedRequirementIds, TestCase testCase) {
        List<Long> verifiedRequirementIds = internalVerifiedRequirementIds.stream().map(requirementIdsMap::get).toList();
        this.verifiedRequirementsManagerService.addVerifiedRequirementsToTestCaseUnsecured(verifiedRequirementIds, testCase);
    }

    private void addVerifiedRequirementsToTestStep(Map<String, Long> requirementIdsMap, ActionTestStepToImport actionTestStepToImport, ActionTestStep testStep, TestCase testCase) {
        List<String> internalVerifiedRequirementIds = actionTestStepToImport.getVerifiedRequirementIds();
        List<Long> verifiedRequirementIds = internalVerifiedRequirementIds.stream().map(requirementIdsMap::get).toList();
        this.verifiedRequirementsManagerService.addVerifiedRequirementsToTestStepUnsecured(verifiedRequirementIds, testStep, testCase);
    }

    @Override
    public void importCalledTestCasesFromZipArchive(ZipFile zipFile, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) throws IOException {
        PivotFormatLoggerHelper.logImportStartedForEntitiesKind(LOGGER, zipFile.getName(), "called test cases", pivotFormatImport);
        ZipEntry entry = zipFile.getEntry(JsonImportFile.CALLED_TEST_CASES.getFileName());
        if (Objects.nonNull(entry)) {
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (InputStream jsonInputStream = zipFile.getInputStream(entry);){
                    this.handleCalledTestCasesInJsonFile(jsonInputStream, pivotImportMetadata, pivotFormatImport);
                    PivotFormatLoggerHelper.logImportSuccessForEntitiesKind(LOGGER, "called test cases", pivotFormatImport);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                PivotFormatLoggerHelper.logImportFailureForEntitiesKind(LOGGER, "called test cases", pivotFormatImport);
                throw e;
            }
        }
    }

    private void handleCalledTestCasesInJsonFile(InputStream jsonInputStream, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) throws IOException {
        JsonFactory jsonFactory = new JsonFactory();
        Throwable throwable = null;
        Object var6_7 = null;
        try (JsonParser jsonParser = jsonFactory.createParser(jsonInputStream);){
            while (jsonParser.nextToken() != null) {
                this.parseCalledTestCasesArray(pivotImportMetadata, jsonParser, pivotFormatImport);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        jsonInputStream.close();
    }

    private void parseCalledTestCasesArray(PivotImportMetadata pivotImportMetadata, JsonParser jsonParser, PivotFormatImport pivotFormatImport) throws IOException {
        ArrayList<CalledTestCaseStepToImport> calledTestCaseStepToImports = new ArrayList<CalledTestCaseStepToImport>();
        if ("called_test_cases".equals(jsonParser.getCurrentName())) {
            while (PivotJsonParsingHelper.isNotTheEndOfParsedArray(jsonParser)) {
                if (PivotJsonParsingHelper.isStartingToParseNewObject(jsonParser)) {
                    CalledTestCaseStepToImport calledTestCaseStepToImport = this.testCaseWorkspaceParser.parseCalledTestCase(jsonParser, pivotFormatImport);
                    calledTestCaseStepToImports.add(calledTestCaseStepToImport);
                }
                if (calledTestCaseStepToImports.size() != 100) continue;
                this.createCalledTestCases(calledTestCaseStepToImports, pivotImportMetadata, pivotFormatImport);
            }
            if (!calledTestCaseStepToImports.isEmpty()) {
                this.createCalledTestCases(calledTestCaseStepToImports, pivotImportMetadata, pivotFormatImport);
            }
        }
    }

    private void createCalledTestCases(List<CalledTestCaseStepToImport> calledTestCaseStepToImports, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        for (CalledTestCaseStepToImport calledTestCaseStepToImport : calledTestCaseStepToImports) {
            PivotFormatLoggerHelper.logEntityCreationStarted(LOGGER, "called test case", calledTestCaseStepToImport.getInternalId(), pivotFormatImport);
            try {
                this.createCalledTestCase(calledTestCaseStepToImport, pivotImportMetadata);
                PivotFormatLoggerHelper.logUnnamedEntityCreatedSuccessfully(LOGGER, "called test case", calledTestCaseStepToImport.getInternalId(), pivotFormatImport);
            }
            catch (Exception e) {
                PivotFormatLoggerHelper.handleUnnamedEntityCreationFailed(LOGGER, "called test case", calledTestCaseStepToImport.getInternalId(), pivotFormatImport, e);
            }
        }
        calledTestCaseStepToImports.clear();
        this.entityManager.flush();
        this.entityManager.clear();
    }

    private void createCalledTestCase(CalledTestCaseStepToImport calledTestCaseStepToImport, PivotImportMetadata pivotImportMetadata) {
        Long squashCallerTestCaseId = pivotImportMetadata.getTestCaseIdsMap().get(calledTestCaseStepToImport.getCallerId());
        Long squashCalledTestCaseId = pivotImportMetadata.getTestCaseIdsMap().get(calledTestCaseStepToImport.getCalledTestCaseInternalId());
        CallTestStep callTestStep = Objects.nonNull(calledTestCaseStepToImport.getIndex()) ? this.callStepManager.addCallTestStepUnsecured(squashCallerTestCaseId, squashCalledTestCaseId, calledTestCaseStepToImport.getIndex()) : this.callStepManager.addCallTestStepUnsecured(squashCallerTestCaseId, squashCalledTestCaseId);
        this.handleCalledTestCaseDataset(callTestStep, squashCallerTestCaseId, calledTestCaseStepToImport, pivotImportMetadata.getDatasetIdsMap());
        pivotImportMetadata.getTestStepsIdsMap().put(calledTestCaseStepToImport.getInternalId(), callTestStep.getId());
    }

    private void handleCalledTestCaseDataset(CallTestStep callTestStep, Long squashCallerTestCaseId, CalledTestCaseStepToImport calledTestCaseStepToImport, Map<String, Long> datasetIdsMap) {
        if (ParameterAssignationMode.CALLED_DATASET.equals((Object)calledTestCaseStepToImport.getParameterAssignationMode()) && Objects.nonNull(calledTestCaseStepToImport.getInternalDatasetId())) {
            Long squashDatasetId = datasetIdsMap.get(calledTestCaseStepToImport.getInternalDatasetId());
            this.callStepManager.setParameterAssignationModeUnsecured(callTestStep, squashCallerTestCaseId, calledTestCaseStepToImport.getParameterAssignationMode(), squashDatasetId);
        } else {
            this.callStepManager.setParameterAssignationModeUnsecured(callTestStep, squashCallerTestCaseId, calledTestCaseStepToImport.getParameterAssignationMode(), null);
        }
    }

    private void logStartingDatasetParamsImportForTestCase(TestCaseToImport testCaseToImport, PivotFormatImport pivotFormatImport) {
        LOGGER.debug("Import Id: {} - Starting to dataset params for test case \"{}\". ", new Object[]{pivotFormatImport.getId(), testCaseToImport.getName()});
    }

    private void logDatasetParamImportedSuccessfully(DatasetParamToImport datasetParamToImport, TestCase testCase, PivotFormatImport pivotFormatImport) {
        LOGGER.debug("Import Id: {} - Dataset param with name {} and with internal id {} imported successfully for test case \"{}\" successfully.", new Object[]{pivotFormatImport.getId(), datasetParamToImport.getName(), datasetParamToImport.getInternalId(), testCase.getName()});
    }

    private static void logDatasetParamImportFailed(DatasetParamToImport datasetParamToImport, TestCase testCase, PivotFormatImport pivotFormatImport, Exception e) {
        LOGGER.error("Import Id: {} - Error while importing dataset param with name {} internal id {} for test case \"{}\".", new Object[]{pivotFormatImport.getId(), datasetParamToImport.getName(), datasetParamToImport.getInternalId(), testCase.getName(), e});
    }

    private void logStartingTestStepsImportForTestCase(TestCaseToImport testCaseToImport, PivotFormatImport pivotFormatImport) {
        LOGGER.debug("Import Id: {} - Starting to import test steps for test case \"{}\". ", new Object[]{pivotFormatImport.getId(), testCaseToImport.getName()});
    }

    private void logActionTestStepImportedSuccessfully(ActionTestStepToImport actionTestStepToImport, TestCase testCase, PivotFormatImport pivotFormatImport) {
        LOGGER.debug("Import Id: {} - Action test step with internal id {} imported successfully for test case \"{}\" successfully.", new Object[]{pivotFormatImport.getId(), actionTestStepToImport.getInternalId(), testCase.getName()});
    }

    private static void logActionTestStepImportFailed(ActionTestStepToImport actionTestStepToImport, TestCase testCase, PivotFormatImport pivotFormatImport, Exception e) {
        LOGGER.error("Import Id: {} - Error while importing action test step with internal id {} for test case \"{}\".", new Object[]{pivotFormatImport.getId(), actionTestStepToImport.getInternalId(), testCase.getName(), e});
    }

    private void logKeywordTestStepImportedSuccessfully(KeywordTestStepToImport keywordTestStepToImport, TestCase testCase, PivotFormatImport pivotFormatImport) {
        LOGGER.debug("Import Id: {} - Keyword test step with internal id {} imported successfully for test case \"{}\" successfully.", new Object[]{pivotFormatImport.getId(), keywordTestStepToImport.getInternalId(), testCase.getName()});
    }

    private static void logKeywordTestStepImportFailed(KeywordTestStepToImport keywordTestStepToImport, TestCase testCase, PivotFormatImport pivotFormatImport, Exception e) {
        LOGGER.error("Import Id: {} - Error while importing keyword test step with internal id {} for test case \"{}\"", new Object[]{pivotFormatImport.getId(), keywordTestStepToImport.getInternalId(), testCase.getName(), e});
    }

    static final /* synthetic */ String getActionWord_aroundBody0(TestCasePivotImporterServiceImpl testCasePivotImporterServiceImpl, KeywordTestStepToImport keywordTestStepToImport, JoinPoint joinPoint) {
        return keywordTestStepToImport.getActionWord();
    }

    static final /* synthetic */ String getComment_aroundBody2(TestCasePivotImporterServiceImpl testCasePivotImporterServiceImpl, KeywordTestStepToImport keywordTestStepToImport, JoinPoint joinPoint) {
        return keywordTestStepToImport.getComment();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TestCasePivotImporterServiceImpl.java", TestCasePivotImporterServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "getActionWord", "org.squashtest.tm.service.internal.dto.projectimporter.testcaseworkspace.KeywordTestStepToImport", "", "", "", "java.lang.String"), 391);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "getComment", "org.squashtest.tm.service.internal.dto.projectimporter.testcaseworkspace.KeywordTestStepToImport", "", "", "", "java.lang.String"), 393);
    }
}

