/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.projectimporter.pivotimporter;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.env.Environment;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.web.multipart.MultipartFile;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.projectimporter.PivotFormatImport;
import org.squashtest.tm.domain.projectimporter.PivotFormatImportStatus;
import org.squashtest.tm.domain.projectimporter.PivotFormatImportType;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.exception.CouldNotParseJsonFileException;
import org.squashtest.tm.exception.pivotformatimport.CouldNotCreateEntityDuringImportException;
import org.squashtest.tm.exception.pivotformatimport.CouldNotCreateImportFileException;
import org.squashtest.tm.exception.pivotformatimport.InvalidJsonFileNameForImport;
import org.squashtest.tm.exception.pivotformatimport.NoDataImportedException;
import org.squashtest.tm.exception.projectimport.CannotDeleteImportStatusRunningException;
import org.squashtest.tm.exception.projectimport.CannotDeletePivotFileException;
import org.squashtest.tm.service.configuration.ConfigurationService;
import org.squashtest.tm.service.internal.dto.projectimporter.ImportWarningEntry;
import org.squashtest.tm.service.internal.dto.projectimporter.JsonImportFile;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotImportMetadata;
import org.squashtest.tm.service.internal.dto.projectimporter.ProjectIdsReferences;
import org.squashtest.tm.service.internal.repository.PivotFormatImportDao;
import org.squashtest.tm.service.internal.repository.hibernate.CustomPivotFormatImportDao;
import org.squashtest.tm.service.project.GenericProjectManagerService;
import org.squashtest.tm.service.projectimporter.pivotimporter.CustomFieldPivotImporterService;
import org.squashtest.tm.service.projectimporter.pivotimporter.ExecutionWorkspacePivotImporterService;
import org.squashtest.tm.service.projectimporter.pivotimporter.FolderPivotImporterService;
import org.squashtest.tm.service.projectimporter.pivotimporter.GlobalProjectPivotImporterService;
import org.squashtest.tm.service.projectimporter.pivotimporter.PivotJsonParsingHelper;
import org.squashtest.tm.service.projectimporter.pivotimporter.RequirementPivotImporterService;
import org.squashtest.tm.service.projectimporter.pivotimporter.TestCasePivotImporterService;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.security.PermissionsUtils;
import org.squashtest.tm.service.user.UserAccountService;

@Service(value="GlobalProjectPivotImporterService")
public class GlobalProjectPivotImporterServiceImpl
implements GlobalProjectPivotImporterService {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalProjectPivotImporterServiceImpl.class);
    private static final String FILES_DIR = "Files";
    private static final String LOGS_DIR = "Logs";
    @Inject
    private PivotFormatImportDao pivotFormatImportDao;
    private final CustomPivotFormatImportDao customPivotFormatImportDao;
    private final GenericProjectManagerService genericProjectManager;
    private final UserAccountService userAccountService;
    private final CustomFieldPivotImporterService customFieldImporterService;
    private final FolderPivotImporterService folderImporterService;
    private final RequirementPivotImporterService requirementImporterService;
    private final TestCasePivotImporterService testCaseImporterService;
    private final ExecutionWorkspacePivotImporterService executionWorkspacePivotImporterService;
    private final PlatformTransactionManager transactionManager;
    private final PermissionEvaluationService permissionEvaluationService;
    private final ConfigurationService configurationService;
    private final Environment environment;
    @PersistenceContext
    private EntityManager entityManager;

    public GlobalProjectPivotImporterServiceImpl(CustomPivotFormatImportDao customPivotFormatImportDao, GenericProjectManagerService genericProjectManager, UserAccountService userAccountService, CustomFieldPivotImporterService customFieldImporterService, FolderPivotImporterService folderImporterService, RequirementPivotImporterService requirementImporterService, TestCasePivotImporterService testCaseImporterService, ExecutionWorkspacePivotImporterService executionWorkspacePivotImporterService, PlatformTransactionManager transactionManager, PermissionEvaluationService permissionEvaluationService, ConfigurationService configurationService, Environment environment) {
        this.customPivotFormatImportDao = customPivotFormatImportDao;
        this.genericProjectManager = genericProjectManager;
        this.userAccountService = userAccountService;
        this.customFieldImporterService = customFieldImporterService;
        this.folderImporterService = folderImporterService;
        this.requirementImporterService = requirementImporterService;
        this.testCaseImporterService = testCaseImporterService;
        this.executionWorkspacePivotImporterService = executionWorkspacePivotImporterService;
        this.transactionManager = transactionManager;
        this.permissionEvaluationService = permissionEvaluationService;
        this.configurationService = configurationService;
        this.environment = environment;
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'IMPORT')  or hasRole('ROLE_ADMIN')")
    @Transactional
    public void createImportRequest(long projectId, MultipartFile multipartFile, String importName, PivotFormatImportType importType) {
        User currentUser = this.userAccountService.findCurrentUser();
        String filesFolderPath = this.getFilesFolderPath(importType);
        try {
            GlobalProjectPivotImporterServiceImpl.checkJsonFile(multipartFile);
            File filesFolder = new File(filesFolderPath);
            if (!filesFolder.exists()) {
                filesFolder.mkdirs();
            }
            String importFileName = this.generateImportFileName(multipartFile);
            File importFile = new File(filesFolderPath, importFileName);
            multipartFile.transferTo(importFile);
            importFile.createNewFile();
            PivotFormatImport pivotFormatImport = new PivotFormatImport();
            if (Objects.nonNull(projectId)) {
                GenericProject project = this.genericProjectManager.findById(projectId);
                pivotFormatImport.setProject((Project)project);
            }
            pivotFormatImport.setName(importName);
            pivotFormatImport.setCreatedBy(currentUser);
            pivotFormatImport.setCreatedOn(new Date());
            pivotFormatImport.setType(importType);
            pivotFormatImport.setFilePath(importFile.getPath());
            this.pivotFormatImportDao.save(pivotFormatImport);
        }
        catch (IOException e) {
            LOGGER.error("GlobalProjectPivotImporterService - Failed to create import file \"{}\" in folder path: {}", new Object[]{multipartFile.getOriginalFilename(), filesFolderPath, e});
            throw new CouldNotCreateImportFileException();
        }
    }

    private static void checkJsonFile(MultipartFile multipartFile) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ZipInputStream zis = new ZipInputStream(multipartFile.getInputStream());){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                String entryName = entry.getName();
                if (!entryName.endsWith(".json")) continue;
                GlobalProjectPivotImporterServiceImpl.checkJsonFileName(entryName);
                GlobalProjectPivotImporterServiceImpl.checkJsonSyntaxError(entry, zis);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void checkJsonFileName(String entryName) {
        boolean nameIsValid = EnumSet.allOf(JsonImportFile.class).stream().anyMatch(enumEntry -> enumEntry.getFileName().equals(entryName));
        if (!nameIsValid) {
            String message = String.format("Invalid json file name for pivot import: \" %s\"", entryName);
            LOGGER.error(message, new Object[0]);
            throw new InvalidJsonFileNameForImport(entryName, message);
        }
    }

    private static void checkJsonSyntaxError(ZipEntry entry, ZipInputStream zis) throws IOException {
        JsonFactory jsonFactory = new JsonFactory();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (JsonParser jsonParser = jsonFactory.createParser((InputStream)zis);){
                jsonParser.disable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
                while (jsonParser.nextToken() != null) {
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (JsonParseException e) {
            String message = String.format("Failed to parse json file with name \" %s\". Please verify the syntax of your file.", entry.getName());
            LOGGER.error(message, (Throwable)e);
            throw new CouldNotParseJsonFileException(entry.getName(), message);
        }
    }

    private String generateImportFileName(MultipartFile multipartFile) {
        String originalFilename = multipartFile.getOriginalFilename();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss-SSS");
        String timestamp = LocalDateTime.now().format(formatter);
        return String.format("%s-%s.%s", FilenameUtils.getBaseName((String)originalFilename), timestamp, FilenameUtils.getExtension((String)originalFilename));
    }

    private String getPivotFormatImportFolderPath() {
        String pivotFormatImportFolderPath = this.environment.getProperty("squash.project-imports.folder-path");
        if (Objects.isNull(pivotFormatImportFolderPath)) {
            LOGGER.error("The property \"squash.project-imports.folder-path\" is not set", new Object[0]);
            throw new CouldNotCreateImportFileException();
        }
        return pivotFormatImportFolderPath;
    }

    private String getFilesFolderPath(PivotFormatImportType importType) {
        Path filesFolderPath = Paths.get(this.getPivotFormatImportFolderPath(), this.getFolderForImportType(importType), FILES_DIR);
        return filesFolderPath.toString();
    }

    private String getFolderForImportType(PivotFormatImportType importType) {
        return StringUtils.capitalize((String)importType.name().toLowerCase());
    }

    @Override
    @Transactional
    public void deleteImportRequests(long projectId, List<Long> idImportRequests) {
        this.checkCanImportPermission(projectId);
        if (idImportRequests.isEmpty()) {
            return;
        }
        List pivotFormatImports = this.pivotFormatImportDao.findAllById(idImportRequests);
        for (PivotFormatImport pivotFormatImport : pivotFormatImports) {
            if (pivotFormatImport.getStatus() == PivotFormatImportStatus.RUNNING) {
                throw new CannotDeleteImportStatusRunningException(String.format("Cannot delete the import \"%s\" #%s because it is running", pivotFormatImport.getName(), pivotFormatImport.getId()), pivotFormatImport.getName());
            }
            this.pivotFormatImportDao.delete(pivotFormatImport);
            this.clearImportFiles(pivotFormatImport);
        }
    }

    private void clearImportFiles(PivotFormatImport pivotFormatImport) {
        File folderFile = new File(this.getPivotFormatImportFolderPath());
        File importFile = new File(pivotFormatImport.getFilePath());
        File importLogFile = new File(this.getImportErrorLogFilePath(pivotFormatImport.getId(), pivotFormatImport.getType()));
        this.checkAndDeleteImportFile(folderFile, importFile, pivotFormatImport);
        this.checkAndDeleteImportFile(folderFile, importLogFile, pivotFormatImport);
    }

    private void checkAndDeleteImportFile(File folderFile, File importFile, PivotFormatImport pivotFormatImport) {
        if (importFile.exists()) {
            this.checkImportFilePath(folderFile, importFile, pivotFormatImport.getName());
            try {
                FileUtils.forceDelete((File)importFile);
            }
            catch (IOException ioException) {
                LOGGER.error("Failed to delete import file \"{}\" in folder path: {}", new Object[]{importFile.getName(), importFile.getPath(), ioException});
                throw new CannotDeletePivotFileException(pivotFormatImport.getName());
            }
        }
    }

    private void checkImportFilePath(File folderFile, File importFile, String importName) {
        if (Objects.isNull(folderFile) || !importFile.toPath().startsWith(folderFile.toPath())) {
            LOGGER.error("Import file is not in the \"Files\" folder directory", new Object[0]);
            throw new CannotDeletePivotFileException(importName);
        }
    }

    @Override
    public void importProject(PivotFormatImport pivotFormatImport) {
        this.permissionEvaluationService.checkAtLeastOneProjectManagementPermissionOrAdmin();
        DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
        transactionDefinition.setPropagationBehavior(3);
        TransactionStatus transaction = this.transactionManager.getTransaction((TransactionDefinition)transactionDefinition);
        PivotFormatImportStatus finalStatus = PivotFormatImportStatus.FAILURE;
        try {
            try {
                this.logImportStarted(pivotFormatImport, false);
                Project project = new Project();
                File importFile = new File(pivotFormatImport.getFilePath());
                Throwable throwable = null;
                Object var8_10 = null;
                try (ZipFile zipFile = new ZipFile(importFile);){
                    this.importProjectInfoFromZipArchive((GenericProject)project, zipFile, pivotFormatImport);
                    ProjectIdsReferences projectIdsReferences = new ProjectIdsReferences((GenericProject)project);
                    finalStatus = this.importEntitiesInProject(zipFile, projectIdsReferences, pivotFormatImport);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                this.transactionManager.commit(transaction);
            }
            catch (Throwable e) {
                this.handleError(pivotFormatImport, transaction, e);
                this.saveFinalImportStatus(pivotFormatImport.getId(), finalStatus);
            }
        }
        finally {
            this.saveFinalImportStatus(pivotFormatImport.getId(), finalStatus);
        }
    }

    @Override
    public void importInExistingProject(PivotFormatImport pivotFormatImport) {
        Project existingProject = pivotFormatImport.getProject();
        this.checkCanImportPermission(existingProject.getId());
        PivotFormatImportStatus finalStatus = PivotFormatImportStatus.FAILURE;
        DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
        transactionDefinition.setPropagationBehavior(3);
        TransactionStatus transaction = this.transactionManager.getTransaction((TransactionDefinition)transactionDefinition);
        try {
            try {
                this.logImportStarted(pivotFormatImport, true);
                ProjectIdsReferences projectIdsReferences = new ProjectIdsReferences((GenericProject)existingProject);
                File importFile = new File(pivotFormatImport.getFilePath());
                Throwable throwable = null;
                Object var9_11 = null;
                try (ZipFile zipFile = new ZipFile(importFile);){
                    finalStatus = this.importEntitiesInProject(zipFile, projectIdsReferences, pivotFormatImport);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                this.transactionManager.commit(transaction);
            }
            catch (Throwable e) {
                this.handleError(pivotFormatImport, transaction, e);
                this.saveFinalImportStatus(pivotFormatImport.getId(), finalStatus);
            }
        }
        finally {
            this.saveFinalImportStatus(pivotFormatImport.getId(), finalStatus);
        }
    }

    private void saveFinalImportStatus(Long importId, PivotFormatImportStatus finalStatus) {
        this.doInTransaction(() -> {
            LOGGER.info("GlobalProjectPivotImporterService - The import with id: {} has ended with status: {}", new Object[]{importId, finalStatus});
            this.customPivotFormatImportDao.updatePivotFormatImportStatus(importId, finalStatus);
            if (PivotFormatImportStatus.SUCCESS.equals((Object)finalStatus) || PivotFormatImportStatus.WARNING.equals((Object)finalStatus)) {
                this.customPivotFormatImportDao.updatePivotFormatImportSuccessfullyImportedOn(importId, new Date());
            }
        });
    }

    private void logImportStarted(PivotFormatImport pivotFormatImport, boolean importInExistingProject) {
        this.doInTransaction(() -> {
            if (importInExistingProject) {
                LOGGER.info("GlobalProjectPivotImporterService - Starting new import with id: {} for project: {}. Project id: {}", new Object[]{pivotFormatImport.getId(), pivotFormatImport.getProject().getName(), pivotFormatImport.getProject().getId()});
            } else {
                LOGGER.info("GlobalProjectPivotImporterService - Starting new import with id: {}. This import will create a new project.", new Object[]{pivotFormatImport.getId()});
            }
            this.customPivotFormatImportDao.updatePivotFormatImportStatus(pivotFormatImport.getId(), PivotFormatImportStatus.RUNNING);
        });
    }

    private void handleError(PivotFormatImport pivotFormatImport, TransactionStatus transaction, Throwable e) {
        this.transactionManager.rollback(transaction);
        String message = String.format(" Import id: %s - Failed to import data in existing project \"%s\" with id %s.", pivotFormatImport.getId(), pivotFormatImport.getProject().getName(), pivotFormatImport.getProject().getId());
        this.createErrorLogFile(pivotFormatImport, e);
        LOGGER.error(message, e);
    }

    private void createErrorLogFile(PivotFormatImport pivotFormatImport, Throwable ex) {
        File logFolder = new File(this.getLogsFolderPath(pivotFormatImport.getType()));
        if (!logFolder.exists()) {
            logFolder.mkdirs();
        }
        String logFilePath = this.getImportErrorLogFilePath(pivotFormatImport.getId(), pivotFormatImport.getType());
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (PrintWriter pw = new PrintWriter(logFilePath);){
                ex.printStackTrace(pw);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.error(String.format("Could not generate error log file for import: %s", pivotFormatImport.getId()), (Throwable)e);
        }
    }

    @Override
    public String getImportErrorLogFilePath(Long importId, PivotFormatImportType importType) {
        return String.format("%s/import-%s-error.log", this.getLogsFolderPath(importType), importId);
    }

    @Override
    public String getImportWarningLogFilePath(Long importId, PivotFormatImportType importType) {
        return String.format("%s/import-%s-warning.log", this.getLogsFolderPath(importType), importId);
    }

    private String getLogsFolderPath(PivotFormatImportType importType) {
        Path logsFolderPath = Paths.get(this.getPivotFormatImportFolderPath(), this.getFolderForImportType(importType), LOGS_DIR);
        return logsFolderPath.toString();
    }

    private PivotFormatImportStatus importEntitiesInProject(ZipFile zipFile, ProjectIdsReferences projectIdsReferences, PivotFormatImport pivotFormatImport) throws IOException {
        boolean importHasWarnings;
        PivotImportMetadata pivotImportMetadata = new PivotImportMetadata();
        this.appendAttachmentLimitsMetadata(pivotImportMetadata);
        this.customFieldImporterService.importCustomFieldsFromZipArchive(zipFile, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
        this.folderImporterService.importFoldersByJsonFileName(zipFile, JsonImportFile.REQUIREMENT_FOLDERS, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
        this.requirementImporterService.importRequirementsFromZipArchive(zipFile, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
        this.folderImporterService.importFoldersByJsonFileName(zipFile, JsonImportFile.TEST_CASE_FOLDERS, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
        this.testCaseImporterService.importTestCasesFromZipArchive(zipFile, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
        this.testCaseImporterService.importCalledTestCasesFromZipArchive(zipFile, pivotImportMetadata, pivotFormatImport);
        this.folderImporterService.importFoldersByJsonFileName(zipFile, JsonImportFile.CAMPAIGN_FOLDERS, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
        this.executionWorkspacePivotImporterService.importCampaignsFromZipArchive(zipFile, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
        this.executionWorkspacePivotImporterService.importIterationsFromZipArchive(zipFile, pivotImportMetadata, pivotFormatImport);
        this.executionWorkspacePivotImporterService.importTestSuitesFromZipArchive(zipFile, pivotImportMetadata, pivotFormatImport);
        this.executionWorkspacePivotImporterService.importExecutionsFromZipArchive(zipFile, pivotImportMetadata, pivotFormatImport);
        zipFile.close();
        this.checkIfImportHasImportedAtLeastOneEntity(pivotFormatImport, pivotImportMetadata);
        boolean bl = importHasWarnings = !pivotImportMetadata.getImportWarningEntries().isEmpty();
        if (importHasWarnings) {
            this.createWarningLogFile(pivotImportMetadata.getImportWarningEntries(), pivotFormatImport);
        }
        return importHasWarnings ? PivotFormatImportStatus.WARNING : PivotFormatImportStatus.SUCCESS;
    }

    private void createWarningLogFile(List<ImportWarningEntry> importWarningEntries, PivotFormatImport pivotFormatImport) throws IOException {
        File logFolder = new File(this.getLogsFolderPath(pivotFormatImport.getType()));
        if (!logFolder.exists()) {
            logFolder.mkdirs();
        }
        String logFilePath = this.getImportWarningLogFilePath(pivotFormatImport.getId(), pivotFormatImport.getType());
        GlobalProjectPivotImporterServiceImpl.writeWarningLogToFile(importWarningEntries, logFilePath);
    }

    private static void writeWarningLogToFile(List<ImportWarningEntry> entries, String filePath) throws IOException {
        Set types = entries.stream().map(ImportWarningEntry::entityType).collect(Collectors.toSet());
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(filePath));){
            for (EntityType type : types) {
                writer.write(type.name());
                writer.newLine();
                List<ImportWarningEntry> filteredEntries = entries.stream().filter(e -> e.entityType().equals((Object)type)).toList();
                for (ImportWarningEntry entry : filteredEntries) {
                    writer.write(entry.message());
                    writer.newLine();
                }
                writer.newLine();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void appendAttachmentLimitsMetadata(PivotImportMetadata pivotImportMetadata) {
        String whiteListStr = this.configurationService.findConfiguration("uploadfilter.fileExtensions.whitelist");
        List<String> whiteList = Arrays.stream(whiteListStr.split(",")).map(String::trim).toList();
        pivotImportMetadata.setAttachmentTypeWhiteList(whiteList);
        Long maxAttachmentSizeLimit = Long.valueOf(this.configurationService.findConfiguration("uploadfilter.upload.sizeLimitInBytes"));
        pivotImportMetadata.setMaxAttachmentSize(maxAttachmentSizeLimit);
    }

    private void checkIfImportHasImportedAtLeastOneEntity(PivotFormatImport pivotFormatImport, PivotImportMetadata pivotImportMetadata) {
        if (!pivotImportMetadata.hasAtLeastOneImportedEntity()) {
            String message = String.format("Import Id: %s - No data has been imported. Please check the import file and try again.", pivotFormatImport.getId());
            LOGGER.error(message, new Object[0]);
            throw new NoDataImportedException(message);
        }
    }

    private void importProjectInfoFromZipArchive(GenericProject project, ZipFile zipFile, PivotFormatImport pivotFormatImport) throws IOException {
        LOGGER.info("Import Id: {} -  Starting to create new project from zip archive \"{}\"", new Object[]{pivotFormatImport.getId(), zipFile.getName()});
        ZipEntry entry = zipFile.getEntry(JsonImportFile.PROJECT.getFileName());
        Throwable throwable = null;
        Object var6_7 = null;
        try (InputStream jsonInputStream = zipFile.getInputStream(entry);){
            this.handleProject(jsonInputStream, project, pivotFormatImport);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void handleProject(InputStream jsonInputStream, GenericProject project, PivotFormatImport pivotFormatImport) {
        JsonFactory jsonFactory = new JsonFactory();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (JsonParser jsonParser = jsonFactory.createParser(jsonInputStream);){
                while (jsonParser.nextToken() != null) {
                    if (!"project".equals(jsonParser.getCurrentName())) continue;
                    project = this.parseAndCreateProject(jsonParser, project);
                    LOGGER.info("Import Id: {} - New project \"{}\" created successfully with id {}", new Object[]{pivotFormatImport.getId(), project.getName(), project.getId()});
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            String message = String.format("Import id: %s - Could not create new project named \"%s\"", pivotFormatImport.getId(), project.getName());
            LOGGER.error(message, new Object[0]);
            throw new CouldNotCreateEntityDuringImportException(message, (Throwable)e);
        }
    }

    private GenericProject parseAndCreateProject(JsonParser jsonParser, GenericProject project) throws IOException {
        jsonParser.nextToken();
        while (PivotJsonParsingHelper.isNotTheEndOfParsedObject(jsonParser)) {
            String fieldName = jsonParser.getCurrentName();
            jsonParser.nextToken();
            switch (fieldName) {
                case "name": {
                    project.setName(jsonParser.getText());
                    break;
                }
                case "description": {
                    project.setDescription(jsonParser.getText());
                    break;
                }
                case "label": {
                    project.setLabel(jsonParser.getText());
                    break;
                }
            }
        }
        return this.genericProjectManager.persist(project);
    }

    private void doInTransaction(Runnable runnable) {
        TransactionStatus transaction = null;
        try {
            DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
            transactionDefinition.setPropagationBehavior(3);
            transaction = this.transactionManager.getTransaction((TransactionDefinition)transactionDefinition);
            runnable.run();
            this.entityManager.flush();
            this.entityManager.clear();
            this.transactionManager.commit(transaction);
        }
        catch (Exception ex) {
            if (transaction != null) {
                this.transactionManager.rollback(transaction);
            }
            throw ex;
        }
    }

    private void checkCanImportPermission(long projectId) {
        PermissionsUtils.checkPermission(this.permissionEvaluationService, Collections.singletonList(projectId), Permissions.IMPORT.name(), Project.class.getName());
    }
}

