/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.projectimporter.pivotimporter;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.springframework.stereotype.Service;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.campaign.CampaignFolder;
import org.squashtest.tm.domain.projectimporter.PivotFormatImport;
import org.squashtest.tm.domain.requirement.RequirementFolder;
import org.squashtest.tm.domain.testcase.TestCaseFolder;
import org.squashtest.tm.service.campaign.CampaignLibraryNavigationService;
import org.squashtest.tm.service.internal.dto.projectimporter.FolderToImport;
import org.squashtest.tm.service.internal.dto.projectimporter.JsonImportFile;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotImportMetadata;
import org.squashtest.tm.service.internal.dto.projectimporter.ProjectIdsReferences;
import org.squashtest.tm.service.internal.projectimporter.pivotimporter.AttachmentHolderInfo;
import org.squashtest.tm.service.internal.projectimporter.pivotimporter.PivotFormatLoggerHelper;
import org.squashtest.tm.service.projectimporter.pivotimporter.AttachmentPivotImportService;
import org.squashtest.tm.service.projectimporter.pivotimporter.FolderPivotImporterService;
import org.squashtest.tm.service.projectimporter.pivotimporter.PivotJsonParsingHelper;
import org.squashtest.tm.service.projectimporter.pivotimporter.parsers.FolderParser;
import org.squashtest.tm.service.requirement.RequirementLibraryNavigationService;
import org.squashtest.tm.service.testcase.TestCaseLibraryNavigationService;

@Service(value="FolderPivotImporterService")
public class FolderPivotImporterServiceImpl
implements FolderPivotImporterService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FolderPivotImporterServiceImpl.class);
    private final RequirementLibraryNavigationService requirementLibraryNavigationService;
    private final TestCaseLibraryNavigationService testCaseLibraryNavigationService;
    private final CampaignLibraryNavigationService campaignLibraryNavigationService;
    private final FolderParser folderParser;
    private final AttachmentPivotImportService attachmentPivotImportService;
    @PersistenceContext
    private EntityManager entityManager;

    public FolderPivotImporterServiceImpl(RequirementLibraryNavigationService requirementLibraryNavigationService, TestCaseLibraryNavigationService testCaseLibraryNavigationService, CampaignLibraryNavigationService campaignLibraryNavigationService, FolderParser folderParser, AttachmentPivotImportService attachmentPivotImportService) {
        this.requirementLibraryNavigationService = requirementLibraryNavigationService;
        this.testCaseLibraryNavigationService = testCaseLibraryNavigationService;
        this.campaignLibraryNavigationService = campaignLibraryNavigationService;
        this.folderParser = folderParser;
        this.attachmentPivotImportService = attachmentPivotImportService;
    }

    @Override
    public void importFoldersByJsonFileName(ZipFile zipFile, JsonImportFile jsonFile, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) throws IOException {
        PivotFormatLoggerHelper.logImportStartedForEntitiesKind(LOGGER, zipFile.getName(), PivotFormatLoggerHelper.getFolderEntityKindNameFromJsonFile(jsonFile, true), pivotFormatImport);
        ZipEntry entry = zipFile.getEntry(jsonFile.getFileName());
        if (Objects.nonNull(entry)) {
            try {
                Throwable throwable = null;
                Object var8_10 = null;
                try (InputStream jsonInputStream = zipFile.getInputStream(entry);){
                    this.handleFoldersInJsonFile(jsonInputStream, jsonFile, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
                    PivotFormatLoggerHelper.logImportSuccessForEntitiesKind(LOGGER, PivotFormatLoggerHelper.getFolderEntityKindNameFromJsonFile(jsonFile, true), pivotFormatImport);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                PivotFormatLoggerHelper.logImportFailureForEntitiesKind(LOGGER, PivotFormatLoggerHelper.getFolderEntityKindNameFromJsonFile(jsonFile, true), pivotFormatImport);
                throw e;
            }
        }
    }

    private void handleFoldersInJsonFile(InputStream jsonInputStream, JsonImportFile jsonFile, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) throws IOException {
        JsonFactory jsonFactory = new JsonFactory();
        Throwable throwable = null;
        Object var8_9 = null;
        try (JsonParser jsonParser = jsonFactory.createParser(jsonInputStream);){
            while (jsonParser.nextToken() != null) {
                this.parseFoldersArray(jsonFile, projectIdsReferences, pivotImportMetadata, jsonParser, pivotFormatImport);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void parseFoldersArray(JsonImportFile jsonFile, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, JsonParser jsonParser, PivotFormatImport pivotFormatImport) throws IOException {
        foldersToImport = new ArrayList<FolderToImport>();
        jsonImportField = this.findJsonImportFieldForJsonFile(jsonFile);
        if (jsonImportField.equals(jsonParser.getCurrentName())) ** GOTO lbl11
        return;
lbl-1000:
        // 1 sources

        {
            if (PivotJsonParsingHelper.isStartingToParseNewObject(jsonParser)) {
                folderToImport = this.folderParser.parseFolder(jsonParser, jsonFile, pivotImportMetadata, pivotFormatImport);
                foldersToImport.add(folderToImport);
            }
            if (foldersToImport.size() != 100) continue;
            this.createFolders(foldersToImport, projectIdsReferences, pivotImportMetadata, jsonFile, pivotFormatImport);
lbl11:
            // 3 sources

            ** while (PivotJsonParsingHelper.isNotTheEndOfParsedArray((JsonParser)jsonParser))
        }
lbl12:
        // 1 sources

        if (!foldersToImport.isEmpty()) {
            this.createFolders(foldersToImport, projectIdsReferences, pivotImportMetadata, jsonFile, pivotFormatImport);
        }
    }

    private String findJsonImportFieldForJsonFile(JsonImportFile jsonFileName) {
        return switch (jsonFileName) {
            case JsonImportFile.REQUIREMENT_FOLDERS -> "requirement_folders";
            case JsonImportFile.TEST_CASE_FOLDERS -> "test_case_folders";
            case JsonImportFile.CAMPAIGN_FOLDERS -> "campaign_folders";
            default -> throw new IllegalArgumentException("Invalid json file name: " + (Object)((Object)jsonFileName));
        };
    }

    private void createFolders(List<FolderToImport> foldersToImport, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, JsonImportFile jsonFile, PivotFormatImport pivotFormatImport) {
        for (FolderToImport folderToImport : foldersToImport) {
            PivotFormatLoggerHelper.logEntityCreationStarted(LOGGER, PivotFormatLoggerHelper.getFolderEntityKindNameFromJsonFile(jsonFile, false), folderToImport.getInternalId(), pivotFormatImport);
            try {
                this.createFolder(folderToImport, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
                PivotFormatLoggerHelper.logEntityCreatedSuccessfully(LOGGER, PivotFormatLoggerHelper.getFolderEntityKindNameFromJsonFile(jsonFile, false), folderToImport.getFolder().getName(), folderToImport.getInternalId(), pivotFormatImport);
            }
            catch (Exception e) {
                PivotFormatLoggerHelper.handleEntityCreationFailed(LOGGER, PivotFormatLoggerHelper.getFolderEntityKindNameFromJsonFile(jsonFile, false), folderToImport.getFolder().getName(), folderToImport.getInternalId(), pivotFormatImport, e);
            }
        }
        foldersToImport.clear();
        this.entityManager.flush();
        this.entityManager.clear();
    }

    private void createFolder(FolderToImport folderToImport, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) throws IOException {
        EntityType type = folderToImport.getParentType();
        String internalId = folderToImport.getInternalId();
        Map cufs = folderToImport.getFolder().getCustomFields();
        switch (type) {
            case REQUIREMENT_LIBRARY: {
                RequirementFolder squashFolder = this.requirementLibraryNavigationService.addFolderToLibrary(projectIdsReferences.getRequirementLibraryId(), (RequirementFolder)folderToImport.getFolder().toFolder(EntityType.REQUIREMENT_FOLDER), cufs);
                pivotImportMetadata.getRequirementFoldersIdsMap().put(internalId, squashFolder.getId());
                this.attachmentPivotImportService.addAttachmentsToEntity(folderToImport.getAttachments(), new AttachmentHolderInfo(squashFolder.getId(), squashFolder.getAttachmentList().getId(), EntityType.REQUIREMENT_FOLDER, folderToImport.getInternalId()), pivotFormatImport, pivotImportMetadata);
                break;
            }
            case REQUIREMENT_FOLDER: {
                Long squashTargetId = pivotImportMetadata.getRequirementFoldersIdsMap().get(folderToImport.getParentId());
                RequirementFolder squashFolder = this.requirementLibraryNavigationService.addFolderToFolder(squashTargetId, (RequirementFolder)folderToImport.getFolder().toFolder(EntityType.REQUIREMENT_FOLDER), cufs);
                pivotImportMetadata.getRequirementFoldersIdsMap().put(internalId, squashFolder.getId());
                this.attachmentPivotImportService.addAttachmentsToEntity(folderToImport.getAttachments(), new AttachmentHolderInfo(squashFolder.getId(), squashFolder.getAttachmentList().getId(), EntityType.REQUIREMENT_FOLDER, folderToImport.getInternalId()), pivotFormatImport, pivotImportMetadata);
                break;
            }
            case TEST_CASE_LIBRARY: {
                TestCaseFolder squashFolder = this.testCaseLibraryNavigationService.addFolderToLibrary(projectIdsReferences.getTestCaseLibraryId(), (TestCaseFolder)folderToImport.getFolder().toFolder(EntityType.TEST_CASE_FOLDER), cufs);
                pivotImportMetadata.getTestCaseFoldersIdsMap().put(internalId, squashFolder.getId());
                this.attachmentPivotImportService.addAttachmentsToEntity(folderToImport.getAttachments(), new AttachmentHolderInfo(squashFolder.getId(), squashFolder.getAttachmentList().getId(), EntityType.TEST_CASE_FOLDER, folderToImport.getInternalId()), pivotFormatImport, pivotImportMetadata);
                break;
            }
            case TEST_CASE_FOLDER: {
                Long squashTargetId = pivotImportMetadata.getTestCaseFoldersIdsMap().get(folderToImport.getParentId());
                TestCaseFolder squashFolder = this.testCaseLibraryNavigationService.addFolderToFolder(squashTargetId, (TestCaseFolder)folderToImport.getFolder().toFolder(EntityType.TEST_CASE_FOLDER), cufs);
                pivotImportMetadata.getTestCaseFoldersIdsMap().put(internalId, squashFolder.getId());
                this.attachmentPivotImportService.addAttachmentsToEntity(folderToImport.getAttachments(), new AttachmentHolderInfo(squashFolder.getId(), squashFolder.getAttachmentList().getId(), EntityType.TEST_CASE_FOLDER, folderToImport.getInternalId()), pivotFormatImport, pivotImportMetadata);
                break;
            }
            case CAMPAIGN_LIBRARY: {
                CampaignFolder squashFolder = this.campaignLibraryNavigationService.addFolderToLibrary(projectIdsReferences.getCampaignLibraryId(), (CampaignFolder)folderToImport.getFolder().toFolder(EntityType.CAMPAIGN_FOLDER), cufs);
                pivotImportMetadata.getCampaignFoldersIdsMap().put(internalId, squashFolder.getId());
                this.attachmentPivotImportService.addAttachmentsToEntity(folderToImport.getAttachments(), new AttachmentHolderInfo(squashFolder.getId(), squashFolder.getAttachmentList().getId(), EntityType.CAMPAIGN_FOLDER, folderToImport.getInternalId()), pivotFormatImport, pivotImportMetadata);
                break;
            }
            case CAMPAIGN_FOLDER: {
                Long squashTargetId = pivotImportMetadata.getCampaignFoldersIdsMap().get(folderToImport.getParentId());
                CampaignFolder squashFolder = this.campaignLibraryNavigationService.addFolderToFolder(squashTargetId, (CampaignFolder)folderToImport.getFolder().toFolder(EntityType.CAMPAIGN_FOLDER), cufs);
                pivotImportMetadata.getCampaignFoldersIdsMap().put(internalId, squashFolder.getId());
                this.attachmentPivotImportService.addAttachmentsToEntity(folderToImport.getAttachments(), new AttachmentHolderInfo(squashFolder.getId(), squashFolder.getAttachmentList().getId(), EntityType.CAMPAIGN_FOLDER, folderToImport.getInternalId()), pivotFormatImport, pivotImportMetadata);
                break;
            }
            default: {
                throw new IllegalArgumentException("This entity type is not handled " + type);
            }
        }
    }
}

